/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpBlock;
import com.jetbrains.php.lang.formatter.PhpChainBlock;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.formatter.PhpIndentProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpacingProcessor
extends PhpFormatterUtil
implements SpacingStrategy {
    private static final TokenSet PHPDOC_PARAMETERS_PARTS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opVARIADIC, PhpTokenTypes.opBIT_OR});
    private final CommonCodeStyleSettings mySettings;
    private final PhpCodeStyleSettings myPhpSettings;
    private final ASTNode myNode;
    private final XmlFormattingPolicy myXmlFormattingPolicy;
    private final boolean myDoNotAddChildLFs;
    private boolean isIncomplete;

    PhpSpacingProcessor(@NotNull ASTNode node, CommonCodeStyleSettings settings, PhpCodeStyleSettings phpSettings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (node == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(0);
        }
        if (xmlFormattingPolicy == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
        this.myPhpSettings = phpSettings;
        this.myNode = node;
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
        this.myDoNotAddChildLFs = node.getElementType() == PhpElementTypes.HEREDOC;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        ASTNode node;
        Spacing spacing;
        ASTNode firstChild;
        IElementType parentType;
        if (child2 == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(2);
        }
        if (child1 == null) {
            return null;
        }
        if (child2 instanceof PhpChainBlock) {
            int spacesBefore = this.myPhpSettings.SPACES_AROUND_ARROW ? 1 : 0;
            return Spacing.createSpacing((int)spacesBefore, (int)spacesBefore, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        }
        if (child1 instanceof TemplateXmlTagBlock || child1 instanceof TemplateXmlBlock || child2 instanceof TemplateXmlTagBlock || child2 instanceof TemplateXmlBlock) {
            boolean keepLineBreaks = child1 instanceof PhpBlock || child2 instanceof PhpBlock || this.myXmlFormattingPolicy.getShouldKeepLineBreaks();
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)keepLineBreaks, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        IElementType type = this.myNode.getElementType();
        ASTNode parent = this.myNode.getTreeParent();
        IElementType iElementType = parentType = parent != null ? parent.getElementType() : null;
        if (!(child1 instanceof ASTBlock) || !(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode astNode = ((ASTBlock)child1).getNode();
        ASTNode astNode2 = ((ASTBlock)child2).getNode();
        if (astNode == null || astNode2 == null) {
            return Spacing.getReadOnlySpacing();
        }
        IElementType child1Type = PhpSpacingProcessor.replaceAsWithIdentifierConditionally(type, astNode.getElementType());
        IElementType child2Type = PhpSpacingProcessor.replaceAsWithIdentifierConditionally(type, astNode2.getElementType());
        if (this.isIncomplete || FormatterUtil.isIncomplete((ASTNode)astNode) || PhpSpacingProcessor.isIncompleteParameterList(astNode, astNode2)) {
            this.isIncomplete = true;
            return Spacing.getReadOnlySpacing();
        }
        if (type == PhpElementTypes.STRING || type == PhpElementTypes.SHELL_COMMAND) {
            return Spacing.getReadOnlySpacing();
        }
        if (type == PhpElementTypes.DECLARE && child1Type == PhpTokenTypes.chRPAREN && child2Type == PhpElementTypes.STATEMENT && (firstChild = astNode2.getFirstChildNode()) != null && firstChild.getElementType() == PhpTokenTypes.opSEMICOLON) {
            return this.addSingleSpaceIf(false);
        }
        if (type == DECLARE_DIRECTIVE && (child1Type == PhpTokenTypes.opASGN || child2Type == PhpTokenTypes.opASGN)) {
            return this.addSingleSpaceIf(this.myPhpSettings.SPACE_AROUND_ASSIGNMENT_IN_DECLARE);
        }
        if (child1Type == PhpTokenTypes.PHP_ECHO_OPENING_TAG || PhpSpacingProcessor.isEchoClosingTag(astNode2)) {
            return this.createEchoTagSpacing();
        }
        if (child1Type == PhpTokenTypes.PHP_CLOSING_TAG && child2Type == PhpTokenTypes.PHP_OPENING_TAG) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (PhpFormatterUtil.endsWith(astNode, PhpTokenTypes.PHP_OPENING_TAG) && !PhpSpacingProcessor.isBeforeLineBreak(astNode)) {
            return this.addSingleSpaceIf(true);
        }
        if (PhpFormatterUtil.startsWith(astNode2, PhpTokenTypes.PHP_CLOSING_TAG) && !PhpSpacingProcessor.isAfterLineBreak(astNode2)) {
            if (PhpFormatterUtil.isPrecededBy(astNode2, PhpTokenTypes.LINE_COMMENT)) {
                return Spacing.getReadOnlySpacing();
            }
            return this.addSingleSpaceIf(true);
        }
        if ((child2Type != PhpTokenTypes.chLPAREN || type != PhpStubElementTypes.CLASS_METHOD && type != PhpElementTypes.METHOD_REFERENCE) && (child1Type != PhpTokenTypes.SCOPE_RESOLUTION || type != PhpElementTypes.METHOD_REFERENCE) && (spacing = this.keepSpaceAround(child1Type, child2Type, PhpTokenTypes.kwINSTANCEOF, PhpTokenTypes.opLIT_AND, PhpTokenTypes.opLIT_OR, PhpTokenTypes.opLIT_XOR, PhpTokenTypes.kwAS)) != null) {
            return spacing;
        }
        if (child1Type == PhpTokenTypes.LINE_COMMENT && type != PhpStubElementTypes.CLASS && !(astNode2.getPsi() instanceof PhpDocComment) && (child2Type != RETURN || astNode.getTreePrev() != null && astNode.getTreePrev().textContains('\n'))) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child1Type == PhpElementTypes.HEREDOC) {
            ASTNode next = astNode.getTreeNext();
            if (next != null && next.getElementType() == PhpTokenTypes.opSEMICOLON) {
                return this.addSingleSpaceIf(false);
            }
            boolean flexibleDocs = PhpProjectConfigurationFacade.getInstance(astNode.getPsi().getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.FLEXIBLE_HEREDOCS);
            return this.addLineFeedsAfter(astNode, flexibleDocs ? 0 : 1);
        }
        if (child1Type == PhpTokenTypes.DOLLAR) {
            return this.addSingleSpaceIf(false);
        }
        if (PhpFormatterUtil.isComment(child2Type) && !PhpSpacingProcessor.isFileHeader(astNode2.getPsi())) {
            ASTNode prevNode;
            if (!(astNode2.getPsi() instanceof PhpDocComment || (prevNode = astNode2.getTreePrev()) == null || prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.textContains('\n'))) {
                return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            ASTNode nextSibling = PhpSpacingProcessor.getNonCommentSibling(astNode2, true);
            if (nextSibling != null) {
                astNode2 = nextSibling;
                child2Type = nextSibling.getElementType();
            }
        }
        if (child1Type == PhpTokenTypes.PHP_OPENING_TAG && !PhpSpacingProcessor.isFileHeader(astNode2.getPsi())) {
            return this.getLineFeedsAfterOpeningTag(astNode, astNode2);
        }
        if (PhpSpacingProcessor.isFileHeader(astNode.getPsi())) {
            return this.getLineFeedsAfterOpeningTag(astNode, astNode2);
        }
        if (child1Type == PhpTokenTypes.kwGLOBAL && child2Type == PhpElementTypes.GLOBAL) {
            return this.addSingleSpaceIf(true);
        }
        if (type == PhpStubElementTypes.CLASS) {
            if (child1Type == PhpDocElementTypes.DOC_COMMENT || child1Type == PhpTokenTypes.C_STYLE_COMMENT || child1Type == PhpTokenTypes.LINE_COMMENT && !PhpSpacingProcessor.isEndOfLineComment(astNode) && !(((ASTBlock)child2).getNode().getPsi() instanceof PhpDocComment)) {
                return this.addLineFeedsAfter(astNode, 1);
            }
            int minBlankLines = this.getBlankLinesBetweenClassMembers(astNode, astNode2);
            if (minBlankLines >= 0) {
                return this.getDeclarationBlankLines(minBlankLines);
            }
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(type) && (node = ((ASTBlock)child2).getNode()).getElementType() == PhpStubElementTypes.NAMESPACE) {
            return this.addLineFeedsAfter(node, this.mySettings.BLANK_LINES_BEFORE_PACKAGE + 1);
        }
        if (type == PhpStubElementTypes.NAMESPACE) {
            if (child1Type == PhpTokenTypes.kwNAMESPACE && (child2Type == PhpTokenTypes.IDENTIFIER || child2Type == PhpElementTypes.NS_REFERENCE)) {
                return this.addSingleSpaceIf(true);
            }
            if (child1Type == PhpTokenTypes.opSEMICOLON) {
                return this.getSpacingAfterNamespaceDeclaration(astNode, astNode2.getFirstChildNode());
            }
        }
        if (ANY_GROUP_STATEMENT.contains(type) && parentType == PhpStubElementTypes.NAMESPACE && child1Type == PhpTokenTypes.chLBRACE) {
            return this.getSpacingAfterNamespaceDeclaration(astNode, astNode2);
        }
        int blankLinesBeforeMethodBody = this.getBlankLinesBeforeMethodBody(parentType, type, child1Type, child2Type);
        if (blankLinesBeforeMethodBody > 0) {
            return this.addLineFeedsAfter(astNode, blankLinesBeforeMethodBody, this.myPhpSettings.KEEP_BLANK_LINES_AFTER_LBRACE);
        }
        if (child1Type == PhpTokenTypes.chLBRACE || child2Type == PhpTokenTypes.chRBRACE) {
            if (type != PhpElementTypes.METHOD_REFERENCE && type != PhpElementTypes.FIELD_REFERENCE && type != PhpElementTypes.HEREDOC && type != PhpStubElementTypes.VARIABLE && type != PhpElementTypes.USE_BRACES && !PhpElementTypes.tsARRAY_EXPRESSIONS.contains(type)) {
                if (child1Type == PhpTokenTypes.chLBRACE) {
                    return this.addLineFeedsAfter(astNode, 1, this.myPhpSettings.KEEP_BLANK_LINES_AFTER_LBRACE);
                }
                if (child2Type == PhpTokenTypes.chRBRACE) {
                    return this.addLineFeedsAfter(astNode, 1, this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                }
                return this.addLineFeedsAfter(astNode, 1);
            }
            return this.addSingleSpaceIf(false);
        }
        if (child1Type == PhpElementTypes.CONSTANTS || child2Type == PhpElementTypes.CONSTANTS) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if ((PhpElementTypes.BINARY_EXPRESSIONS.contains(child2Type) || PhpElementTypes.UNARY_EXPRESSIONS.contains(child2Type)) && PhpFormatterUtil.startsWith(astNode2, PhpTokenTypes.opNOT) && this.myPhpSettings.SPACE_BEFORE_UNARY_NOT) {
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpTokenTypes.chLPAREN) {
            if (child2Type == PhpTokenTypes.chRPAREN) {
                return PhpSpacingProcessor.forceSingleSpaceIf(false);
            }
            return this.getParenSpacing(this.myNode, type, child1Type);
        }
        if (child2Type == PhpTokenTypes.chRPAREN) {
            if (PhpSpacingProcessor.endsWith(astNode, PhpElementTypes.HEREDOC)) {
                return this.addLineFeedsAfter(astNode, 1);
            }
            return this.getParenSpacing(this.myNode, type, child2Type);
        }
        if (type == PhpElementTypes.TERNARY_EXPRESSION) {
            if (child1Type == PhpTokenTypes.opQUEST) {
                if (child2Type == PhpTokenTypes.opCOLON) {
                    return PhpSpacingProcessor.forceSingleSpaceIf(this.myPhpSettings.SPACE_BETWEEN_TERNARY_QUEST_AND_COLON);
                }
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_QUEST);
            }
            if (child2Type == PhpTokenTypes.opQUEST) {
                return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_BEFORE_QUEST, this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE);
            }
            if (child1Type == PhpTokenTypes.opCOLON) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COLON);
            }
            if (child2Type == PhpTokenTypes.opCOLON) {
                return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_BEFORE_COLON, this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE);
            }
        }
        if (child1Type == PhpElementTypes.USE_LIST && type != PhpStubElementTypes.FUNCTION) {
            return this.addLineFeedsAfter(astNode, child2Type == PhpElementTypes.USE_LIST ? 1 : this.mySettings.BLANK_LINES_AFTER_IMPORTS + 1);
        }
        if (child2Type == PhpElementTypes.USE_LIST) {
            if (type == PhpStubElementTypes.FUNCTION) {
                return this.addSingleSpaceIf(true);
            }
            return this.addLineFeedsAfter(astNode, child1Type == PhpElementTypes.USE_LIST ? 1 : this.mySettings.BLANK_LINES_BEFORE_IMPORTS + 1);
        }
        if (child2Type == PhpTokenTypes.chLPAREN) {
            if (type == PhpStubElementTypes.FUNCTION || type == PhpStubElementTypes.CLASS_METHOD) {
                if (child1Type == PhpTokenTypes.kwFUNCTION) {
                    return PhpSpacingProcessor.forceSingleSpaceIf(this.myPhpSettings.SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS);
                }
                if (child1Type == PhpTokenTypes.IDENTIFIER || PhpTokenTypes.tsKEYWORDS.contains(child1Type)) {
                    return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
                }
            }
            if (!(type != PhpElementTypes.FUNCTION_CALL && type != PhpElementTypes.METHOD_REFERENCE || child1Type != PhpTokenTypes.IDENTIFIER && !PhpTokenTypes.tsKEYWORDS.contains(child1Type))) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwIF || child1Type == PhpTokenTypes.kwELSEIF) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwWHILE) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwFOR || child1Type == PhpTokenTypes.kwFOREACH) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwSWITCH) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwCATCH) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
            }
            if (child1Type == PhpTokenTypes.kwUSE) {
                return PhpSpacingProcessor.forceSingleSpaceIf(true);
            }
        }
        if (child1Type == PhpTokenTypes.opHASH_ARRAY || child2Type == PhpTokenTypes.opHASH_ARRAY) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (type == PhpStubElementTypes.FUNCTION || type == PhpStubElementTypes.CLASS_METHOD) {
            if (child1Type == PhpTokenTypes.chRPAREN && child2Type == PhpTokenTypes.opCOLON) {
                if (this.myPhpSettings.RETURN_TYPE_ON_NEW_LINE) {
                    return this.addLineFeedsAfter(astNode, 1);
                }
                return PhpSpacingProcessor.forceSingleSpaceIf(this.myPhpSettings.SPACE_BEFORE_COLON_IN_RETURN_TYPE);
            }
            if (child1Type == PhpTokenTypes.opCOLON && child2Type == PhpElementTypes.RETURN_TYPE) {
                return this.addSingleSpaceIf(this.myPhpSettings.SPACE_AFTER_COLON_IN_RETURN_TYPE);
            }
        }
        if (type == PhpElementTypes.RETURN_TYPE && child1Type == PhpTokenTypes.opQUEST) {
            return PhpSpacingProcessor.forceSingleSpaceIf(false);
        }
        if (PhpFormatterUtil.isAssignmentOperator(child1Type) || PhpFormatterUtil.isAssignmentOperator(child2Type)) {
            if (PhpSpacingProcessor.isAssignmentByRefOperatorWithSpaceInside(astNode)) {
                return PhpSpacingProcessor.forceSingleSpaceIf(false);
            }
            if (this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                if (PhpSpacingProcessor.isAssignmentOperator(child2Type)) {
                    return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS, true);
                }
                return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
            }
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (PhpElementTypes.BINARY_EXPRESSIONS.contains(type)) {
            if (PhpFormatterUtil.isLogicalOperator(child1Type) || PhpFormatterUtil.isLogicalOperator(child2Type)) {
                if (this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    if (PhpSpacingProcessor.isLogicalOperator(child2Type) && type == PhpElementTypes.LOGICAL_EXPRESSION) {
                        return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS, true);
                    }
                    return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
                }
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
            }
            if (PhpFormatterUtil.isEqualityOperator(child1Type) || PhpFormatterUtil.isEqualityOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
            }
            if (PhpFormatterUtil.isComparisonOperator(child1Type) || PhpFormatterUtil.isComparisonOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
            }
            if (PhpFormatterUtil.isBitwiseOperator(child1Type) || PhpFormatterUtil.isBitwiseOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
            }
            if (PhpFormatterUtil.isAdditiveOperator(child1Type) || PhpFormatterUtil.isAdditiveOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
            }
            if (child1Type == PhpTokenTypes.opCONCAT || child2Type == PhpTokenTypes.opCONCAT) {
                boolean isSpaceNeeded = this.myPhpSettings.CONCAT_SPACES || PhpSpacingProcessor.endsWith(astNode, PhpElementTypes.NUMBER) || PhpSpacingProcessor.startsWith(astNode2, PhpElementTypes.NUMBER);
                return this.addSingleSpaceIf(isSpaceNeeded);
            }
            if (PhpFormatterUtil.isMultiplicativeOperator(child1Type) || PhpFormatterUtil.isMultiplicativeOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
            }
            if (PhpFormatterUtil.isShiftOperator(child1Type) || PhpFormatterUtil.isShiftOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_SHIFT_OPERATORS);
            }
            if (child1Type == PhpTokenTypes.opCOALESCE || child2Type == PhpTokenTypes.opCOALESCE) {
                return this.addSingleSpaceIf(this.myPhpSettings.SPACES_AROUND_NULL_COALESCE_OPERATOR);
            }
            if (child1Type == PhpTokenTypes.opSPACESHIP || child2Type == PhpTokenTypes.opSPACESHIP) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
            }
        }
        if (type == PhpElementTypes.INFIX_EXPRESSION || type == PhpElementTypes.INFIX_WRITE_EXPRESSION) {
            if (PhpSpacingProcessor.isPlusMinusUnaryOperator(child1Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
            }
            if (child1Type == PhpTokenTypes.opNOT) {
                return this.addSingleSpaceIf(this.myPhpSettings.SPACE_AFTER_UNARY_NOT);
            }
            return this.addSingleSpaceIf(false);
        }
        if (type == PhpElementTypes.POSTFIX_EXPRESSION) {
            if (PhpSpacingProcessor.isPlusMinusUnaryOperator(child2Type)) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
            }
            return this.addSingleSpaceIf(false);
        }
        if ((PhpSpacingProcessor.isBlockGroupStatement(astNode2) || child2Type == PhpTokenTypes.chLBRACE) && (spacing = this.getSpacingBeforeLeftBrace(astNode, astNode2, type)) != null) {
            return spacing;
        }
        if (child1Type == PhpTokenTypes.kwARRAY && child2Type == PhpTokenTypes.chLPAREN) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        }
        if (child2Type == PhpElementTypes.ELSE || child2Type == PhpElementTypes.ELSE_IF) {
            return this.createSpacingBeforeKeyword(astNode, astNode2, this.mySettings.ELSE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_ELSE_KEYWORD);
        }
        if (child2Type == PhpElementTypes.CATCH) {
            return this.createSpacingBeforeKeyword(astNode, null, this.mySettings.CATCH_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_CATCH_KEYWORD);
        }
        if (child2Type == PhpElementTypes.FINALLY) {
            return this.createSpacingBeforeKeyword(astNode, null, this.mySettings.FINALLY_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD);
        }
        if (type == PhpElementTypes.DO_WHILE && child2Type == PhpTokenTypes.kwWHILE) {
            return this.createSpacingBeforeKeyword(astNode, astNode2, this.mySettings.WHILE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_WHILE_KEYWORD);
        }
        if (child1Type == PhpTokenTypes.chLBRACKET || child2Type == PhpTokenTypes.chRBRACKET) {
            if (type == PhpElementTypes.ARRAY_CREATION_EXPRESSION) {
                if (child1Type == PhpTokenTypes.chLBRACKET && child2Type == PhpTokenTypes.chRBRACKET) {
                    return this.addSingleSpaceIf(false);
                }
                if (child1Type == PhpTokenTypes.chLBRACKET) {
                    return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE);
                }
                return this.addConditionalLFSpacing(this.myNode, this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE);
            }
            return PhpSpacingProcessor.forceSingleSpaceIf((child1Type != PhpTokenTypes.chLBRACKET || child2Type != PhpTokenTypes.chRBRACKET) && this.shouldAddSpacesWithinBrackets(this.myNode, type));
        }
        if (child1Type == PhpTokenTypes.opCOMMA) {
            return this.createSpaceAfterComma(this.myNode);
        }
        if (child2Type == PhpTokenTypes.opCOMMA) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_COMMA);
        }
        if (type == PhpElementTypes.FOR) {
            if (child1Type == PhpTokenTypes.opSEMICOLON) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_SEMICOLON);
            }
            if (child2Type == PhpTokenTypes.opSEMICOLON) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_SEMICOLON);
            }
        }
        if (PhpFormatterUtil.isCastOperator(child1Type)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_TYPE_CAST);
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(type)) {
            if (child1Type == PhpStubElementTypes.CLASS || child2Type == PhpStubElementTypes.CLASS) {
                PhpDocComment docComment;
                PsiElement classElement;
                if (child1Type == PhpDocElementTypes.DOC_COMMENT && (classElement = astNode2.getPsi()) instanceof PhpPsiElement && (docComment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)classElement)) == astNode.getPsi()) {
                    return this.addLineFeedsAfter(astNode, 1, 0);
                }
                return this.getDeclarationBlankLines(this.mySettings.BLANK_LINES_AROUND_CLASS);
            }
            if (child1Type == FUNCTION) {
                return this.addLineFeedsAfter(astNode, this.myPhpSettings.BLANK_LINES_AFTER_FUNCTION + 1);
            }
            if (PhpFormatterUtil.isGlobalDeclaration(child1Type)) {
                return this.addLineFeedsAfter(astNode, 2);
            }
            if ((PhpFormatterUtil.someStatementLevel(child1Type) || child1Type == PhpTokenTypes.opSEMICOLON) && child2Type != PhpTokenTypes.PHP_CLOSING_TAG || PhpFormatterUtil.someStatementLevel(child2Type) && child1Type != PhpTokenTypes.PHP_OPENING_TAG) {
                ASTNode firstSubChild;
                if (child2Type == PhpElementTypes.RETURN) {
                    return this.createSpacingBeforeReturn(astNode, astNode2);
                }
                if (child2Type == PhpElementTypes.STATEMENT && (firstSubChild = astNode2.getFirstChildNode()) != null && firstSubChild.getElementType() == PhpTokenTypes.opSEMICOLON) {
                    return PhpSpacingProcessor.forceSingleSpaceIf(false);
                }
                return this.addLineFeedsAfter(astNode, 1);
            }
        }
        if (PhpFormatterUtil.isComment(child1Type)) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child1Type == PhpTokenTypes.kwRETURN && child2Type != PhpTokenTypes.opSEMICOLON) {
            return this.addSingleSpaceIf(true);
        }
        if (PhpFormatterUtil.isCaseBlock(type) && child1Type == PhpTokenTypes.opCOLON || PhpFormatterUtil.isCaseBlock(child1Type) && PhpFormatterUtil.isCaseBlock(child2Type)) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child2Type == PhpElementTypes.EXTENDS_LIST || child2Type == PhpElementTypes.IMPLEMENTS_LIST || child1Type == PhpTokenTypes.kwIMPLEMENTS || child1Type == PhpTokenTypes.kwEXTENDS) {
            return this.addSingleSpaceIf(true);
        }
        if (child2Type == PhpTokenTypes.opSEMICOLON) {
            ASTNode subRef;
            ASTNode prevRefNode;
            if (this.myPhpSettings.MULTILINE_CHAINED_CALLS_SEMICOLON_ON_NEW_LINE && (prevRefNode = PhpSpacingProcessor.getEndingNodeOfType(astNode, PhpElementTypes.METHOD_REFERENCE, PhpElementTypes.FIELD_REFERENCE)) != null && (subRef = prevRefNode.getFirstChildNode()) != null && subRef.getElementType() == PhpElementTypes.METHOD_REFERENCE) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)prevRefNode.getTextRange(), (boolean)false, (int)0);
            }
            return PhpSpacingProcessor.forceSingleSpaceIf(false);
        }
        if (child1Type == PhpTokenTypes.opSEMICOLON) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child1Type == PhpElementTypes.MODIFIER_LIST || PhpFormatterUtil.isModifier(child1Type)) {
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpTokenTypes.ARROW || child2Type == PhpTokenTypes.ARROW) {
            if (child1Type == PhpTokenTypes.ARROW && this.mySettings.METHOD_CALL_CHAIN_WRAP != 0) {
                return PhpSpacingProcessor.forceSingleSpaceIf(this.myPhpSettings.SPACES_AROUND_ARROW);
            }
            return this.addSingleSpaceIf(this.myPhpSettings.SPACES_AROUND_ARROW);
        }
        if (child1Type == PhpDocTokenTypes.DOC_LEADING_ASTERISK && (astNode2.getPsi() instanceof PhpDocTag || child2Type == PhpDocElementTypes.phpDocSpecialTag)) {
            if (PhpDocUtil.isInsidePhpDocAttributeList(astNode.getPsi())) {
                return Spacing.getReadOnlySpacing();
            }
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpTokenTypes.chRPAREN && (child2Type == PhpElementTypes.STATEMENT || PhpElementTypes.STATEMENTS.contains(child2Type))) {
            if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE) {
                return this.addSingleSpaceIf(true);
            }
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child1Type == PhpTokenTypes.kwELSE && child2Type == PhpElementTypes.IF) {
            if (this.myPhpSettings.ELSE_IF_STYLE == PhpCodeStyleSettings.ElseIfStyle.COMBINE && astNode2.findChildByType(PhpTokenTypes.opCOLON) == null) {
                return PhpSpacingProcessor.forceSingleSpaceIf(false);
            }
            if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                return PhpSpacingProcessor.forceSingleSpaceIf(true);
            }
            return this.addSingleSpaceIf(true);
        }
        if (child2Type == PhpDocTokenTypes.DOC_LEADING_ASTERISK) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
        }
        if (child1Type == PhpElementTypes.CLASS_REFERENCE && child2Type == PhpTokenTypes.VARIABLE) {
            return PhpSpacingProcessor.forceSingleSpaceIf(true);
        }
        if (type == PhpDocElementTypes.DOC_COMMENT && astNode.getPsi() instanceof PhpDocTag && child2Type == PhpDocTokenTypes.DOC_COMMENT_END) {
            return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myNode.getTextRange(), (boolean)false, (int)0);
        }
        if (this.myNode.getPsi() instanceof PhpDocTag && child1Type == PhpDocElementTypes.phpDocVariable && child2Type == PhpDocElementTypes.phpDocTagValue) {
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpStubElementTypes.NAMESPACE && child2Type == PhpStubElementTypes.NAMESPACE) {
            return this.addLineFeedsAfter(astNode, 1);
        }
        if (child1Type == PhpTokenTypes.kwECHO || child1Type == PhpTokenTypes.kwINCLUDE || child1Type == PhpTokenTypes.kwINCLUDE_ONCE || child1Type == PhpTokenTypes.kwREQUIRE || child1Type == PhpTokenTypes.kwREQUIRE_ONCE) {
            if (child2Type == PhpElementTypes.PARENTHESIZED_EXPRESSION) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
            }
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpTokenTypes.kwFUNCTION && child2Type == PhpTokenTypes.IDENTIFIER) {
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpDocElementTypes.phpDocType && (child2Type == PhpDocElementTypes.phpDocVariable || child2Type == PhpDocElementTypes.phpDocProperty)) {
            return this.addSingleSpaceIf(true);
        }
        if (child1Type == PhpTokenTypes.opCOLON && PhpElementTypes.STATEMENTS.contains(type) || PhpTokenTypes.ALT_SYNTAX_END_KEYWORDS.contains(child2Type)) {
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (child1Type == PhpTokenTypes.PHP_OPENING_TAG || child2Type == PhpTokenTypes.PHP_CLOSING_TAG) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (!(type != PhpStubElementTypes.PARAMETER || PhpSpacingProcessor.isParameterPrecedingOperator(astNode) || PHPDOC_PARAMETERS_PARTS.contains(child1Type) || PHPDOC_PARAMETERS_PARTS.contains(child2Type) || child2Type == PhpTokenTypes.chLBRACKET)) {
            return PhpSpacingProcessor.forceSingleSpaceIf(true);
        }
        return null;
    }

    private static boolean isIncompleteParameterList(ASTNode parameterList, ASTNode rParenNode) {
        if (!PhpProjectConfigurationFacade.getInstance(parameterList.getPsi().getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL)) {
            return parameterList.getElementType() == PhpElementTypes.PARAMETER_LIST && PhpIndentProcessor.isRParenAfterUnfinishedParamList(rParenNode);
        }
        return false;
    }

    private static IElementType replaceAsWithIdentifierConditionally(IElementType parentType, IElementType childType) {
        if (childType == PhpTokenTypes.kwAS && parentType != PhpStubElementTypes.USE && parentType != PhpElementTypes.FOREACH) {
            return PhpTokenTypes.IDENTIFIER;
        }
        return childType;
    }

    private Spacing getLineFeedsAfterOpeningTag(ASTNode astNode, ASTNode astNode2) {
        int linesAfterOpeningTag = this.myPhpSettings.BLANK_LINES_AFTER_OPENING_TAG;
        if (PhpPsiUtil.isOfType(astNode2, PhpStubElementTypes.NAMESPACE)) {
            return this.addLineFeedsAfter(astNode, Math.max(linesAfterOpeningTag, this.mySettings.BLANK_LINES_BEFORE_PACKAGE) + 1);
        }
        if (PhpPsiUtil.isOfType(astNode2, PhpElementTypes.USE_LIST)) {
            return this.addLineFeedsAfter(astNode, Math.max(linesAfterOpeningTag, this.mySettings.BLANK_LINES_BEFORE_IMPORTS) + 1);
        }
        if (PhpPsiUtil.isOfType(astNode2, PhpStubElementTypes.CLASS)) {
            return this.addLineFeedsAfter(astNode, Math.max(linesAfterOpeningTag, this.mySettings.BLANK_LINES_AROUND_CLASS) + 1);
        }
        return this.addLineFeedsAfter(astNode, linesAfterOpeningTag + 1);
    }

    private static boolean isParameterPrecedingOperator(@NotNull ASTNode node) {
        if (node == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(3);
        }
        return node.getTextLength() == 1 && (node.textContains('&') || node.textContains('?'));
    }

    private Spacing keepSpaceAround(IElementType leftType, IElementType rightType, IElementType ... elementTypes) {
        for (IElementType elementType : elementTypes) {
            if (leftType != elementType && rightType != elementType) continue;
            return this.addSingleSpaceIf(true);
        }
        return null;
    }

    private int getBlankLinesBeforeMethodBody(IElementType parentType, IElementType type, IElementType child1Type, IElementType child2Type) {
        if ((parentType == PhpStubElementTypes.CLASS_METHOD || parentType == PhpStubElementTypes.FUNCTION) && ANY_GROUP_STATEMENT.contains(type) && child1Type == PhpTokenTypes.chLBRACE && child2Type != PhpTokenTypes.chRBRACE) {
            return this.mySettings.BLANK_LINES_BEFORE_METHOD_BODY + 1;
        }
        return -1;
    }

    private Spacing addLineFeedsAfter(ASTNode astNode, int lineFeeds, int blankLinesToKeep) {
        IElementType statementType;
        ASTNode statementNode;
        ASTNode parent = astNode.getTreeParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ANY_GROUP_STATEMENT) && PhpFormatterUtil.isSimpleGroup(parent) && (statementNode = parent.getTreeParent()) != null && ((statementType = statementNode.getElementType()) == PhpStubElementTypes.FUNCTION || statementType == PhpStubElementTypes.CLASS_METHOD) && this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE) {
            TextRange statementRange = statementNode.getTextRange();
            return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)statementRange, (boolean)true, (int)blankLinesToKeep);
        }
        int minLF = this.myDoNotAddChildLFs ? 0 : lineFeeds;
        return Spacing.createSpacing((int)0, (int)0, (int)minLF, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesToKeep);
    }

    private Spacing addLineFeedsAfter(ASTNode astNode, int lineFeeds) {
        int minLF = this.myDoNotAddChildLFs ? 0 : lineFeeds;
        return this.addLineFeedsAfter(astNode, minLF, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing getDeclarationBlankLines(int blankLines) {
        return Spacing.createSpacing((int)0, (int)0, (int)(blankLines + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
    }

    private Spacing addSingleSpaceIf(boolean condition) {
        int spaces = condition ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static Spacing forceSingleSpaceIf(boolean isOptionSet) {
        int spaces = isOptionSet ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @Nullable
    private static ASTNode getNonCommentSibling(ASTNode astNode, boolean isNext) {
        if (astNode != null) {
            ASTNode sibling = isNext ? astNode.getTreeNext() : astNode.getTreePrev();
            if (sibling == null || PhpFormatterUtil.isComment(sibling.getElementType())) {
                return null;
            }
            if (!(sibling.getPsi() instanceof PsiWhiteSpace)) {
                return sibling;
            }
            return PhpSpacingProcessor.getNonCommentSibling(sibling, isNext);
        }
        return null;
    }

    private Spacing getParenSpacing(ASTNode parent, IElementType type, IElementType childType) {
        assert (childType == PhpTokenTypes.chLPAREN || childType == PhpTokenTypes.chRPAREN);
        if (type == PhpElementTypes.IF || type == PhpElementTypes.ELSE_IF) {
            boolean newLine = childType == PhpTokenTypes.chLPAREN ? this.myPhpSettings.IF_LPAREN_ON_NEXT_LINE : this.myPhpSettings.IF_RPAREN_ON_NEXT_LINE;
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_IF_PARENTHESES, newLine);
        }
        if (type == PhpElementTypes.WHILE || type == PhpElementTypes.DO_WHILE) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
        if (type == PhpElementTypes.FOR || type == PhpElementTypes.FOREACH) {
            boolean newLine = childType == PhpTokenTypes.chLPAREN ? this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE : this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE;
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, newLine);
        }
        if (type == PhpElementTypes.CATCH) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        }
        if (type == PhpElementTypes.SWITCH) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        }
        if (type == PhpStubElementTypes.FUNCTION || type == PhpStubElementTypes.CLASS_METHOD) {
            boolean newLine = childType == PhpTokenTypes.chLPAREN ? this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE : this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE;
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, newLine);
        }
        if (type == PhpElementTypes.USE_LIST) {
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, true);
        }
        if (type == PhpElementTypes.FUNCTION_CALL || type == PhpElementTypes.METHOD_REFERENCE || type == PhpElementTypes.NEW_EXPRESSION || BUILT_IN_FUNCTIONS.contains(type) || type == PhpStubElementTypes.DEFINE) {
            boolean newLine = childType == PhpTokenTypes.chLPAREN ? this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE : this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE;
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, newLine);
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(type)) {
            boolean newLine = childType == PhpTokenTypes.chLPAREN ? this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE : this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE;
            return this.addConditionalLFSpacing(parent, this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, newLine);
        }
        return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_PARENTHESES);
    }

    private Spacing addConditionalLFSpacing(ASTNode parent, boolean addSpace, boolean addNewLine) {
        ASTNode child;
        int startOffset = parent.getTextRange().getStartOffset();
        int endOffset = parent.getTextRange().getEndOffset();
        IElementType parentType = parent.getElementType();
        if (parentType == PhpElementTypes.METHOD_REFERENCE) {
            for (child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType childType = child.getElementType();
                if (childType != PhpTokenTypes.IDENTIFIER) continue;
                startOffset = child.getTextRange().getStartOffset();
                break;
            }
        } else if (parentType == PhpStubElementTypes.FUNCTION || parentType == PhpStubElementTypes.CLASS_METHOD || parentType == PhpElementTypes.IF || parentType == PhpElementTypes.ELSE_IF || parentType == PhpElementTypes.FOR || parentType == PhpElementTypes.FOREACH || parentType == PhpElementTypes.USE_LIST) {
            endOffset = PhpSpacingProcessor.getOffsetBeforeRightParen(parent);
        } else if (PhpSpacingProcessor.isAssignment(parentType)) {
            ASTNode lastChild = parent.getLastChildNode();
            ASTNode deepestFirstNode = PhpSpacingProcessor.getDeepestFirstNode(lastChild);
            if (deepestFirstNode != null) {
                endOffset = deepestFirstNode.getTextRange().getEndOffset();
            }
        } else if (parentType == PhpElementTypes.TERNARY_EXPRESSION) {
            for (child = parent.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() != PhpTokenTypes.opCOLON) continue;
                startOffset = child.getTextRange().getStartOffset();
            }
        }
        if (addNewLine && endOffset > 0) {
            TextRange boundRange = new TextRange(startOffset, endOffset);
            int spaces = addSpace ? 1 : 0;
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)boundRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return this.addSingleSpaceIf(addSpace);
    }

    private static int getOffsetBeforeRightParen(@NotNull ASTNode parent) {
        if (parent == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(4);
        }
        ASTNode child = parent.getFirstChildNode();
        while (child != null) {
            ASTNode next = child.getTreeNext();
            if (next != null && next.getElementType() == PhpTokenTypes.chRPAREN) {
                if (!(child.getPsi() instanceof PsiWhiteSpace)) break;
                child = child.getTreePrev();
                break;
            }
            child = next;
        }
        return child != null ? child.getTextRange().getEndOffset() : -1;
    }

    @Nullable
    private static ASTNode getDeepestFirstNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode firstChild = node.getFirstChildNode();
        if (firstChild == null) {
            return node;
        }
        return PhpSpacingProcessor.getDeepestFirstNode(firstChild);
    }

    @Nullable
    private Spacing getSpacingBeforeLeftBrace(ASTNode prevNode, ASTNode node, IElementType parentType) {
        if (parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.FIELD_REFERENCE) {
            return this.addSingleSpaceIf(false);
        }
        if (parentType == PhpStubElementTypes.CLASS) {
            if (this.mySettings.CLASS_BRACE_STYLE == 1) {
                return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_CLASS_LBRACE);
            }
            return this.addLineFeedsAfter(prevNode, 1);
        }
        if (parentType == PhpStubElementTypes.FUNCTION || parentType == PhpStubElementTypes.CLASS_METHOD) {
            ASTNode parent = prevNode.getTreeParent();
            int braceStyle = this.mySettings.METHOD_BRACE_STYLE;
            if (parent != null) {
                ASTNode superParent = parent.getTreeParent();
                if (superParent != null && superParent.getElementType() == PhpElementTypes.CLOSURE) {
                    braceStyle = this.mySettings.LAMBDA_BRACE_STYLE;
                }
                if (braceStyle == 2) {
                    int spaces;
                    ASTNode groupStatement = parent.getLastChildNode();
                    int n = spaces = this.mySettings.SPACE_BEFORE_METHOD_LBRACE ? 1 : 0;
                    if (this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && PhpSpacingProcessor.isSimpleGroup(groupStatement)) {
                        return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)parent.getTextRange(), (boolean)false, (int)0);
                    }
                    return this.addNewLineBeforeLBraceConditionally(prevNode, spaces);
                }
                if (braceStyle == 1) {
                    return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_LBRACE);
                }
            }
            return this.addLineFeedsAfter(prevNode, 1);
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(parentType)) {
            return this.addSingleSpaceIf(false);
        }
        if (parentType == PhpStubElementTypes.NAMESPACE) {
            return this.myPhpSettings.NAMESPACE_BRACE_STYLE == 1 ? PhpSpacingProcessor.forceSingleSpaceIf(true) : this.addLineFeedsAfter(prevNode, 1);
        }
        if (this.mySettings.BRACE_STYLE != 1 && !PhpSpacingProcessor.isOneLiner(node)) {
            return this.addLineFeedsAfter(prevNode, 1);
        }
        if (parentType == PhpElementTypes.IF) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_IF_LBRACE);
        }
        if (parentType == PhpElementTypes.ELSE || parentType == PhpElementTypes.ELSE_IF) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_ELSE_LBRACE);
        }
        if (parentType == PhpElementTypes.WHILE) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_LBRACE);
        }
        if (parentType == PhpElementTypes.FOR || parentType == PhpElementTypes.FOREACH) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_FOR_LBRACE);
        }
        if (parentType == PhpElementTypes.DO_WHILE) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_DO_LBRACE);
        }
        if (parentType == PhpElementTypes.SWITCH) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE);
        }
        if (parentType == PhpElementTypes.TRY) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_TRY_LBRACE);
        }
        if (parentType == PhpElementTypes.CATCH) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_LBRACE);
        }
        if (parentType == PhpElementTypes.FINALLY) {
            return PhpSpacingProcessor.forceSingleSpaceIf(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE);
        }
        if (parentType == PhpElementTypes.USE_LIST || parentType == PhpElementTypes.CASE || parentType == PhpElementTypes.CASE_DEFAULT) {
            return PhpSpacingProcessor.forceSingleSpaceIf(true);
        }
        return null;
    }

    private Spacing createSpacingBeforeKeyword(ASTNode leftNode, ASTNode node, boolean requiresLineBreak, boolean requiresSpace) {
        IElementType leftType;
        if (requiresLineBreak && !PhpSpacingProcessor.isOneLiner(node)) {
            return this.addLineFeedsAfter(leftNode, 1);
        }
        IElementType iElementType = leftType = leftNode != null ? leftNode.getElementType() : null;
        if (ANY_GROUP_STATEMENT.contains(leftType) || leftType == PhpElementTypes.ELSE_IF || leftType == PhpElementTypes.CATCH) {
            ASTNode lastChild;
            ASTNode aSTNode = lastChild = leftNode != null ? leftNode.getLastChildNode() : null;
            if (lastChild != null) {
                if (PhpPsiUtil.isOfType(lastChild, PhpElementTypes.ANY_GROUP_STATEMENT)) {
                    lastChild = lastChild.getLastChildNode();
                }
                if (lastChild != null && lastChild.getElementType() == PhpTokenTypes.chRBRACE) {
                    return PhpSpacingProcessor.forceSingleSpaceIf(requiresSpace);
                }
            }
            if (!PhpSpacingProcessor.isOneLiner(node)) {
                return this.addLineFeedsAfter(leftNode, 1);
            }
        } else if (leftType == PhpTokenTypes.opCOLON) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return this.addSingleSpaceIf(requiresSpace);
    }

    private static boolean isOneLiner(ASTNode node) {
        LeafElement leaf = node != null ? TreeUtil.findFirstLeaf((ASTNode)node) : null;
        TextRange line = PhpSpacingProcessor.getLineRange((ASTNode)leaf);
        return line != null && PhpSpacingProcessor.isClosingTagOnSameLine((ASTNode)leaf, line) && PhpSpacingProcessor.isOpeningTagOnSameLine((ASTNode)leaf, line);
    }

    private static TextRange getLineRange(ASTNode leaf) {
        Document document;
        PsiFile file;
        PsiElement psi;
        if (leaf != null && (psi = leaf.getPsi()) != null && (file = psi.getContainingFile()) != null && (document = PsiDocumentManager.getInstance((Project)psi.getProject()).getDocument(file)) != null) {
            int line = document.getLineNumber(leaf.getStartOffset());
            return TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
        }
        return null;
    }

    private static boolean isClosingTagOnSameLine(ASTNode leaf, TextRange line) {
        ASTNode next = leaf;
        while (next != null && line.contains(next.getTextRange())) {
            if (PhpPsiUtil.isOfType(next, PhpTokenTypes.PHP_CLOSING_TAG)) {
                return true;
            }
            next = TreeUtil.nextLeaf((ASTNode)next);
        }
        return false;
    }

    private static boolean isOpeningTagOnSameLine(ASTNode leaf, TextRange line) {
        ASTNode prev = leaf;
        while (prev != null && line.contains(prev.getTextRange())) {
            if (PhpPsiUtil.isOfType(prev, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
                return true;
            }
            prev = TreeUtil.prevLeaf((ASTNode)prev);
        }
        return false;
    }

    private Spacing createSpaceAfterComma(ASTNode parent) {
        IElementType parentType = parent.getElementType();
        int spaces = this.mySettings.SPACE_AFTER_COMMA ? 1 : 0;
        Spacing defaultSpacing = this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COMMA);
        ASTNode superParent = parent.getTreeParent();
        if (superParent == null) {
            return defaultSpacing;
        }
        IElementType superType = superParent.getElementType();
        if ((parentType == PhpElementTypes.USE_LIST || parentType == PARAMETER_LIST) && (superType == PhpStubElementTypes.FUNCTION || superType == PhpStubElementTypes.CLASS_METHOD) && (this.mySettings.METHOD_PARAMETERS_WRAP & 4) != 0 || parentType == PhpElementTypes.PARAMETER_LIST && (superType == PhpElementTypes.FUNCTION_CALL || superType == PhpElementTypes.METHOD_REFERENCE) && (this.mySettings.CALL_PARAMETERS_WRAP & 4) != 0 || parentType == PhpElementTypes.ARRAY_CREATION_EXPRESSION && (this.mySettings.ARRAY_INITIALIZER_WRAP & 4) != 0 || parentType == PhpElementTypes.USE_BRACES && (this.myPhpSettings.GROUP_USE_WRAP & 4) != 0) {
            TextRange range;
            TextRange textRange = range = parentType == PhpElementTypes.USE_BRACES ? PhpSpacingProcessor.getUsesRange(parent) : PhpSpacingProcessor.getOuterParenthesisRange(parent);
            if (range != null) {
                return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
        return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COMMA);
    }

    @Nullable
    private static TextRange getOuterParenthesisRange(ASTNode listNode) {
        ASTNode nextChild;
        ASTNode prevChild;
        if (listNode.getElementType() != PhpElementTypes.PARAMETER_LIST) {
            return listNode.getTextRange();
        }
        for (prevChild = listNode; prevChild != null && prevChild.getElementType() != PhpTokenTypes.chLPAREN; prevChild = prevChild.getTreePrev()) {
        }
        if (prevChild == null) {
            return null;
        }
        for (nextChild = listNode; nextChild != null && nextChild.getElementType() != PhpTokenTypes.chRPAREN; nextChild = nextChild.getTreeNext()) {
        }
        if (nextChild == null) {
            return null;
        }
        return new TextRange(prevChild.getTextRange().getStartOffset(), nextChild.getTextRange().getEndOffset());
    }

    @Nullable
    private static TextRange getUsesRange(@NotNull ASTNode useBraces) {
        ASTNode lastUse;
        ASTNode firstUse;
        if (useBraces == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(5);
        }
        for (firstUse = useBraces.getFirstChildNode(); firstUse != null && !PhpPsiUtil.isOfType(firstUse, PhpStubElementTypes.USE); firstUse = firstUse.getTreeNext()) {
        }
        for (lastUse = useBraces.getLastChildNode(); lastUse != null && !PhpPsiUtil.isOfType(lastUse, PhpStubElementTypes.USE); lastUse = lastUse.getTreePrev()) {
        }
        if (firstUse == null || lastUse == null) {
            return null;
        }
        return new TextRange(firstUse.getTextRange().getStartOffset(), lastUse.getTextRange().getEndOffset());
    }

    private Spacing createSpacingBeforeReturn(ASTNode leftNode, ASTNode retNode) {
        assert (retNode.getElementType() == PhpElementTypes.RETURN) : "Not a return node: " + retNode.getElementType();
        Spacing defaultSpacing = this.addLineFeedsAfter(leftNode, 1);
        if (this.myPhpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT == 0 || leftNode.getElementType() == PhpDocElementTypes.DOC_COMMENT) {
            return defaultSpacing;
        }
        ASTNode parent = retNode.getTreeParent();
        if (parent == null || !PhpPsiUtil.isOfType(parent, PhpElementTypes.ANY_GROUP_STATEMENT)) {
            return defaultSpacing;
        }
        for (ASTNode childNode = parent.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType childType = childNode.getElementType();
            if (childNode.getPsi() instanceof PsiWhiteSpace || !STATEMENTS.contains(childType) || childNode == retNode) continue;
            return Spacing.createSpacing((int)0, (int)0, (int)(this.myPhpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return defaultSpacing;
    }

    private static ASTNode skipReturnTypeDeclaration(ASTNode node) {
        ASTNode treePrev = node;
        if (treePrev.getElementType() == PhpElementTypes.RETURN_TYPE) {
            treePrev = node.getTreePrev();
            if (treePrev.getPsi() instanceof PsiWhiteSpace) {
                treePrev = treePrev.getTreePrev();
            }
            if (treePrev.getElementType() == PhpTokenTypes.opCOLON) {
                treePrev = treePrev.getTreePrev();
            }
        }
        if (treePrev.getPsi() instanceof PsiWhiteSpace) {
            treePrev = treePrev.getTreePrev();
        }
        return treePrev;
    }

    private Spacing addNewLineBeforeLBraceConditionally(ASTNode prevNode, int spaces) {
        ASTNode skipReturnTypeDeclaration = PhpSpacingProcessor.skipReturnTypeDeclaration(prevNode);
        if (this.myPhpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE && skipReturnTypeDeclaration.getElementType() == PhpTokenTypes.chRPAREN) {
            ASTNode paramNode = skipReturnTypeDeclaration.getTreePrev();
            if (paramNode.getPsi() instanceof PsiWhiteSpace) {
                paramNode = paramNode.getTreePrev();
            }
            if (paramNode != null && paramNode.getElementType() == PhpElementTypes.PARAMETER_LIST && (paramNode = paramNode.getLastChildNode()) != null) {
                TextRange range = new TextRange(paramNode.getTextRange().getStartOffset(), prevNode.getTextRange().getStartOffset() + 1);
                return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)range, (boolean)false, (int)0, (DependentSpacingRule)LINE_BREAK_IF_NO_OTHER_LINE_BREAK);
            }
        }
        return this.addLineFeedsAfter(skipReturnTypeDeclaration, 1);
    }

    private boolean shouldAddSpacesWithinBrackets(ASTNode node, IElementType nodeType) {
        if (PhpSpacingProcessor.isUnderParentOfType(node, PhpElementTypes.STATEMENT, PhpElementTypes.STRING, PhpElementTypes.HEREDOC)) {
            return false;
        }
        if (this.mySettings.SPACE_WITHIN_BRACKETS) {
            return true;
        }
        if (nodeType == PhpElementTypes.ARRAY_ACCESS_EXPRESSION && this.myPhpSettings.SPACES_AROUND_VAR_WITHIN_BRACKETS) {
            ASTNode child = node.getLastChildNode();
            if (child != null && child.getElementType() == PhpTokenTypes.chRBRACKET) {
                child = child.getTreePrev();
            }
            if (child instanceof PsiWhiteSpace) {
                child = child.getTreePrev();
            }
            if (child != null && child.getElementType() == PhpElementTypes.ARRAY_INDEX) {
                IElementType childType;
                IElementType iElementType = childType = (child = child.getFirstChildNode()) != null ? child.getElementType() : null;
                if (childType == PhpStubElementTypes.VARIABLE || PhpElementTypes.tsEXPRESSIONS.contains(childType) && childType != PhpElementTypes.STRING && childType != PhpElementTypes.NUMBER) {
                    return true;
                }
            }
        }
        return false;
    }

    private int getBlankLinesBetweenClassMembers(@NotNull ASTNode leftNode, @NotNull ASTNode rightNode) {
        if (leftNode == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(6);
        }
        if (rightNode == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(7);
        }
        IElementType child1Type = leftNode.getElementType();
        IElementType child2Type = rightNode.getElementType();
        if (child1Type == PhpTokenTypes.LINE_COMMENT) {
            ASTNode leftPrev = PhpSpacingProcessor.getNonCommentSibling(leftNode, false);
            return leftPrev != null ? this.getBlankLinesBetweenClassMembers(leftPrev, rightNode) : -1;
        }
        int minBlankLines = -1;
        if (child1Type == PhpTokenTypes.chLBRACE) {
            return this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER;
        }
        if (child2Type == PhpTokenTypes.chRBRACE) {
            return 0;
        }
        if (child1Type == PhpElementTypes.CLASS_CONSTANTS || child2Type == PhpElementTypes.CLASS_CONSTANTS) {
            minBlankLines = Math.max(minBlankLines, this.myPhpSettings.BLANK_LINES_AROUND_CONSTANTS);
        }
        if (PhpFormatterUtil.isClassField(child1Type) || PhpFormatterUtil.isClassField(child2Type)) {
            minBlankLines = Math.max(minBlankLines, this.mySettings.BLANK_LINES_AROUND_FIELD);
        }
        if (child1Type == PhpStubElementTypes.CLASS_METHOD && PhpFormatterUtil.isClassMemberMember(child2Type) || child2Type == PhpStubElementTypes.CLASS_METHOD && PhpFormatterUtil.isClassMemberMember(child1Type)) {
            minBlankLines = Math.max(minBlankLines, this.mySettings.BLANK_LINES_AROUND_METHOD);
        }
        return minBlankLines;
    }

    private static boolean isEndOfLineComment(ASTNode node) {
        ASTNode prevNode;
        IElementType nodeType = node.getElementType();
        return nodeType == PhpTokenTypes.LINE_COMMENT && (prevNode = node.getTreePrev()) != null && (!(prevNode.getPsi() instanceof PsiWhiteSpace) || !prevNode.textContains('\n'));
    }

    private static boolean isEchoClosingTag(@NotNull ASTNode astNode) {
        if (astNode == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(8);
        }
        if (astNode.getElementType() == PhpTokenTypes.PHP_CLOSING_TAG) {
            for (ASTNode prev = astNode.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
                IElementType prevType = prev.getElementType();
                if (prevType == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
                    return true;
                }
                if (prevType != PhpTokenTypes.PHP_OPENING_TAG) continue;
                return false;
            }
        }
        return false;
    }

    private Spacing createEchoTagSpacing() {
        int spaces = this.myPhpSettings.SPACES_WITHIN_SHORT_ECHO_TAGS ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static boolean isAssignmentByRefOperatorWithSpaceInside(@NotNull ASTNode node) {
        CharSequence chars;
        IElementType nodeType;
        if (node == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(9);
        }
        if ((nodeType = node.getElementType()) == PhpTokenTypes.opASGN && (chars = node.getChars()).length() > 1 && chars.charAt(chars.length() - 1) == '&') {
            return chars.length() > 2;
        }
        return false;
    }

    private static boolean isAfterLineBreak(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(10);
        }
        if ((prev = node.getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace) {
            return prev.textContains('\n');
        }
        ASTNode parent = node.getTreeParent();
        return parent != null && PhpSpacingProcessor.isAfterLineBreak(parent);
    }

    private static boolean isBeforeLineBreak(@NotNull ASTNode node) {
        ASTNode next;
        if (node == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(11);
        }
        if ((next = node.getTreeNext()) != null && next.getPsi() instanceof PsiWhiteSpace) {
            return next.textContains('\n');
        }
        ASTNode parent = node.getTreeParent();
        return parent != null && PhpSpacingProcessor.isBeforeLineBreak(parent);
    }

    private Spacing getSpacingAfterNamespaceDeclaration(@NotNull ASTNode namespaceNode, @Nullable ASTNode nodeAfter) {
        if (namespaceNode == null) {
            PhpSpacingProcessor.$$$reportNull$$$0(12);
        }
        int minLines = this.mySettings.BLANK_LINES_AFTER_PACKAGE;
        if (nodeAfter != null && nodeAfter.getElementType() == PhpElementTypes.USE_LIST) {
            minLines = Math.max(this.mySettings.BLANK_LINES_AFTER_PACKAGE, this.mySettings.BLANK_LINES_BEFORE_IMPORTS);
        }
        return this.addLineFeedsAfter(namespaceNode, minLines + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useBraces";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceNode";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpSpacingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterPrecedingOperator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetBeforeRightParen";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsesRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlankLinesBetweenClassMembers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isEchoClosingTag";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentByRefOperatorWithSpaceInside";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterLineBreak";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isBeforeLineBreak";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacingAfterNamespaceDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

