/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpExceptionBreakpointProperties;
import com.jetbrains.php.debug.common.PhpExceptionBreakpointType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExceptionBreakpointHandler<P extends PhpDebugProcess>
extends XBreakpointHandler<XBreakpoint<PhpExceptionBreakpointProperties>> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.common.PhpExceptionBreakpointHandler");
    private final P myDebugProcess;
    protected final BidirectionalMap<XBreakpoint<PhpExceptionBreakpointProperties>, String> myRegisteredBreakpoints;
    private final Set<XBreakpoint<PhpExceptionBreakpointProperties>> myUnregisteredBreakpoints;
    private final Object myLock;

    protected PhpExceptionBreakpointHandler(@NotNull P debugProcess) {
        if (debugProcess == null) {
            PhpExceptionBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(PhpExceptionBreakpointType.class);
        this.myRegisteredBreakpoints = new BidirectionalMap();
        this.myUnregisteredBreakpoints = new HashSet<XBreakpoint<PhpExceptionBreakpointProperties>>();
        this.myLock = new Object();
        this.myDebugProcess = debugProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getDebugProcess() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDebugProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(final @NotNull XBreakpoint<PhpExceptionBreakpointProperties> breakpoint) {
        PhpExceptionBreakpointProperties properties;
        if (breakpoint == null) {
            PhpExceptionBreakpointHandler.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(properties = (PhpExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName())) {
            return;
        }
        if (((PhpDebugProcess)this.getDebugProcess()).isConnected()) {
            ((PhpDebugProcess)this.getDebugProcess()).registerExceptionBreakpoint(properties.getExceptionName(), new PhpDebugProcess.RegisterBreakpointCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void registered(@NotNull String breakpointId) {
                    if (breakpointId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object object = PhpExceptionBreakpointHandler.this.myLock;
                    synchronized (object) {
                        PhpExceptionBreakpointHandler.this.myUnregisteredBreakpoints.remove(breakpoint);
                        PhpExceptionBreakpointHandler.this.myRegisteredBreakpoints.put((Object)breakpoint, (Object)breakpointId);
                    }
                }

                @Override
                public void errorOccurred(@Nullable String errorMessage) {
                    LOG.warn("Can't register breakpoint: " + errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointId", "com/jetbrains/php/debug/common/PhpExceptionBreakpointHandler$1", "registered"));
                }
            });
        } else {
            Object object = this.myLock;
            synchronized (object) {
                this.myUnregisteredBreakpoints.add(breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XBreakpoint<PhpExceptionBreakpointProperties> breakpoint, boolean temporary) {
        String breakpointId;
        if (breakpoint == null) {
            PhpExceptionBreakpointHandler.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnregisteredBreakpoints.remove(breakpoint)) {
                return;
            }
            if (!((PhpDebugProcess)this.myDebugProcess).isConnected()) {
                this.myUnregisteredBreakpoints.add(breakpoint);
                return;
            }
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            breakpointId = (String)this.myRegisteredBreakpoints.get(breakpoint);
        }
        if (breakpointId == null) {
            return;
        }
        ((PhpDebugProcess)this.getDebugProcess()).unregisterBreakpoint(breakpointId, new PhpDebugProcess.UnregisterBreakpointCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregistered() {
                Object object = PhpExceptionBreakpointHandler.this.myLock;
                synchronized (object) {
                    PhpExceptionBreakpointHandler.this.myRegisteredBreakpoints.removeValue((Object)breakpointId);
                }
            }

            @Override
            public void errorOccurred(@Nullable String errorMessage) {
                LOG.warn("Can't unregister breakpoint: " + errorMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XBreakpoint<PhpExceptionBreakpointProperties> findBreakpoint(String name) {
        Object object = this.myLock;
        synchronized (object) {
            for (XBreakpoint breakpoint : this.myRegisteredBreakpoints.keySet()) {
                String exceptionName = ((PhpExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
                if (!StringUtil.equalsIgnoreCase((CharSequence)exceptionName, (CharSequence)name)) continue;
                return breakpoint;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.myLock;
        synchronized (object) {
            this.myUnregisteredBreakpoints.addAll(this.myRegisteredBreakpoints.keySet());
            this.myRegisteredBreakpoints.clear();
        }
    }

    public void registerAllUnregisterBreakpoints() {
        ArrayList<XBreakpoint<PhpExceptionBreakpointProperties>> toRegister = new ArrayList<XBreakpoint<PhpExceptionBreakpointProperties>>(this.myUnregisteredBreakpoints);
        for (XBreakpoint<PhpExceptionBreakpointProperties> breakpoint : toRegister) {
            this.registerBreakpoint(breakpoint);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpExceptionBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

