/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSConditionalExpressionAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJsLocalAlignmentFactory
extends JSLocalAlignmentFactory {
    private final JSConditionalExpressionAlignmentFactory myConditionalExpressionAlignmentFactory;
    private final TypescriptUnionTypesAlignmentFactory myUnionTypesAlignmentFactory;

    public TypedJsLocalAlignmentFactory(@NotNull CommonCodeStyleSettings commonSettings, @NotNull JSCodeStyleSettings customSettings, FormattingMode formattingMode) {
        if (commonSettings == null) {
            TypedJsLocalAlignmentFactory.$$$reportNull$$$0(0);
        }
        if (customSettings == null) {
            TypedJsLocalAlignmentFactory.$$$reportNull$$$0(1);
        }
        super(commonSettings, formattingMode);
        this.myConditionalExpressionAlignmentFactory = new JSConditionalExpressionAlignmentFactory(commonSettings, TypeScriptElementTypes.TYPESCRIPT_TYPES);
        this.myUnionTypesAlignmentFactory = new TypescriptUnionTypesAlignmentFactory(customSettings);
    }

    @Override
    @Nullable
    protected Alignment getAlignment(@NotNull ASTNode parent, @NotNull ASTNode child) {
        IElementType parentType;
        if (parent == null) {
            TypedJsLocalAlignmentFactory.$$$reportNull$$$0(2);
        }
        if (child == null) {
            TypedJsLocalAlignmentFactory.$$$reportNull$$$0(3);
        }
        if ((parentType = parent.getElementType()) == TypeScriptElementTypes.CONDITIONAL_TYPE) {
            return this.myConditionalExpressionAlignmentFactory.getAlignment(child);
        }
        if (parentType == TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE) {
            return this.myUnionTypesAlignmentFactory.getAlignment(child);
        }
        return super.getAlignment(parent, child);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/formatter/TypedJsLocalAlignmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypescriptUnionTypesAlignmentFactory
    implements ASTNodeBasedAlignmentFactory {
        private final Alignment myTypesAlignment;
        private final Alignment mySignsAlignment;
        @NotNull
        private final JSCodeStyleSettings myCustomSettings;

        private TypescriptUnionTypesAlignmentFactory(@NotNull JSCodeStyleSettings customSettings) {
            if (customSettings == null) {
                TypescriptUnionTypesAlignmentFactory.$$$reportNull$$$0(0);
            }
            this.myCustomSettings = customSettings;
            this.mySignsAlignment = Alignment.createAlignment();
            this.myTypesAlignment = Alignment.createAlignment();
        }

        @Override
        public Alignment getAlignment(@NotNull ASTNode child) {
            boolean isSign;
            boolean startsWithType;
            if (child == null) {
                TypescriptUnionTypesAlignmentFactory.$$$reportNull$$$0(1);
            }
            if (!this.myCustomSettings.ALIGN_UNION_TYPES) {
                return null;
            }
            ASTNode parent = child.getTreeParent();
            IElementType childType = child.getElementType();
            ASTNode firstChild = parent.getFirstChildNode();
            boolean bl = startsWithType = firstChild != null && TypeScriptElementTypes.TYPESCRIPT_TYPES.contains(firstChild.getElementType());
            if (startsWithType) {
                return this.mySignsAlignment;
            }
            boolean bl2 = isSign = JSTokenTypes.OR == childType || JSTokenTypes.AND == childType;
            if (TypeScriptElementTypes.TYPESCRIPT_TYPES.contains(childType)) {
                return this.myTypesAlignment;
            }
            if (isSign) {
                return this.mySignsAlignment;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "customSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/formatter/TypedJsLocalAlignmentFactory$TypescriptUnionTypesAlignmentFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

