/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintSessionData {
    private final VirtualFile myWorkingDir;
    private final VirtualFile myFileToLint;
    private final String myFileToLintContent;
    private final VirtualFile mySpecifiedConfigFile;

    public EslintSessionData(@NotNull VirtualFile workingDir, @NotNull VirtualFile fileToLint, @NotNull String fileToLintContent, @Nullable VirtualFile specifiedConfigurationFile) {
        if (workingDir == null) {
            EslintSessionData.$$$reportNull$$$0(0);
        }
        if (fileToLint == null) {
            EslintSessionData.$$$reportNull$$$0(1);
        }
        if (fileToLintContent == null) {
            EslintSessionData.$$$reportNull$$$0(2);
        }
        this.myWorkingDir = workingDir;
        this.myFileToLint = fileToLint;
        this.myFileToLintContent = fileToLintContent;
        this.mySpecifiedConfigFile = specifiedConfigurationFile;
    }

    @NotNull
    public VirtualFile getFileToLint() {
        VirtualFile virtualFile = this.myFileToLint;
        if (virtualFile == null) {
            EslintSessionData.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public String getFileToLintContent() {
        String string = this.myFileToLintContent;
        if (string == null) {
            EslintSessionData.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public VirtualFile getSpecifiedConfigFile() {
        return this.mySpecifiedConfigFile;
    }

    @NotNull
    public List<VirtualFile> findConfigs() {
        ArrayList configs = ContainerUtil.newArrayList();
        if (this.mySpecifiedConfigFile != null) {
            configs.add(this.mySpecifiedConfigFile);
        } else {
            configs.addAll(EslintUtil.findAllConfigsWithPackageJsonUpFileSystem(this.myFileToLint));
        }
        VirtualFile ignoreFile = this.myWorkingDir.findChild(".eslintignore");
        if (ignoreFile != null && ignoreFile.isValid() && !ignoreFile.isDirectory()) {
            configs.add(ignoreFile);
        }
        ArrayList arrayList = configs;
        if (arrayList == null) {
            EslintSessionData.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLintContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintSessionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintSessionData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToLint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToLintContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

