/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterEditorPanelCreator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterEditorNotificationPanel
extends EditorNotifications.Provider<EditorNotificationPanel> {
    @NotNull
    private final Project myProject;
    protected final Class<? extends JSLinterInspection> myInspectionClass;

    protected JSLinterEditorNotificationPanel(@NotNull Project project, Class<? extends JSLinterInspection> aClass) {
        if (project == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myInspectionClass = aClass;
    }

    protected abstract Key<JSLinterFileLevelAnnotation> getFileNotificationKey();

    @Nullable
    protected abstract Icon getIcon();

    public static void setNotification(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2, @NotNull JSLinterFileLevelAnnotation annotation) {
        if (project == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(1);
        }
        if (linterInspection == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(3);
        }
        if (annotation == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return;
        }
        Key<JSLinterFileLevelAnnotation> key = JSLinterEditorPanelCreator.getInstance(project).getLinterNotificationsKey(linterInspection);
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file2);
        boolean changed = false;
        for (FileEditor editor : editors) {
            JSLinterFileLevelAnnotation data = (JSLinterFileLevelAnnotation)editor.getUserData(key);
            editor.putUserData(key, (Object)annotation);
            changed |= !Comparing.equal((Object)data, (Object)annotation);
        }
        if (changed) {
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        }
    }

    public static void clearNotification(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2) {
        if (project == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(5);
        }
        if (linterInspection == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return;
        }
        Key<JSLinterFileLevelAnnotation> key = JSLinterEditorPanelCreator.getInstance(project).getLinterNotificationsKey(linterInspection);
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file2);
        boolean wasFilled = false;
        for (FileEditor editor : editors) {
            wasFilled = editor.getUserData(key) != null;
            editor.putUserData(key, null);
        }
        if (wasFilled) {
            EditorNotifications.getInstance((Project)project).updateNotifications(file2);
        }
    }

    @Nullable
    public static String getNotificationText(@NotNull Project project, @NotNull Class<? extends JSLinterInspection> linterInspection, @NotNull VirtualFile file2) {
        FileEditor[] editors;
        if (project == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(8);
        }
        if (linterInspection == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(10);
        }
        Key<JSLinterFileLevelAnnotation> key = JSLinterEditorPanelCreator.getInstance(project).getLinterNotificationsKey(linterInspection);
        for (FileEditor editor : editors = FileEditorManager.getInstance((Project)project).getAllEditors(file2)) {
            JSLinterFileLevelAnnotation annotation = (JSLinterFileLevelAnnotation)editor.getUserData(key);
            if (annotation == null) continue;
            return annotation.getMessage();
        }
        return null;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        List<IntentionAction> fixes;
        if (file2 == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(11);
        }
        if (fileEditor == null) {
            JSLinterEditorNotificationPanel.$$$reportNull$$$0(12);
        }
        if (!JSLinterInspection.isToolEnabled(this.myProject, this.myInspectionClass, null)) {
            return null;
        }
        JSLinterFileLevelAnnotation data = (JSLinterFileLevelAnnotation)fileEditor.getUserData(this.getFileNotificationKey());
        if (data == null) {
            return null;
        }
        String message = data.getShortMessage();
        if (message == null) {
            List strings = Arrays.stream(StringUtil.splitByLines((String)data.getMessage())).filter(s -> !StringUtil.isEmptyOrSpaces((String)s)).collect(Collectors.toList());
            message = strings.isEmpty() ? data.getMessage() : (String)strings.get(0);
        }
        message = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)message));
        String tooltip = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)data.getMessage()).replace("\n", "<br/>"));
        Color backgroundColor = HighlightSeverity.ERROR.equals((Object)data.getSeverity()) ? LightColors.RED : LightColors.YELLOW;
        EditorNotificationPanel panel = new EditorNotificationPanel(backgroundColor);
        panel.setText(message);
        Icon icon = this.getIcon();
        if (icon != null) {
            panel.icon(icon);
        }
        if ((fixes = data.getFixes().getOtherFixes()) != null) {
            for (IntentionAction fix : fixes) {
                panel.createActionLabel(fix.getText(), () -> fix.invoke(this.myProject, null, null));
            }
        }
        panel.setToolTipText(tooltip);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linterInspection";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterEditorNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setNotification";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "clearNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getNotificationText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createNotificationPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

