/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.CodeSectionHostBlock;
import com.intellij.sql.formatter.model.FindPhraseResult;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlBlockStatementBlockKt;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlDeclareSectionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlPhraseBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001cH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/sql/formatter/model/SqlBlockStatementBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/CodeSectionHostBlock;", "()V", "codeSections", "", "Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock;", "declareSection", "Lcom/intellij/sql/formatter/model/SqlDeclareSectionBlock;", "hostWrap", "Lcom/intellij/formatting/Wrap;", "getHostWrap", "()Lcom/intellij/formatting/Wrap;", "setHostWrap", "(Lcom/intellij/formatting/Wrap;)V", "prefix", "Lcom/intellij/sql/formatter/model/SqlBlock;", "suffixes", "configureFormattingAttributes", "", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "incomplete", "", "produceNestedBlocks", "nodes", "", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "whetherToFlatten", "node", "intellij.database.sql.impl"})
public final class SqlBlockStatementBlock
extends SqlNodeBlock
implements CodeSectionHostBlock {
    @Nullable
    private Wrap hostWrap;
    private SqlDeclareSectionBlock declareSection;
    private SqlBlock prefix;
    private final List<SqlCodeFlowBlock> codeSections = (List)new SmartList();
    private final List<SqlBlock> suffixes = (List)new SmartList();

    @Override
    @Nullable
    public Wrap getHostWrap() {
        return this.hostWrap;
    }

    public void setHostWrap(@Nullable Wrap wrap) {
        this.hostWrap = wrap;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)SqlCompositeElementTypes.SQL_EXCEPTION_CLAUSE);
    }

    @Override
    protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes2) {
        SqlCodeFlowBlock codeSection;
        SqlBlock parent$iv;
        Object $receiver$iv;
        FindPhraseResult suffixResult;
        SqlBlock parent$iv2;
        Object nodes$iv;
        Object object;
        SqlBlock sqlBlock;
        SqlBlock parent$iv3;
        Object $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int n = nodes2.size();
        FindPhraseResult prefixResult = SqlFormattingModelFunKt.findPhrase(nodes2, 0, SqlBlockStatementBlockKt.access$getBLOCK_PREFIXES$p());
        if (prefixResult != null) {
            Object object2;
            List<? extends ASTNode> nodes$iv2;
            SqlBlockStatementBlock sqlBlockStatementBlock;
            if (prefixResult.getBegin() > 0) {
                SqlRangeBlock sqlRangeBlock = new SqlDeclareSectionBlock();
                SqlBlock sqlBlock2 = this;
                List<? extends ASTNode> list = nodes2.subList(0, prefixResult.getBegin());
                sqlBlockStatementBlock = this;
                ((SqlRangeBlock)$receiver$iv2).setup$intellij_database_sql_impl(parent$iv3, nodes$iv2);
                object2 = $receiver$iv2;
                sqlBlockStatementBlock.declareSection = (SqlDeclareSectionBlock)object2;
                $receiver$iv2 = this.getNestedBlocks();
                SqlDeclareSectionBlock sqlDeclareSectionBlock = this.declareSection;
                if (sqlDeclareSectionBlock == null) {
                    Intrinsics.throwNpe();
                }
                parent$iv3 = sqlDeclareSectionBlock;
                $receiver$iv2.add(parent$iv3);
            }
            if (prefixResult.getEnd() - prefixResult.getBegin() == 1) {
                this.prefix = this.makeBlock(nodes2.get(prefixResult.getBegin()));
            } else {
                $receiver$iv2 = new SqlPhraseBlock();
                parent$iv3 = this;
                nodes$iv2 = nodes2.subList(prefixResult.getBegin(), prefixResult.getEnd());
                sqlBlockStatementBlock = this;
                ((SqlRangeBlock)$receiver$iv2).setup$intellij_database_sql_impl(parent$iv3, nodes$iv2);
                object2 = $receiver$iv2;
                sqlBlockStatementBlock.prefix = (SqlBlock)object2;
            }
            $receiver$iv2 = this.getNestedBlocks();
            sqlBlock = this.prefix;
            if (sqlBlock == null) {
                Intrinsics.throwNpe();
            }
        } else {
            super.produceNestedBlocks(nodes2);
            return;
        }
        parent$iv3 = SqlBlockKt.withRole(sqlBlock, BlockRole.PREFIX);
        $receiver$iv2.add(parent$iv3);
        int prefixEnd = prefixResult.getEnd();
        FindPhraseResult exceptionResult = SqlFormattingModelFunKt.findPhrase(nodes2, prefixEnd, SqlBlockStatementBlockKt.access$getEXCEPTION_PREFIXES$p());
        if (exceptionResult != null) {
            Collection $receiver$iv3;
            if (prefixEnd < exceptionResult.getBegin()) {
                SqlRangeBlock $i$f$withSetup = new SqlCodeFlowBlock();
                object = this;
                nodes$iv = nodes2.subList(prefixEnd, exceptionResult.getBegin());
                ((SqlRangeBlock)((Object)$receiver$iv3)).setup$intellij_database_sql_impl(parent$iv2, (List<? extends ASTNode>)nodes$iv);
                SqlCodeFlowBlock codeSection2 = (SqlCodeFlowBlock)((Object)$receiver$iv3);
                $receiver$iv3 = this.getNestedBlocks();
                parent$iv2 = SqlBlockKt.withRole((SqlBlock)codeSection2, BlockRole.ESSENCE);
                $receiver$iv3.add(parent$iv2);
                $receiver$iv3 = this.codeSections;
                $receiver$iv3.add(codeSection2);
            }
            SqlBlock suffix = this.makeBlock(nodes2.get(exceptionResult.getBegin()));
            $receiver$iv3 = this.getNestedBlocks();
            parent$iv2 = SqlBlockKt.withRole(suffix, BlockRole.SUFFIX);
            $receiver$iv3.add(parent$iv2);
            $receiver$iv3 = this.suffixes;
            $receiver$iv3.add(suffix);
            prefixEnd = exceptionResult.getEnd();
        }
        if ((suffixResult = SqlFormattingModelFunKt.findPhrase(nodes2, prefixEnd, SqlBlockStatementBlockKt.access$getBLOCK_SUFFIXES$p())) != null) {
            SqlBlock sqlBlock3;
            List<? extends ASTNode> nodes$iv3;
            if (prefixEnd < suffixResult.getBegin()) {
                parent$iv2 = new SqlCodeFlowBlock();
                nodes$iv = this;
                nodes$iv3 = nodes2.subList(prefixEnd, suffixResult.getBegin());
                ((SqlRangeBlock)$receiver$iv).setup$intellij_database_sql_impl(parent$iv, nodes$iv3);
                codeSection = (SqlCodeFlowBlock)$receiver$iv;
                $receiver$iv = this.getNestedBlocks();
                parent$iv = SqlBlockKt.withRole((SqlBlock)codeSection, BlockRole.ESSENCE);
                $receiver$iv.add(parent$iv);
                $receiver$iv = this.codeSections;
                $receiver$iv.add(codeSection);
            }
            if (suffixResult.getEnd() - suffixResult.getBegin() == 1) {
                sqlBlock3 = this.makeBlock(nodes2.get(suffixResult.getBegin()));
            } else {
                $receiver$iv = new SqlPhraseBlock();
                parent$iv = this;
                nodes$iv3 = nodes2.subList(suffixResult.getBegin(), suffixResult.getEnd());
                ((SqlRangeBlock)$receiver$iv).setup$intellij_database_sql_impl(parent$iv, nodes$iv3);
                sqlBlock3 = (SqlBlock)$receiver$iv;
            }
            SqlBlock suffix = sqlBlock3;
            $receiver$iv = this.getNestedBlocks();
            parent$iv = SqlBlockKt.withRole(suffix, BlockRole.SUFFIX);
            $receiver$iv.add(parent$iv);
            $receiver$iv = this.suffixes;
            $receiver$iv.add(suffix);
            if (suffixResult.getEnd() < n) {
                super.produceNestedBlocks(nodes2.subList(suffixResult.getEnd(), n));
            }
        } else {
            $receiver$iv = new SqlCodeFlowBlock();
            parent$iv = this;
            List<? extends ASTNode> nodes$iv4 = nodes2.subList(prefixEnd, n);
            ((SqlRangeBlock)$receiver$iv).setup$intellij_database_sql_impl(parent$iv, nodes$iv4);
            codeSection = (SqlCodeFlowBlock)$receiver$iv;
            object = this.getNestedBlocks();
            SqlBlock sqlBlock4 = SqlBlockKt.withRole((SqlBlock)codeSection, BlockRole.ESSENCE);
            object.add(sqlBlock4);
            object = this.codeSections;
            object.add(codeSection);
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlBlock it;
        this.setHostWrap(SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.ALWAYS, false, 2, null));
        SqlDeclareSectionBlock sqlDeclareSectionBlock = this.declareSection;
        if (sqlDeclareSectionBlock != null) {
            sqlDeclareSectionBlock.setMyWrap(this.getHostWrap());
        }
        SqlBlock sqlBlock = this.prefix;
        if (sqlBlock != null) {
            sqlBlock.setMyWrap(this.getHostWrap());
        }
        Iterable $receiver$iv = this.codeSections;
        for (Object element$iv : $receiver$iv) {
            it = (SqlCodeFlowBlock)element$iv;
            it.setMyWrap(this.getHostWrap());
            it.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
        }
        $receiver$iv = this.suffixes;
        for (Object element$iv : $receiver$iv) {
            it = (SqlBlock)element$iv;
            it.setMyWrap(this.getHostWrap());
        }
    }

    @Override
    public boolean incomplete() {
        this.grow();
        Collection collection = this.suffixes;
        if (!collection.isEmpty()) {
            return ((SqlBlock)CollectionsKt.last(this.suffixes)).incomplete();
        }
        if (this.prefix != null) {
            return true;
        }
        SqlCodeFlowBlock sqlCodeFlowBlock = (SqlCodeFlowBlock)CollectionsKt.lastOrNull(this.codeSections);
        return sqlCodeFlowBlock != null ? sqlCodeFlowBlock.incomplete() : true;
    }

    @Override
    public boolean userRequiresExpand() {
        return true;
    }
}

