/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.redshift.RedshiftLexer;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;

public class RedshiftInjectionIdentifyingLexer
extends RedshiftLexer {
    private static final Set<IElementType> ourStopper = ContainerUtil.immutableSet((Object[])new IElementType[]{SqlTokens.SQL_SEMICOLON, SqlTokens.SQL_RIGHT_PAREN, PgTypes.PG_CREATE, PgTypes.PG_SELECT});
    private final SqlLexer.LookAheadHelper myLah = new SqlLexer.LookAheadHelper(){

        @Override
        protected void superLookAhead(Lexer lexer) {
            RedshiftInjectionIdentifyingLexer.super.lookAhead(lexer);
        }
    };

    @Override
    protected void lookAhead(Lexer baseLexer) {
        this.myLah.restart(baseLexer);
        if (this.myLah.getNextToken() == PgTypes.PG_CREATE) {
            RedshiftInjectionIdentifyingLexer.lookAheadCreateFunction(this.myLah);
        }
    }

    public static void lookAheadCreateFunction(SqlLexer.LookAheadHelper lah) {
        IElementType type = lah.getNextToken();
        if (type == PgTypes.PG_OR) {
            type = RedshiftInjectionIdentifyingLexer.skipOrReplace(lah);
        }
        if (type != PgTypes.PG_FUNCTION) {
            return;
        }
        if (RedshiftInjectionIdentifyingLexer.skipQName(lah) != SqlTokens.SQL_LEFT_PAREN) {
            return;
        }
        if (RedshiftInjectionIdentifyingLexer.skipParens(lah) != SqlTokens.SQL_RIGHT_PAREN) {
            return;
        }
        String lang = null;
        int bodyIdx = -1;
        while (true) {
            IElementType token;
            if ((token = lah.getNextToken()) == SqlTokens.SQL_LEFT_PAREN) {
                if (RedshiftInjectionIdentifyingLexer.skipParens(lah) == SqlTokens.SQL_RIGHT_PAREN) continue;
                return;
            }
            if (token == null || ourStopper.contains(token)) break;
            if (token == PgTypes.PG_LANGUAGE) {
                lang = RedshiftInjectionIdentifyingLexer.getNormalizedLanguage(lah);
                if (lang == null) {
                    return;
                }
                if (bodyIdx == -1) continue;
                break;
            }
            if (token != PgTypes.PG_AS) continue;
            token = lah.getNextToken();
            if (token != SqlTokens.SQL_CUSTOM_LQUOTE || lah.getNextToken() != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
                return;
            }
            bodyIdx = lah.getPos();
            lah.getNextToken();
            if (lang != null) break;
        }
        if (bodyIdx != -1 && lang != null) {
            lah.replaceToken(bodyIdx, (IElementType)SqlTokenType.SqlInjectionMark.get(lang));
        }
    }

    private static IElementType skipParens(SqlLexer.LookAheadHelper lah) {
        IElementType type;
        do {
            IElementType tmp;
            if ((type = lah.getNextToken()) == null) {
                return null;
            }
            if (type != SqlTokens.SQL_LEFT_PAREN || (tmp = RedshiftInjectionIdentifyingLexer.skipParens(lah)) == SqlTokens.SQL_RIGHT_PAREN) continue;
            return tmp;
        } while (type != SqlTokens.SQL_RIGHT_PAREN && type != SqlTokens.SQL_SEMICOLON);
        return type;
    }

    private static IElementType skipQName(SqlLexer.LookAheadHelper lah) {
        IElementType type = lah.getNextToken();
        while (RedshiftInjectionIdentifyingLexer.isIdent(type)) {
            type = lah.getNextToken();
            if (type != SqlTokens.SQL_PERIOD) {
                return type;
            }
            type = lah.getNextToken();
        }
        return null;
    }

    private static boolean isIdent(IElementType type) {
        return type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_IDENT_DELIMITED || type instanceof SqlKeywordTokenType;
    }

    public static IElementType skipOrReplace(SqlLexer.LookAheadHelper lah) {
        IElementType type = lah.getNextToken();
        if (type == PgTypes.PG_REPLACE) {
            type = lah.getNextToken();
        }
        return type;
    }

    public static String getNormalizedLanguage(SqlLexer.LookAheadHelper lah) {
        String language = RedshiftInjectionIdentifyingLexer.getLanguage(lah);
        return language == null ? null : StringUtil.trimStart((String)language, (String)"pl");
    }

    private static String getLanguage(SqlLexer.LookAheadHelper lah) {
        IElementType type = lah.getNextToken();
        if (type == SqlTokens.SQL_CUSTOM_LQUOTE) {
            type = lah.getNextToken();
            if (type != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
                return null;
            }
            lah.getNextToken();
            return RedshiftInjectionIdentifyingLexer.getLanguage(lah, lah.getPos() - 1);
        }
        return RedshiftInjectionIdentifyingLexer.getLanguage(lah, lah.getPos());
    }

    public static String getLanguage(SqlLexer.LookAheadHelper lah, int pos) {
        IElementType type = lah.getToken(pos);
        if (type == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            return lah.getTokenText(pos).toString();
        }
        if (type instanceof SqlTokens.SqlStringLeafTokenType) {
            CharSequence raw = lah.getTokenText(pos);
            if (raw.length() < 2) {
                return null;
            }
            char q = raw.charAt(0);
            if (q != '\'' && q != '\"') {
                return null;
            }
            String qs = Character.toString(q);
            return raw.subSequence(1, raw.length() - 1).toString().replace(qs + qs, qs);
        }
        if (type instanceof SqlKeywordTokenType || type == SqlTokens.SQL_IDENT) {
            return StringUtil.toLowerCase((String)lah.getTokenText(pos).toString());
        }
        return null;
    }
}

