/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dialects.base.generator.AbstractCodeGenerator;
import com.intellij.database.dialects.base.generator.AbstractCodeGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.LinkedPriorityQueue;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.PreOrderComparator;
import com.intellij.database.dialects.base.generator.Scenario;
import com.intellij.database.dialects.base.generator.ScenarioDot;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingResultImpl;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a0\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\u000f\u00a8\u0006\u0010"}, d2={"createPreOrderComparator", "Ljava/util/Comparator;", "Lcom/intellij/database/dialects/base/generator/Operation;", "operations", "", "createResult", "Lcom/intellij/database/script/generator/ScriptingResult;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "generateSuccessors", "Lcom/intellij/util/containers/MultiMap;", "", "processOperations", "", "processor", "Lkotlin/Function1;", "intellij.database.dialects"})
public final class AbstractCodeGeneratorKt {
    @NotNull
    public static final ScriptingResult createResult(@NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ImmutableList script = ImmutableList.copyOf((Collection)context.getScript());
        context.getScript().clear();
        ImmutableList immutableList = script;
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"script");
        return new ScriptingResultImpl((List)immutableList, context.getHelper().getStatementDelimiterStr(), context.getHelper().getStatementDelimiterOwnsLine());
    }

    public static final void processOperations(@NotNull ScriptingContext context, @NotNull Set<Operation> operations, @NotNull Function1<? super Operation, Unit> processor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(operations, (String)"operations");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Comparator<Operation> cmp = AbstractCodeGeneratorKt.createPreOrderComparator((Collection<Operation>)operations);
        MultiMap<Operation, Operation> successors2 = AbstractCodeGeneratorKt.generateSuccessors(operations);
        LinkedPriorityQueue<Operation> queue = new LinkedPriorityQueue<Operation>(cmp);
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation it = (Operation)element$iv;
            if (it.getIncidence() != 0) continue;
            queue.add(it);
        }
        while (!successors2.keySet().isEmpty()) {
            Object v2;
            while (!queue.isEmpty()) {
                Operation op;
                Collection rev;
                if (queue.poll() == null) {
                    Intrinsics.throwNpe();
                }
                if ((rev = successors2.remove((Object)op)) == null) continue;
                processor.invoke((Object)op);
                Iterable $receiver$iv2 = rev;
                for (Object element$iv : $receiver$iv2) {
                    Operation it;
                    Operation operation2 = it = (Operation)element$iv;
                    operation2.setIncidence(operation2.getIncidence() + -1);
                    operation2.getIncidence();
                    if (it.getIncidence() != 0) continue;
                    Operation operation3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)operation3, (String)"it");
                    queue.add(operation3);
                }
            }
            if (successors2.keySet().isEmpty()) continue;
            Iterable $receiver$iv3 = operations;
            Iterator iterator$iv = $receiver$iv3.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                int minValue$iv;
                Object minElem$iv = iterator$iv.next();
                Operation it = (Operation)minElem$iv;
                int n = minValue$iv = successors2.containsKey((Object)it) ? it.getIncidence() : Integer.MAX_VALUE;
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    Operation it2 = (Operation)e$iv;
                    int v$iv = successors2.containsKey((Object)it2) ? it2.getIncidence() : Integer.MAX_VALUE;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                }
                v2 = minElem$iv;
            }
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            Operation breaker = v2;
            queue.add(breaker);
            processor.invoke((Object)new Operation(new BaseProducer(context, context, AbstractCodeGenerator.Companion.getERROR()){
                final /* synthetic */ ScriptingContext $context;

                public void produce() {
                    this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)processOperations.produce.1.INSTANCE));
                }
                {
                    this.$context = $captured_local_variable$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            }));
            if (context.getTask().getCategory() != ScriptCategory.CREATE_DEFINITION && context.getTask().getCategory() != ScriptCategory.CREATE_COMPLETE) continue;
            Object object = JBIterable.generate((Object)CollectionsKt.first((Iterable)operations), (Function)processOperations.root.1.INSTANCE).first();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"JBIterable.generate(oper\u2026) { it.parent }.first()!!");
            Operation root2 = (Operation)object;
            AbstractCodeGenerator.Companion.getLOG().warn("Found cycle\n" + ScenarioDot.build$default(new ScenarioDot(new Scenario(root2.getProducer()), null, 2, null), null, 1, null).toString());
        }
    }

    private static final MultiMap<Operation, Operation> generateSuccessors(Set<Operation> operations) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSet<Operation, Operation>()");
        MultiMap successors2 = multiMap;
        Iterable $receiver$iv = operations;
        for (Object element$iv : $receiver$iv) {
            Operation op = (Operation)element$iv;
            Set<Operation> flatPreceders = op.getFlatPreceders();
            successors2.getModifiable((Object)op);
            int incidence = 0;
            Iterable $receiver$iv2 = flatPreceders;
            for (Object element$iv2 : $receiver$iv2) {
                Operation p2 = (Operation)element$iv2;
                if (!operations.contains(p2)) continue;
                successors2.putValue((Object)p2, (Object)op);
                ++incidence;
            }
            op.setIncidence(incidence);
        }
        return successors2;
    }

    private static final Comparator<Operation> createPreOrderComparator(Collection<Operation> operations) {
        return new PreOrderComparator();
    }

    @NotNull
    public static final /* synthetic */ Comparator access$createPreOrderComparator(@NotNull Collection operations) {
        return AbstractCodeGeneratorKt.createPreOrderComparator(operations);
    }
}

