/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.DbImplUtil;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramElementManager
extends AbstractDiagramElementManager<DbElement> {
    @Nullable
    public DbElement findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(0);
        }
        return (DbElement)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context))).filter(DbElement.class).first();
    }

    @NotNull
    public Collection<DbElement> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            DbDiagramElementManager.$$$reportNull$$$0(1);
        }
        Set set = JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context))).filter(DbElement.class).filter(this::isAcceptableAsNode).toSet();
        if (set == null) {
            DbDiagramElementManager.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isAcceptableAsNode(Object element2) {
        return DbDiagramElementManager.isAcceptedAsNodeImpl(element2);
    }

    public static boolean isAcceptedAsNodeImpl(Object element2) {
        if (!(element2 instanceof DbElement)) {
            return false;
        }
        return element2 instanceof DbTable && DbImplUtil.isDataTable((DasTable)((DbTable)element2)) || element2 instanceof DasNamespace || element2 instanceof DbDataSource;
    }

    @NotNull
    public Object[] getNodeItems(@NotNull DbElement parent2) {
        if (parent2 == null) {
            DbDiagramElementManager.$$$reportNull$$$0(3);
        }
        if (!parent2.isValid()) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                DbDiagramElementManager.$$$reportNull$$$0(4);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List result2 = ContainerUtil.newSmartList();
        for (DbElement element2 : parent2.getDasChildren(null)) {
            if (element2 instanceof DbTableKey) continue;
            result2.add(element2);
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)result2);
        if (objectArray == null) {
            DbDiagramElementManager.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    public Icon getItemIcon(Object element2, DiagramState presentation) {
        return element2 instanceof DbElement ? ((DbElement)element2).getIcon() : super.getItemIcon(element2, presentation);
    }

    public boolean canCollapse(DbElement element2) {
        return false;
    }

    public boolean isContainerFor(DbElement parent2, DbElement child) {
        return child.getParent() == parent2;
    }

    public String getElementTitle(DbElement element2) {
        return element2.getName();
    }

    public SimpleColoredText getItemName(Object element2, DiagramState presentation) {
        if (element2 instanceof DbElement) {
            return new SimpleColoredText(((DbElement)element2).getName(), DEFAULT_TITLE_ATTR);
        }
        return null;
    }

    public SimpleColoredText getItemType(Object element2) {
        if (element2 instanceof DbColumn) {
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element2);
            String typeName = dialect.getTypeName(((DbColumn)element2).getDataType());
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        return null;
    }

    public String getNodeTooltip(DbElement element2) {
        return element2.isValid() ? element2.getTypeName() + " " + element2.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/DbDiagramElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

