/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat.steps;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.behat.steps.BehatPatternPolicy;
import com.jetbrains.php.behat.steps.BehatRegexPatternPolicy;
import com.jetbrains.php.behat.steps.BehatTurnipPatterPolicy;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class BehatPatternExtractor {
    private static final List<BehatPatternPolicy> myPatternPolicies = new ArrayList<BehatPatternPolicy>();

    @Nullable
    public static List<String> getAllPatternsFromStepDefinition(@NotNull Method method) {
        PhpDocComment comment;
        List tags;
        if (method == null) {
            BehatPatternExtractor.$$$reportNull$$$0(0);
        }
        if ((tags = PhpPsiUtil.getChildren((PsiElement)(comment = method.getDocComment()), (Condition)PhpDocTag.INSTANCEOF)).isEmpty()) {
            return null;
        }
        if (tags.size() == 1) {
            String pattern = BehatPatternExtractor.getPatternFromTag((PhpDocTag)tags.get(0));
            return StringUtil.isNotEmpty((String)pattern) ? ContainerUtil.newSmartList((Object)pattern) : null;
        }
        List patterns = ContainerUtil.newSmartList();
        for (PhpDocTag tag : tags) {
            String pattern = BehatPatternExtractor.getPatternFromTag(tag);
            if (!StringUtil.isNotEmpty((String)pattern)) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    @Nullable
    private static String getPatternFromTag(@NotNull PhpDocTag tag) {
        String text;
        if (tag == null) {
            BehatPatternExtractor.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)(text = BehatPatternExtractor.extractPatternText(tag)))) {
            return null;
        }
        return BehatPatternExtractor.applyPatternPolicy(text);
    }

    @Nullable
    private static String extractPatternText(@NotNull PhpDocTag tag) {
        PsiElement[] children;
        GherkinKeywordProvider keywordProvider;
        String tagName;
        if (tag == null) {
            BehatPatternExtractor.$$$reportNull$$$0(2);
        }
        if (StringUtil.isNotEmpty((String)(tagName = tag.getName())) && (keywordProvider = JsonGherkinKeywordProvider.getKeywordProvider()).isStepKeyword(StringUtil.trimStart((String)tagName, (String)"@")) && (children = tag.getChildren()).length > 0) {
            StringBuilder builder = new StringBuilder();
            for (PsiElement child = children[0]; child != null; child = child.getNextSibling()) {
                builder.append(child.getText());
            }
            return builder.toString();
        }
        return null;
    }

    private static String applyPatternPolicy(@NotNull String regex) {
        if (regex == null) {
            BehatPatternExtractor.$$$reportNull$$$0(3);
        }
        for (BehatPatternPolicy processor : myPatternPolicies) {
            if (!processor.isApplicable(regex)) continue;
            return processor.process(regex);
        }
        return regex;
    }

    static {
        myPatternPolicies.add(BehatRegexPatternPolicy.INSTANCE);
        myPatternPolicies.add(BehatTurnipPatterPolicy.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/behat/steps/BehatPatternExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllPatternsFromStepDefinition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPatternFromTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPatternText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyPatternPolicy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

