/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ConflictChange;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeBuilder;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeFragment;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeNoConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.SimpleChange;
import com.intellij.openapi.diff.impl.incrementalMerge.TwoSideChange;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.MergePanel2;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeList
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance(MergeList.class);
    public static final FragmentSide BRANCH_SIDE = FragmentSide.SIDE2;
    public static final FragmentSide BASE_SIDE = FragmentSide.SIDE1;
    public static final DataKey<MergeList> DATA_KEY = DataKey.create((String)"mergeList");
    public static final Condition<Change> NOT_CONFLICTS = change -> !(change instanceof ConflictChange);
    @NotNull
    private final UserDataHolderBase myDataHolder;
    @NotNull
    private final ChangeList myBaseToLeftChangeList;
    @NotNull
    private final ChangeList myBaseToRightChangeList;
    @Nullable
    private final String myErrorMessage;

    private MergeList(@Nullable Project project, @NotNull Document left, @NotNull Document base, @NotNull Document right, @Nullable String errorMessage) {
        if (left == null) {
            MergeList.$$$reportNull$$$0(0);
        }
        if (base == null) {
            MergeList.$$$reportNull$$$0(1);
        }
        if (right == null) {
            MergeList.$$$reportNull$$$0(2);
        }
        this.myDataHolder = new UserDataHolderBase();
        this.myBaseToLeftChangeList = new ChangeList(base, left, project);
        this.myBaseToRightChangeList = new ChangeList(base, right, project);
        this.myErrorMessage = errorMessage;
    }

    @NotNull
    public ChangeList getLeftChangeList() {
        ChangeList changeList = this.myBaseToLeftChangeList;
        if (changeList == null) {
            MergeList.$$$reportNull$$$0(3);
        }
        return changeList;
    }

    @NotNull
    public ChangeList getRightChangeList() {
        ChangeList changeList = this.myBaseToRightChangeList;
        if (changeList == null) {
            MergeList.$$$reportNull$$$0(4);
        }
        return changeList;
    }

    @NotNull
    public static MergeList create(@Nullable Project project, @NotNull Document left, @NotNull Document base, @NotNull Document right) {
        MergeList mergeList;
        List<Object> fragmentList;
        if (left == null) {
            MergeList.$$$reportNull$$$0(5);
        }
        if (base == null) {
            MergeList.$$$reportNull$$$0(6);
        }
        if (right == null) {
            MergeList.$$$reportNull$$$0(7);
        }
        String leftText = left.getText();
        String baseText = base.getText();
        String rightText = right.getText();
        Object[] data = new Object[]{"Left\n", leftText, "\nBase\n", baseText, "\nRight\n", rightText};
        ContextLogger logger = new ContextLogger(LOG, new ContextLogger.SimpleContext(data));
        try {
            fragmentList = MergeList.processText(leftText, baseText, rightText, logger);
            mergeList = new MergeList(project, left, base, right, null);
        }
        catch (FilesTooBigForDiffException e) {
            fragmentList = Collections.emptyList();
            mergeList = new MergeList(project, left, base, right, e.getMessage());
        }
        ArrayList<Change> leftChanges = new ArrayList<Change>();
        ArrayList<Change> rightChanges = new ArrayList<Change>();
        for (MergeFragment mergeFragment : fragmentList) {
            TwoSideChange conflict;
            TextRange rightRange;
            TextRange baseRange = mergeFragment.getBase();
            TextRange leftRange = mergeFragment.getLeft();
            if (MergeList.compareSubstring(leftText, leftRange, rightText, rightRange = mergeFragment.getRight())) {
                conflict = new MergeNoConflict(baseRange, leftRange, rightRange, mergeList);
                assert (conflict.getLeftChange() != null);
                assert (conflict.getRightChange() != null);
                leftChanges.add(conflict.getLeftChange());
                rightChanges.add(conflict.getRightChange());
                continue;
            }
            if (MergeList.compareSubstring(baseText, baseRange, leftText, leftRange)) {
                rightChanges.add(SimpleChange.fromRanges(baseRange, rightRange, mergeList.myBaseToRightChangeList));
                continue;
            }
            if (MergeList.compareSubstring(baseText, baseRange, rightText, rightRange)) {
                leftChanges.add(SimpleChange.fromRanges(baseRange, leftRange, mergeList.myBaseToLeftChangeList));
                continue;
            }
            conflict = new MergeConflict(baseRange, leftRange, rightRange, mergeList);
            assert (conflict.getLeftChange() != null);
            assert (conflict.getRightChange() != null);
            leftChanges.add(conflict.getLeftChange());
            rightChanges.add(conflict.getRightChange());
        }
        mergeList.myBaseToLeftChangeList.setChanges(leftChanges);
        mergeList.myBaseToRightChangeList.setChanges(rightChanges);
        MergeList mergeList2 = mergeList;
        if (mergeList2 == null) {
            MergeList.$$$reportNull$$$0(8);
        }
        return mergeList2;
    }

    private static boolean compareSubstring(@NotNull String text1, @NotNull TextRange range1, @NotNull String text2, @NotNull TextRange range2) {
        if (text1 == null) {
            MergeList.$$$reportNull$$$0(9);
        }
        if (range1 == null) {
            MergeList.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            MergeList.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            MergeList.$$$reportNull$$$0(12);
        }
        if (range1.getLength() != range2.getLength()) {
            return false;
        }
        int index1 = range1.getStartOffset();
        int index2 = range2.getStartOffset();
        while (index1 < range1.getEndOffset()) {
            if (text1.charAt(index1) != text2.charAt(index2)) {
                return false;
            }
            ++index1;
            ++index2;
        }
        return true;
    }

    @NotNull
    private static List<MergeFragment> processText(@NotNull String leftText, @NotNull String baseText, @NotNull String rightText, @NotNull ContextLogger logger) throws FilesTooBigForDiffException {
        if (leftText == null) {
            MergeList.$$$reportNull$$$0(13);
        }
        if (baseText == null) {
            MergeList.$$$reportNull$$$0(14);
        }
        if (rightText == null) {
            MergeList.$$$reportNull$$$0(15);
        }
        if (logger == null) {
            MergeList.$$$reportNull$$$0(16);
        }
        DiffFragment[] leftFragments = DiffPolicy.DEFAULT_LINES.buildFragments(DiffString.create((String)baseText), DiffString.create((String)leftText));
        DiffFragment[] rightFragments = DiffPolicy.DEFAULT_LINES.buildFragments(DiffString.create((String)baseText), DiffString.create((String)rightText));
        int[] leftOffsets = new int[]{0, 0};
        int[] rightOffsets = new int[]{0, 0};
        int leftIndex = 0;
        int rightIndex = 0;
        MergeBuilder builder2 = new MergeBuilder(logger);
        while (leftIndex < leftFragments.length || rightIndex < rightFragments.length) {
            FragmentSide side;
            TextRange[] equalRanges = new TextRange[2];
            if (leftOffsets[0] < rightOffsets[0] && leftIndex < leftFragments.length) {
                side = FragmentSide.SIDE1;
                MergeList.getEqualRanges(leftFragments[leftIndex], leftOffsets, equalRanges);
                ++leftIndex;
            } else {
                if (rightIndex >= rightFragments.length) break;
                side = FragmentSide.SIDE2;
                MergeList.getEqualRanges(rightFragments[rightIndex], rightOffsets, equalRanges);
                ++rightIndex;
            }
            if (equalRanges[0] != null && equalRanges[1] != null) {
                builder2.add(equalRanges[0], equalRanges[1], side);
                continue;
            }
            logger.assertTrue(equalRanges[0] == null && equalRanges[1] == null);
        }
        List<MergeFragment> list2 = builder2.finish(leftText.length(), baseText.length(), rightText.length());
        if (list2 == null) {
            MergeList.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static void getEqualRanges(@NotNull DiffFragment fragment, @NotNull int[] leftOffsets, @NotNull TextRange[] equalRanges) {
        if (fragment == null) {
            MergeList.$$$reportNull$$$0(18);
        }
        if (leftOffsets == null) {
            MergeList.$$$reportNull$$$0(19);
        }
        if (equalRanges == null) {
            MergeList.$$$reportNull$$$0(20);
        }
        int baseLength = MergeList.getTextLength(fragment.getText1());
        int versionLength = MergeList.getTextLength(fragment.getText2());
        if (fragment.isEqual()) {
            equalRanges[0] = new TextRange(leftOffsets[0], leftOffsets[0] + baseLength);
            equalRanges[1] = new TextRange(leftOffsets[1], leftOffsets[1] + versionLength);
        } else {
            equalRanges[0] = null;
            equalRanges[1] = null;
        }
        leftOffsets[0] = leftOffsets[0] + baseLength;
        leftOffsets[1] = leftOffsets[1] + versionLength;
    }

    private static int getTextLength(@Nullable DiffString text1) {
        return text1 != null ? text1.length() : 0;
    }

    public static MergeList create(@NotNull DiffRequest data) {
        if (data == null) {
            MergeList.$$$reportNull$$$0(21);
        }
        DiffContent[] contents = data.getContents();
        return MergeList.create(data.getProject(), contents[0].getDocument(), contents[1].getDocument(), contents[2].getDocument());
    }

    public void setMarkups(Editor left, Editor base, Editor right) {
        this.myBaseToLeftChangeList.setMarkup(base, left);
        this.myBaseToRightChangeList.setMarkup(base, right);
        this.addActions(FragmentSide.SIDE1);
        this.addActions(FragmentSide.SIDE2);
    }

    public Iterator<Change> getAllChanges() {
        return ContainerUtil.concatIterators((Iterator[])new Iterator[]{this.myBaseToLeftChangeList.getChanges().iterator(), this.myBaseToRightChangeList.getChanges().iterator()});
    }

    public void addListener(ChangeList.Listener listener2) {
        this.myBaseToLeftChangeList.addListener(listener2);
        this.myBaseToRightChangeList.addListener(listener2);
    }

    public void removeListener(ChangeList.Listener listener2) {
        this.myBaseToLeftChangeList.removeListener(listener2);
        this.myBaseToRightChangeList.removeListener(listener2);
    }

    private void addActions(@NotNull FragmentSide side) {
        if (side == null) {
            MergeList.$$$reportNull$$$0(22);
        }
        ChangeList changeList = this.getChanges(side);
        FragmentSide originalSide = BRANCH_SIDE;
        for (int i = 0; i < changeList.getCount(); ++i) {
            Change change = changeList.getChange(i);
            if (!change.canHasActions(originalSide)) continue;
            Icon arrowIcon = side == FragmentSide.SIDE1 ? AllIcons.Diff.ArrowRight : AllIcons.Diff.Arrow;
            ApplyAction applyAction = new ApplyAction(arrowIcon, change);
            IgnoreAction ignoreAction = new IgnoreAction(change);
            change.getChangeSide(originalSide).getHighlighterHolder().setActions(new AnAction[]{applyAction, ignoreAction});
        }
    }

    private static void apply(Change change) {
        Change.apply(change, BRANCH_SIDE);
    }

    @NotNull
    public ChangeList getChanges(@NotNull FragmentSide changesSide) {
        if (changesSide == null) {
            MergeList.$$$reportNull$$$0(23);
        }
        if (changesSide == FragmentSide.SIDE1) {
            ChangeList changeList = this.myBaseToLeftChangeList;
            if (changeList == null) {
                MergeList.$$$reportNull$$$0(24);
            }
            return changeList;
        }
        ChangeList changeList = this.myBaseToRightChangeList;
        if (changeList == null) {
            MergeList.$$$reportNull$$$0(25);
        }
        return changeList;
    }

    public void removeChanges(@Nullable Change leftChange, @Nullable Change rightChange) {
        if (leftChange != null) {
            this.myBaseToLeftChangeList.remove(leftChange);
        }
        if (rightChange != null) {
            this.myBaseToRightChangeList.remove(rightChange);
        }
    }

    public Document getBaseDocument() {
        Document document = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        LOG.assertTrue(document == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        return document;
    }

    @Nullable
    public static MergeList fromDataContext(DataContext dataContext) {
        MergeList mergeList = (MergeList)DATA_KEY.getData(dataContext);
        if (mergeList != null) {
            return mergeList;
        }
        MergePanel2 mergePanel = MergePanel2.fromDataContext(dataContext);
        return mergePanel == null ? null : mergePanel.getMergeList();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            MergeList.$$$reportNull$$$0(26);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            MergeList.$$$reportNull$$$0(27);
        }
        this.myDataHolder.putUserData(key, value);
    }

    @NotNull
    public FragmentSide getSideOf(@NotNull ChangeList source) {
        if (source == null) {
            MergeList.$$$reportNull$$$0(28);
        }
        if (this.myBaseToLeftChangeList == source) {
            FragmentSide fragmentSide = FragmentSide.SIDE1;
            if (fragmentSide == null) {
                MergeList.$$$reportNull$$$0(29);
            }
            return fragmentSide;
        }
        FragmentSide fragmentSide = FragmentSide.SIDE2;
        if (fragmentSide == null) {
            MergeList.$$$reportNull$$$0(30);
        }
        return fragmentSide;
    }

    public void updateMarkup() {
        this.myBaseToLeftChangeList.updateMarkup();
        this.myBaseToRightChangeList.updateMarkup();
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public void startBulkUpdate() {
        Document document1 = this.myBaseToLeftChangeList.getDocument(BRANCH_SIDE);
        Document document2 = this.myBaseToRightChangeList.getDocument(BRANCH_SIDE);
        Document document3 = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        assert (document3 == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        ((DocumentEx)document1).setInBulkUpdate(true);
        ((DocumentEx)document2).setInBulkUpdate(true);
        ((DocumentEx)document3).setInBulkUpdate(true);
    }

    public void finishBulkUpdate() {
        Document document1 = this.myBaseToLeftChangeList.getDocument(BRANCH_SIDE);
        Document document2 = this.myBaseToRightChangeList.getDocument(BRANCH_SIDE);
        Document document3 = this.myBaseToLeftChangeList.getDocument(BASE_SIDE);
        assert (document3 == this.myBaseToRightChangeList.getDocument(BASE_SIDE));
        ((DocumentEx)document1).setInBulkUpdate(false);
        ((DocumentEx)document2).setInBulkUpdate(false);
        ((DocumentEx)document3).setInBulkUpdate(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOffsets";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalRanges";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesSide";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/incrementalMerge/MergeList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftChangeList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightChangeList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSideOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareSubstring";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEqualRanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getSideOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 17: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class IgnoreAction
    extends DumbAwareAction {
        private final Change myChange;

        IgnoreAction(Change change) {
            super(DiffBundle.message((String)"merge.dialog.ignore.change.action.name", (Object[])new Object[0]), null, AllIcons.Diff.Remove);
            this.myChange = change;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                IgnoreAction.$$$reportNull$$$0(0);
            }
            this.perform();
        }

        void perform() {
            this.myChange.removeFromList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList$IgnoreAction", "actionPerformed"));
        }
    }

    static class ApplyAction
    extends DumbAwareAction {
        private final Change myChange;

        ApplyAction(Icon arrowIcon, Change change) {
            super(DiffBundle.message((String)"merge.dialog.apply.change.action.name", (Object[])new Object[0]), null, arrowIcon);
            this.myChange = change;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplyAction.$$$reportNull$$$0(0);
            }
            this.perform();
        }

        void perform() {
            MergeList.apply(this.myChange);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/incrementalMerge/MergeList$ApplyAction", "actionPerformed"));
        }
    }
}

