/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
extends ApplicationStarterEx {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(String commandName, int ... possibleArgumentsCount) {
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean isHeadless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalCommandLine(@NotNull String[] args, @Nullable String currentDirectory) {
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(0);
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args, currentDirectory);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)String.format("Error showing %s: %s", this.getCommandName(), e.getMessage()), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
    }

    protected static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    private boolean checkArguments(String[] args) {
        return Arrays.binarySearch(this.myArgsCount, args.length - 1) != -1 && this.getCommandName().equals(args[0]);
    }

    public abstract String getUsageMessage();

    protected abstract void processCommand(String[] var1, @Nullable String var2) throws Exception;

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        try {
            this.processCommand(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(0);
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/openapi/application/ApplicationStarterBase", "processExternalCommandLine"));
    }
}

