/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularNamedItemDefinition;
import org.jetbrains.annotations.NotNull;

public class AngularAttributeIndexer
implements DataIndexer<String, AngularNamedItemDefinition, FileContent> {
    private final String myDirectiveName;

    public AngularAttributeIndexer(@NotNull String directiveName) {
        if (directiveName == null) {
            AngularAttributeIndexer.$$$reportNull$$$0(0);
        }
        this.myDirectiveName = directiveName;
    }

    @NotNull
    public Map<String, AngularNamedItemDefinition> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            AngularAttributeIndexer.$$$reportNull$$$0(1);
        }
        final HashMap<String, AngularNamedItemDefinition> map = new HashMap<String, AngularNamedItemDefinition>();
        PsiFile file = inputData.getPsiFile();
        if (file instanceof XmlFile) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    if (AngularAttributeIndexer.this.myDirectiveName.equals(DirectiveUtil.normalizeAttributeName(attribute.getName()))) {
                        XmlAttributeValue element = attribute.getValueElement();
                        if (element == null) {
                            map.put("", new AngularNamedItemDefinition("", attribute.getTextRange().getStartOffset()));
                        } else {
                            String name = StringUtil.unquoteString((String)element.getText());
                            map.put(name, new AngularNamedItemDefinition(name, element.getTextRange().getStartOffset()));
                        }
                    }
                }
            });
        }
        HashMap<String, AngularNamedItemDefinition> hashMap = map;
        if (hashMap == null) {
            AngularAttributeIndexer.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/index/AngularAttributeIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/index/AngularAttributeIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

