/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hsqldb.Server;

public class DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    String mUrl;
    String mUser = "sa";
    String mPassword = "";
    Server mServer = null;
    Connection mConn = null;

    DatabaseServer(String string) throws ClassNotFoundException, Exception {
        this.start(string);
    }

    private void start(String string) throws ClassNotFoundException, Exception {
        string = string.replaceAll("\\\\", "/");
        this.mUrl = "jdbc:hsqldb:file:" + string;
        Class.forName("org.hsqldb.jdbcDriver");
        this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
    }

    void shutdown(boolean bl) throws SQLException {
        Connection connection = this.getSingletonConnection();
        CallableStatement callableStatement = null;
        callableStatement = bl ? connection.prepareCall("SHUTDOWN COMPACT") : connection.prepareCall("SHUTDOWN");
        callableStatement.execute();
        this.mConn.close();
        this.mConn = null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        for (int i = 0; i < 5; ++i) {
            try {
                connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                return connection;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (i == 4) {
                    throw sQLException;
                }
                System.out.println("Recovering " + i + " times.");
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return connection;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.mConn == null) {
            this.mConn = this.getNewConnection();
        }
        return this.mConn;
    }
}

