/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.MonotoneHistoryParser;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class MonotoneRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.Monotone";
    public static final String CMD_FALLBACK = "mnt";
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("^(\\w+)\\p{Punct}\\p{Punct} by (\\S+)");
    public static final String DEPRECATED_KEY = "org.opensolaris.opengrok.history.monotone.deprecated";

    public MonotoneRepository() {
        this.type = "Monotone";
        this.datePattern = "yyyy-MM-dd'T'hh:mm:ss";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        BufferedInputStream ret = null;
        File directory = new File(this.directoryName);
        Process process = null;
        String revision = rev;
        try {
            String filename = new File(parent, basename).getCanonicalPath().substring(this.directoryName.length() + 1);
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            String[] argv = new String[]{this.cmd, "cat", "-r", revision, filename};
            process = Runtime.getRuntime().exec(argv, null, directory);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32768];
            try (InputStream in = process.getInputStream();){
                int len;
                while ((len = in.read(buffer)) != -1) {
                    if (len <= 0) continue;
                    out.write(buffer, 0, len);
                }
            }
            ret = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (Exception exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get history: " + exp.getClass().toString());
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    Executor getHistoryLogExecutor(File file, String changeset) throws IOException {
        String abs = file.getCanonicalPath();
        String filename = "";
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("log");
        if (changeset != null) {
            cmd.add("--to");
            cmd.add(changeset);
        }
        cmd.add("--no-graph");
        cmd.add("--no-merges");
        cmd.add("--no-format-dates");
        cmd.add(filename);
        return new Executor(cmd, new File(this.directoryName));
    }

    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("annotate");
        cmd.add(this.getQuietOption());
        if (revision != null) {
            cmd.add("-r");
            cmd.add(revision);
        }
        cmd.add(file.getName());
        File directory = new File(this.directoryName);
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
        Annotation ret = null;
        try (BufferedReader in = new BufferedReader(executor.getOutputReader());){
            String line;
            ret = new Annotation(file.getName());
            String author = null;
            String rev = null;
            while ((line = in.readLine()) != null) {
                Matcher matcher = ANNOTATION_PATTERN.matcher(line);
                if (matcher.find()) {
                    rev = matcher.group(1);
                    author = matcher.group(2);
                    ret.addLine(rev, author, true);
                    continue;
                }
                ret.addLine(rev, author, true);
            }
        }
        return ret;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.directoryName);
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.cmd);
        cmd.add("pull");
        cmd.add(this.getQuietOption());
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
        cmd.clear();
        cmd.add(this.cmd);
        cmd.add("update");
        cmd.add(this.getQuietOption());
        executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    boolean isRepositoryFor(File file) {
        File f = new File(file, "_MTN");
        return f.exists() && f.isDirectory();
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = MonotoneRepository.checkCmd(this.cmd, "--help");
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return this.getHistory(file, null);
    }

    @Override
    History getHistory(File file, String sinceRevision) throws HistoryException {
        return new MonotoneHistoryParser(this).parse(file, sinceRevision);
    }

    private String getQuietOption() {
        if (this.useDeprecated()) {
            return "--reallyquiet";
        }
        return "--quiet --quiet";
    }

    private boolean useDeprecated() {
        return Boolean.parseBoolean(System.getProperty(DEPRECATED_KEY, "false"));
    }
}

