/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.DefaultPiecePainter;
import free.chess.ImagePiecePainter;
import free.chess.PiecePainter;
import free.chess.ResourcePiecePainter;
import free.jin.Resource;
import free.jin.Server;
import free.jin.plugin.Plugin;
import free.util.IOUtilities;
import free.util.PlatformUtils;
import free.util.TextUtilities;
import free.util.URLClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class PieceSet
implements Resource {
    public static final PieceSet DEFAULT_PIECE_SET = new PieceSet();
    private String name;
    private String id;
    private String[] serverIds;
    private PiecePainter piecePainter;

    public boolean load(URL uRL, Plugin plugin) throws IOException {
        Class<?> clazz;
        String string;
        Properties properties = IOUtilities.loadProperties((URL)new URL(uRL, "definition"), (boolean)true);
        String string2 = properties.getProperty("minJavaVersion");
        if (string2 != null && !PlatformUtils.isJavaBetterThan((String)string2)) {
            return false;
        }
        this.name = properties.getProperty("name");
        this.id = properties.getProperty("id");
        String string3 = properties.getProperty("servers");
        if (string3 != null) {
            this.serverIds = TextUtilities.getTokens((String)string3, (String)" ");
        }
        if ((string = properties.getProperty("piecePainter.classname")) == null && "ImagePieceSetLoader".equals(clazz = properties.getProperty("classname"))) {
            string = ImagePiecePainter.class.getName();
        }
        clazz = null;
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(uRL);
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = plugin.getClass().getClassLoader().loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (clazz == null) {
            throw new IOException("Unable to load piece painter class: " + string);
        }
        try {
            this.piecePainter = (PiecePainter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (this.piecePainter == null) {
            throw new IOException("Unable to instantiate class " + clazz);
        }
        if (this.piecePainter instanceof ResourcePiecePainter) {
            ((ResourcePiecePainter)this.piecePainter).load(uRL);
        }
        return true;
    }

    public String getType() {
        return "pieces";
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isCompatibleWith(Server server) {
        if (this.serverIds == null) {
            return true;
        }
        for (int i = 0; i < this.serverIds.length; ++i) {
            if (!this.serverIds[i].equals(server.getId())) continue;
            return true;
        }
        return false;
    }

    public PiecePainter getPiecePainter() {
        return this.piecePainter.freshInstance();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PieceSet)) {
            return false;
        }
        PieceSet pieceSet = (PieceSet)object;
        return this.getType().equals(pieceSet.getType()) && this.getId().equals(pieceSet.getId());
    }

    public int hashCode() {
        return this.getId().hashCode() ^ this.getType().hashCode();
    }

    static {
        PieceSet.DEFAULT_PIECE_SET.name = "Default";
        PieceSet.DEFAULT_PIECE_SET.id = "default";
        PieceSet.DEFAULT_PIECE_SET.piecePainter = new DefaultPiecePainter();
    }
}

