/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.BoardPainter;
import free.chess.DefaultBoardPainter;
import free.chess.ImageBoardPainter;
import free.chess.ResourceBoardPainter;
import free.jin.Resource;
import free.jin.Server;
import free.jin.plugin.Plugin;
import free.util.IOUtilities;
import free.util.PlatformUtils;
import free.util.TextUtilities;
import free.util.URLClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class BoardPattern
implements Resource {
    public static final BoardPattern DEFAULT_BOARD_PATTERN = new BoardPattern();
    private String name;
    private String id;
    private String[] serverIds;
    private BoardPainter boardPainter;

    public boolean load(URL uRL, Plugin plugin) throws IOException {
        Class<?> clazz;
        String string;
        Properties properties = IOUtilities.loadProperties((URL)new URL(uRL, "definition"), (boolean)true);
        String string2 = properties.getProperty("minJavaVersion");
        if (string2 != null && !PlatformUtils.isJavaBetterThan((String)string2)) {
            return false;
        }
        this.name = properties.getProperty("name");
        this.id = properties.getProperty("id");
        String string3 = properties.getProperty("servers");
        if (string3 != null) {
            this.serverIds = TextUtilities.getTokens((String)string3, (String)" ");
        }
        if ((string = properties.getProperty("boardPainter.classname")) == null && "ImageBoardLoader".equals(clazz = properties.getProperty("classname"))) {
            string = ImageBoardPainter.class.getName();
        }
        clazz = null;
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(uRL);
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = plugin.getClass().getClassLoader().loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        if (clazz == null) {
            throw new IOException("Unable to load board painter class: " + string);
        }
        try {
            this.boardPainter = (BoardPainter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        if (this.boardPainter == null) {
            throw new IOException("Unable to instantiate class " + clazz);
        }
        if (this.boardPainter instanceof ResourceBoardPainter) {
            ((ResourceBoardPainter)this.boardPainter).load(uRL);
        }
        return true;
    }

    public String getType() {
        return "boards";
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isCompatibleWith(Server server) {
        if (this.serverIds == null) {
            return true;
        }
        for (int i = 0; i < this.serverIds.length; ++i) {
            if (!this.serverIds[i].equals(server.getId())) continue;
            return true;
        }
        return false;
    }

    public BoardPainter getBoardPainter() {
        return this.boardPainter.freshInstance();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoardPattern)) {
            return false;
        }
        BoardPattern boardPattern = (BoardPattern)object;
        return this.getType().equals(boardPattern.getType()) && this.getId().equals(boardPattern.getId());
    }

    public int hashCode() {
        return this.getId().hashCode() ^ this.getType().hashCode();
    }

    static {
        BoardPattern.DEFAULT_BOARD_PATTERN.name = "Default";
        BoardPattern.DEFAULT_BOARD_PATTERN.id = "default";
        BoardPattern.DEFAULT_BOARD_PATTERN.boardPainter = new DefaultBoardPainter();
    }
}

