/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class ImageUtilities {
    public static final int COMPLETE = 1;
    public static final int ERRORED = 2;
    public static final int ABORTED = 3;
    public static final int INTERRUPTED = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int preload(Image image) {
        Object object;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if ((toolkit.checkImage(image, -1, -1, null) & 0x20) != 0) {
            return 1;
        }
        Object object2 = object = new Object();
        synchronized (object2) {
            ImageLoadObserver imageLoadObserver = new ImageLoadObserver(object);
            toolkit.prepareImage(image, -1, -1, imageLoadObserver);
            int n = toolkit.checkImage(image, -1, -1, null);
            if ((n & 0x20) != 0) {
                return 1;
            }
            if ((n & 0x40) != 0) {
                return 2;
            }
            if ((n & 0x80) != 0) {
                return 3;
            }
            try {
                object.wait();
                return imageLoadObserver.getResult();
            }
            catch (InterruptedException interruptedException) {
                return 4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] preload(Image[] imageArray, int[] nArray) {
        int n;
        Object[] objectArray = new Object[imageArray.length];
        ImageLoadObserver[] imageLoadObserverArray = new ImageLoadObserver[imageArray.length];
        if (nArray == null || nArray.length < imageArray.length) {
            nArray = new int[imageArray.length];
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (n = 0; n < imageArray.length; ++n) {
            objectArray[n] = new Object();
            imageLoadObserverArray[n] = new ImageLoadObserver(objectArray[n]);
            toolkit.prepareImage(imageArray[n], -1, -1, imageLoadObserverArray[n]);
        }
        for (n = 0; n < imageArray.length; ++n) {
            Object object = objectArray[n];
            synchronized (object) {
                int n2 = toolkit.checkImage(imageArray[n], -1, -1, null);
                if ((n2 & 0x20) != 0) {
                    nArray[n] = 1;
                    continue;
                }
                if ((n2 & 0x40) != 0) {
                    nArray[n] = 2;
                    continue;
                }
                if ((n2 & 0x80) != 0) {
                    nArray[n] = 3;
                    continue;
                }
                try {
                    objectArray[n].wait();
                    nArray[n] = imageLoadObserverArray[n].getResult();
                }
                catch (InterruptedException interruptedException) {
                    nArray[n] = 4;
                }
                continue;
            }
        }
        return nArray;
    }

    public static boolean isLoaded(Image image) {
        return (Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x20) != 0;
    }

    public static class ImageLoadObserver
    implements ImageObserver {
        private final Object lock;
        private int result = -1;

        public ImageLoadObserver(Object object) {
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            Object object = this.lock;
            synchronized (object) {
                if ((n & 0x20) != 0) {
                    this.result = 1;
                    this.lock.notify();
                    return false;
                }
                if ((n & 0x40) != 0) {
                    this.result = 2;
                    this.lock.notify();
                    return false;
                }
                if ((n & 0x80) != 0) {
                    this.result = 3;
                    this.lock.notify();
                    return false;
                }
            }
            return true;
        }

        public int getResult() {
            return this.result;
        }
    }
}

