/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class LiquidMenuItemUI
extends MenuItemUI {
    protected static int defaultTextIconGap;
    protected static int defaultIconGap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static final String MAX_ICON_WIDTH = "maxIconWidth";
    static SkinMenuItem skin;
    static Skin topSkin;
    static Rectangle zeroRect;
    static Rectangle iconRect;
    static Rectangle textRect;
    static Rectangle acceleratorRect;
    static Rectangle checkIconRect;
    static Rectangle arrowIconRect;
    static Rectangle viewRect;
    static Rectangle r;
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon selArrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.selArrowIcon instanceof UIResource) {
            this.selArrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private final PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, defaultTextIconGap);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
            } else {
                g.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
                g.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 2);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
        }
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private final void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, defaultTextIconGap);
    }

    private final boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j = oldPath.length - 1;
            while (j >= 0) {
                if (oldPath[j].getComponent() == parent) break;
                --j;
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private final boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    public static ComponentUI createUI(JComponent c) {
        return new LiquidMenuItemUI();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        }
        defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.useCheckAndArrow()) {
            if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
                this.arrowIcon = UIManager.getIcon(prefix + ".arrowIcon");
            }
            if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
                this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
            }
        }
        defaultTextIconGap = 8;
        defaultIconGap = 4;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
        FontMetrics fmAccel = b.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(LiquidMenuItemUI.iconRect.x, LiquidMenuItemUI.iconRect.y, LiquidMenuItemUI.iconRect.width, LiquidMenuItemUI.iconRect.height, r);
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxIconValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
            Integer maxIconWidth = (Integer)p.getClientProperty(MAX_ICON_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            int n = maxIconValue = maxIconWidth != null ? maxIconWidth : 0;
            if (LiquidMenuItemUI.r.width < maxTextValue) {
                LiquidMenuItemUI.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(LiquidMenuItemUI.r.width));
            }
            if (LiquidMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = LiquidMenuItemUI.acceleratorRect.width;
                p.putClientProperty(MAX_ACC_WIDTH, new Integer(LiquidMenuItemUI.acceleratorRect.width));
            }
            if (icon != null && icon.getIconWidth() > maxIconValue) {
                maxIconValue = icon.getIconWidth();
                p.putClientProperty(MAX_ICON_WIDTH, new Integer(maxIconValue));
            }
            LiquidMenuItemUI.r.width += maxAccValue;
            LiquidMenuItemUI.r.width += defaultTextIconGap;
        }
        if (this.useCheckAndArrow()) {
            LiquidMenuItemUI.r.width += LiquidMenuItemUI.checkIconRect.width;
            LiquidMenuItemUI.r.width += defaultTextIconGap;
            LiquidMenuItemUI.r.width += defaultTextIconGap;
            LiquidMenuItemUI.r.width += LiquidMenuItemUI.arrowIconRect.width;
        }
        LiquidMenuItemUI.r.width += defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            LiquidMenuItemUI.r.width += insets.left + insets.right;
            LiquidMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (LiquidMenuItemUI.r.width % 2 == 0) {
            ++LiquidMenuItemUI.r.width;
        }
        if (LiquidMenuItemUI.r.height % 2 != 0) {
            --LiquidMenuItemUI.r.height;
        }
        if (LiquidMenuItemUI.r.height < 24) {
            LiquidMenuItemUI.r.height = 20;
        }
        return r.getSize();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        Icon bicon = b.getIcon();
        JComponent p = (JComponent)b.getParent();
        Integer maxValueInt = (Integer)p.getClientProperty(MAX_ICON_WIDTH);
        int maxValue = maxValueInt == null ? 16 : maxValueInt;
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        LiquidMenuItemUI.viewRect.x += 0;
        LiquidMenuItemUI.viewRect.y += i.top;
        LiquidMenuItemUI.viewRect.width -= i.right + LiquidMenuItemUI.viewRect.x;
        LiquidMenuItemUI.viewRect.height -= i.bottom + LiquidMenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        int offset = 0;
        Icon ic = b.getIcon();
        Icon iCheck = checkIcon;
        Icon paintIcon = ic;
        if (this.useCheckAndArrow()) {
            if (c instanceof JCheckBoxMenuItem || c instanceof JRadioButtonMenuItem) {
                ic = checkIcon;
                if (checkIcon.getIconWidth() < maxValue) {
                    ic = new EmptyIcon(maxValue, checkIcon.getIconHeight());
                    offset = (maxValue - checkIcon.getIconWidth()) / 2;
                }
                paintIcon = null;
            } else if (c instanceof JMenuItem && (ic == null || ic.getIconWidth() < maxValue)) {
                int height = ic == null ? 2 : b.getIcon().getIconHeight();
                int width = ic == null ? 2 : b.getIcon().getIconWidth();
                offset = (maxValue - width) / 2;
                ic = new EmptyIcon(maxValue, height);
            }
        }
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, ic, null, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultIconGap);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.useCheckAndArrow()) {
                if (c instanceof JCheckBoxMenuItem) {
                    if (model.isSelected()) {
                        UIManager.getIcon("CheckBoxMenuItem.checkedIcon").paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset - 2, LiquidMenuItemUI.iconRect.y);
                    } else {
                        checkIcon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset - 2, LiquidMenuItemUI.iconRect.y);
                    }
                }
                if (c instanceof JRadioButtonMenuItem) {
                    if (model.isSelected()) {
                        UIManager.getIcon("RadioButtonMenuItem.checkedIcon").paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset, LiquidMenuItemUI.iconRect.y);
                    } else {
                        checkIcon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset, LiquidMenuItemUI.iconRect.y);
                    }
                }
            }
            g.setColor(holdc);
        }
        if (paintIcon != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
                if (icon != null) {
                    icon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset, LiquidMenuItemUI.iconRect.y);
                }
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
                if (icon != null) {
                    icon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset, LiquidMenuItemUI.iconRect.y);
                }
            } else if (model.isArmed() || model.isSelected()) {
                icon = b.getIcon();
                if (icon != null) {
                    Icon disabled = b.getDisabledIcon();
                    if (disabled != null) {
                        disabled.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset + 1, LiquidMenuItemUI.iconRect.y + 1);
                    }
                    icon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset - 1, LiquidMenuItemUI.iconRect.y - 1);
                }
            } else {
                icon = b.getIcon();
                if (icon != null) {
                    icon.paintIcon(c, g, LiquidMenuItemUI.iconRect.x + offset, LiquidMenuItemUI.iconRect.y);
                }
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                Integer amaxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int amaxValue = amaxValueInt != null ? amaxValueInt : LiquidMenuItemUI.acceleratorRect.width;
                accOffset = amaxValue - LiquidMenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, LiquidMenuItemUI.acceleratorRect.x - accOffset, LiquidMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, LiquidMenuItemUI.acceleratorRect.x - accOffset, LiquidMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, LiquidMenuItemUI.acceleratorRect.x - accOffset - 1, LiquidMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, LiquidMenuItemUI.acceleratorRect.x - accOffset, LiquidMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null && c instanceof JMenu) {
            JMenu menu = null;
            if (c instanceof JMenu) {
                menu = (JMenu)c;
            }
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                if (model.isSelected()) {
                    UIManager.getIcon("MenuItem.selArrowIcon").paintIcon(c, g, LiquidMenuItemUI.arrowIconRect.x, LiquidMenuItemUI.arrowIconRect.y);
                } else if (menu.isEnabled()) {
                    UIManager.getIcon("MenuItem.arrowIcon").paintIcon(c, g, LiquidMenuItemUI.arrowIconRect.x, LiquidMenuItemUI.arrowIconRect.y);
                }
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        boolean mouseOver = model.isArmed() || menuItem instanceof JMenu && model.isSelected();
        int maxValue = menuWidth;
        g.setColor(new Color(246, 245, 244));
        g.fillRect(0, 0, menuWidth, menuHeight);
        g.setColor(oldColor);
        if (this.useCheckAndArrow()) {
            JComponent p = (JComponent)menuItem.getParent();
            Integer maxValueInt = (Integer)p.getClientProperty(MAX_ICON_WIDTH);
            maxValue = maxValueInt == null ? 16 : maxValueInt;
            skin.draw(g, model.isEnabled(), mouseOver, false, false, menuWidth, maxValue += defaultTextIconGap, menuHeight);
            if (!mouseOver) {
                Color old = g.getColor();
                g.setColor(new Color(238, 237, 236));
                int i = 2;
                while (i <= menuHeight) {
                    g.drawLine(0, i, menuWidth - 1, i);
                    g.drawLine(0, i + 1, menuWidth - 1, i + 1);
                    i += 4;
                }
                g.setColor(old);
            }
        } else {
            boolean isRollover = menuItem.getClientProperty("rollover") == Boolean.TRUE;
            int index = 2;
            if (!model.isEnabled()) {
                index = 2;
            } else if (model.isSelected()) {
                index = 1;
            } else if (isRollover) {
                index = 0;
            }
            topSkin.draw(g, index, 0, 1, menuWidth, menuHeight - 1);
            if (index == 2) {
                Color old = g.getColor();
                g.setColor(new Color(238, 237, 236));
                int i = 2;
                while (i < menuHeight) {
                    g.drawLine(0, i, menuWidth - 1, i);
                    g.drawLine(0, i + 1, menuWidth - 1, i + 1);
                    i += 4;
                }
                g.setColor(old);
            }
        }
    }

    private final String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.height = checkIcon.getIconHeight();
                checkIconRect.width = checkIcon.getIconWidth();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        } else {
            checkIconRect.height = 0;
            checkIconRect.width = 0;
            arrowIconRect.height = 0;
            arrowIconRect.width = 0;
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (checkIcon != null) {
            checkIconRect.x += menuItemGap;
        } else {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
        }
        acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
            arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
        }
        return text;
    }

    static /* synthetic */ boolean access$0() {
        return DEBUG;
    }

    static {
        skin = new SkinMenuItem("menu.png", 0, 1, 2, 3, 4);
        topSkin = new Skin("menu_top.png", 3, 4, 10, 4, 11);
        zeroRect = new Rectangle(0, 0, 0, 0);
        iconRect = new Rectangle();
        textRect = new Rectangle();
        acceleratorRect = new Rectangle();
        checkIconRect = new Rectangle();
        arrowIconRect = new Rectangle();
        viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        r = new Rectangle();
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < LiquidMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < LiquidMenuItemUI.this.menuItem.getHeight()) {
                LiquidMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(LiquidMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    int c = path.length - 1;
                    while (i < c) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        MouseInputHandler() {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < LiquidMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < LiquidMenuItemUI.this.menuItem.getHeight()) {
                LiquidMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }

        MenuDragMouseHandler() {
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        public void menuKeyTyped(MenuKeyEvent e) {
            int key = LiquidMenuItemUI.this.menuItem.getMnemonic();
            if (key == 0 || e.getPath().length != 2) {
                return;
            }
            if (this.lower((char)key) == this.lower(e.getKeyChar())) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                LiquidMenuItemUI.this.doClick(manager);
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private final char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }

        MenuKeyHandler() {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                LiquidMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }

        PropertyChangeHandler() {
        }
    }

    private static class ClickAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }

        ClickAction() {
        }
    }

    public static class EmptyIcon
    implements Icon {
        int width;
        int height;

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public EmptyIcon(int width, int height) {
            this.height = height;
            this.width = width;
        }
    }
}

