/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import bsh.EvalError;
import bsh.Interpreter;
import free.jin.scripter.Script;
import free.jin.ui.DialogPanel;
import free.jin.ui.OptionPanel;
import free.util.PlatformUtils;
import free.workarounds.FixedJComboBox;
import free.workarounds.FixedJTable;
import free.workarounds.FixedTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class UserInvokedScriptMenuItem
extends JMenuItem
implements ActionListener {
    private final Script script;

    public UserInvokedScriptMenuItem(Script script) {
        super(script.getName());
        this.script = script;
        this.setMnemonic(script.getName().charAt(0));
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        VariablesPanel variablesPanel = new VariablesPanel();
        Object[][] objectArray = variablesPanel.askVars();
        if (objectArray == null) {
            return;
        }
        this.script.run(null, null, objectArray);
    }

    public Script getScript() {
        return this.script;
    }

    private class VariablesPanel
    extends DialogPanel {
        private final String[] varTypes = new String[]{"String", "Integer", "Boolean", "Real"};
        private final DefaultTableModel tableModel;
        private final DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        private JButton runScriptButton;

        public VariablesPanel() {
            FixedJComboBox fixedJComboBox = new FixedJComboBox((Object[])this.varTypes);
            fixedJComboBox.setEditable(false);
            FixedTableColumn fixedTableColumn = new FixedTableColumn(0, 100, (TableCellRenderer)new DefaultTableCellRenderer(), (TableCellEditor)new DefaultCellEditor((JComboBox<?>)fixedJComboBox));
            FixedTableColumn fixedTableColumn2 = new FixedTableColumn(1, 100);
            FixedTableColumn fixedTableColumn3 = new FixedTableColumn(2, 150);
            fixedTableColumn.setHeaderValue("Type");
            fixedTableColumn2.setHeaderValue("Name");
            fixedTableColumn3.setHeaderValue("Value");
            this.columnModel.addColumn((TableColumn)fixedTableColumn);
            this.columnModel.addColumn((TableColumn)fixedTableColumn2);
            this.columnModel.addColumn((TableColumn)fixedTableColumn3);
            this.tableModel = new DefaultTableModel(1, 3);
            this.tableModel.setValueAt(this.varTypes[0], 0, 0);
            this.createUI();
        }

        public String getTitle() {
            return "Specify Variables for the Script";
        }

        public Object[][] askVars() {
            return (Object[][])super.askResult();
        }

        private void createUI() {
            FixedJTable fixedJTable = new FixedJTable((TableModel)this.tableModel, (TableColumnModel)this.columnModel);
            fixedJTable.setCellSelectionEnabled(false);
            fixedJTable.setColumnSelectionAllowed(false);
            fixedJTable.setRowSelectionAllowed(true);
            fixedJTable.setRowHeight(20);
            fixedJTable.getTableHeader().setPreferredSize(new Dimension(350, 18));
            fixedJTable.getTableHeader().setReorderingAllowed(false);
            JScrollPane jScrollPane = new JScrollPane((Component)fixedJTable);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(350, 120));
            JLabel jLabel = new JLabel("Variables");
            jLabel.setDisplayedMnemonic('V');
            jLabel.setLabelFor((Component)fixedJTable);
            JButton jButton = new JButton("Add Variable");
            JButton jButton2 = new JButton("Remove Variable");
            jButton.setMnemonic('A');
            jButton2.setMnemonic('R');
            jButton.setDefaultCapable(false);
            jButton2.setDefaultCapable(false);
            jButton2.setEnabled(false);
            this.runScriptButton = new JButton("Run Script");
            JButton jButton3 = new JButton("Cancel");
            ListSelectionModel listSelectionModel = fixedJTable.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(new ListSelectionListener((JTable)fixedJTable, jButton2){
                private final /* synthetic */ JTable val$table;
                private final /* synthetic */ JButton val$remove;
                {
                    this.val$table = jTable;
                    this.val$remove = jButton;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    int n = this.val$table.getSelectedRow();
                    if (n == -1) {
                        this.val$remove.setEnabled(false);
                    } else {
                        this.val$remove.setEnabled(true);
                    }
                }
            });
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VariablesPanel.this.tableModel.addRow(new Object[]{VariablesPanel.this.varTypes[0], null, null});
                }
            });
            jButton2.addActionListener(new ActionListener((JTable)fixedJTable, jButton2){
                private final /* synthetic */ JTable val$table;
                private final /* synthetic */ JButton val$remove;
                {
                    this.val$table = jTable;
                    this.val$remove = jButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$table.getSelectedRow();
                    if (n == -1) {
                        throw new IllegalStateException("Remove clicked while no row is selected");
                    }
                    VariablesPanel.this.tableModel.removeRow(n);
                    if (VariablesPanel.this.tableModel.getRowCount() <= n) {
                        if (VariablesPanel.this.tableModel.getRowCount() == 0) {
                            this.val$remove.setEnabled(false);
                        }
                        this.val$table.setRowSelectionInterval(n - 1, n - 1);
                    } else {
                        this.val$table.setRowSelectionInterval(n, n);
                    }
                }
            });
            this.runScriptButton.addActionListener(new ActionListener((JTable)fixedJTable){
                private final /* synthetic */ JTable val$table;
                {
                    this.val$table = jTable;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$table.isEditing()) {
                        TableCellEditor tableCellEditor = this.val$table.getCellEditor();
                        tableCellEditor.stopCellEditing();
                    }
                    int n = VariablesPanel.this.tableModel.getRowCount();
                    Vector<Object[]> vector = new Vector<Object[]>(n);
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        String string;
                        block8: {
                            String string2 = (String)VariablesPanel.this.tableModel.getValueAt(i, 0);
                            string = (String)VariablesPanel.this.tableModel.getValueAt(i, 1);
                            String string3 = (String)VariablesPanel.this.tableModel.getValueAt(i, 2);
                            if (string == null || string.length() == 0) continue;
                            try {
                                if ("Integer".equals(string2)) {
                                    object = new Integer(string3);
                                    break block8;
                                }
                                if ("String".equals(string2)) {
                                    object = string3;
                                    break block8;
                                }
                                if ("Boolean".equals(string2)) {
                                    object = Boolean.valueOf(string3);
                                    break block8;
                                }
                                if ("Real".equals(string2)) {
                                    object = new Double(string3);
                                    break block8;
                                }
                                throw new IllegalStateException("Unknown variable type: " + string2);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                OptionPanel.error((String)"Bad Variable Value", (String)("Inappropriate value specified for variable \"" + string + "\", must be of type \"" + string2 + "\""));
                                return;
                            }
                        }
                        vector.addElement(new Object[]{string, object});
                    }
                    Object[][] objectArrayArray = new Object[vector.size()][];
                    vector.copyInto((Object[])objectArrayArray);
                    VariablesPanel.this.close(objectArrayArray);
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VariablesPanel.this.close(null);
                }
            });
            JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalGlue());
            box.add(jPanel);
            box.add(Box.createVerticalGlue());
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            jPanel2.add(this.runScriptButton);
            jPanel2.add(jButton3);
            this.setLayout(new BorderLayout(10, 5));
            this.setBorder(new EmptyBorder(10, 10, 5, 10));
            this.add(jLabel, "North");
            this.add(jScrollPane, "Center");
            this.add(box, "East");
            this.add(jPanel2, "South");
            this.setDefaultButton(this.runScriptButton);
            if (PlatformUtils.isJavaBetterThan((String)"1.3")) {
                AbstractAction abstractAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VariablesPanel.this.runScriptButton.doClick();
                    }
                };
                AbstractAction abstractAction2 = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VariablesPanel.this.close(null);
                    }
                };
                try {
                    Interpreter interpreter = new Interpreter();
                    interpreter.set("table", (Object)fixedJTable);
                    interpreter.set("defaultButtonAction", (Object)abstractAction);
                    interpreter.set("closeDialogAction", (Object)abstractAction2);
                    interpreter.eval("ActionMap actionMap = table.getActionMap();");
                    interpreter.eval("InputMap inputMap = table.getInputMap();");
                    interpreter.eval("actionMap.put(\"defaultButtonAction\", defaultButtonAction);");
                    interpreter.eval("inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), \"defaultButtonAction\");");
                    interpreter.eval("actionMap.put(\"closeDialogAction\", closeDialogAction);");
                    interpreter.eval("inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), \"closeDialogAction\");");
                }
                catch (EvalError evalError) {
                    evalError.printStackTrace();
                }
            } else {
                fixedJTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
                fixedJTable.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            }
        }
    }
}

