/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ParamsContentParser
extends ContentParser {
    private static final Logger LOG = Log.getLogger(ParamsContentParser.class);
    private final ServerParser.Listener listener;
    private State state = State.LENGTH;
    private int cursor;
    private int length;
    private int nameLength;
    private int valueLength;
    private byte[] nameBytes;
    private byte[] valueBytes;

    public ParamsContentParser(HeaderParser headerParser, ServerParser.Listener listener) {
        super(headerParser);
        this.listener = listener;
    }

    @Override
    public ContentParser.Result parse(ByteBuffer buffer) {
        block12: while (buffer.hasRemaining() || this.state == State.PARAM) {
            switch (this.state) {
                case LENGTH: {
                    this.length = this.getContentLength();
                    this.state = State.NAME_LENGTH;
                    continue block12;
                }
                case NAME_LENGTH: {
                    if (this.isLargeLength(buffer)) {
                        if (buffer.remaining() >= 4) {
                            this.nameLength = buffer.getInt() & Short.MAX_VALUE;
                            this.state = State.VALUE_LENGTH;
                            this.length -= 4;
                            continue block12;
                        }
                        this.state = State.NAME_LENGTH_BYTES;
                        this.cursor = 0;
                        continue block12;
                    }
                    this.nameLength = buffer.get() & 0xFF;
                    this.state = State.VALUE_LENGTH;
                    --this.length;
                    continue block12;
                }
                case NAME_LENGTH_BYTES: {
                    int quarterInt = buffer.get() & 0xFF;
                    this.nameLength = (this.nameLength << 8) + quarterInt;
                    --this.length;
                    if (++this.cursor != 4) continue block12;
                    this.nameLength &= Short.MAX_VALUE;
                    this.state = State.VALUE_LENGTH;
                    continue block12;
                }
                case VALUE_LENGTH: {
                    if (this.isLargeLength(buffer)) {
                        if (buffer.remaining() >= 4) {
                            this.valueLength = buffer.getInt() & Short.MAX_VALUE;
                            this.state = State.NAME;
                            this.length -= 4;
                            continue block12;
                        }
                        this.state = State.VALUE_LENGTH_BYTES;
                        this.cursor = 0;
                        continue block12;
                    }
                    this.valueLength = buffer.get() & 0xFF;
                    this.state = State.NAME;
                    --this.length;
                    continue block12;
                }
                case VALUE_LENGTH_BYTES: {
                    int quarterInt = buffer.get() & 0xFF;
                    this.valueLength = (this.valueLength << 8) + quarterInt;
                    --this.length;
                    if (++this.cursor != 4) continue block12;
                    this.valueLength &= Short.MAX_VALUE;
                    this.state = State.NAME;
                    continue block12;
                }
                case NAME: {
                    this.nameBytes = new byte[this.nameLength];
                    if (buffer.remaining() >= this.nameLength) {
                        buffer.get(this.nameBytes);
                        this.state = State.VALUE;
                        this.length -= this.nameLength;
                        continue block12;
                    }
                    this.state = State.NAME_BYTES;
                    this.cursor = 0;
                    continue block12;
                }
                case NAME_BYTES: {
                    this.nameBytes[this.cursor] = buffer.get();
                    --this.length;
                    if (++this.cursor != this.nameLength) continue block12;
                    this.state = State.VALUE;
                    continue block12;
                }
                case VALUE: {
                    this.valueBytes = new byte[this.valueLength];
                    if (buffer.remaining() >= this.valueLength) {
                        buffer.get(this.valueBytes);
                        this.state = State.PARAM;
                        this.length -= this.valueLength;
                        continue block12;
                    }
                    this.state = State.VALUE_BYTES;
                    this.cursor = 0;
                    continue block12;
                }
                case VALUE_BYTES: {
                    this.valueBytes[this.cursor] = buffer.get();
                    --this.length;
                    if (++this.cursor != this.valueLength) continue block12;
                    this.state = State.PARAM;
                    continue block12;
                }
                case PARAM: {
                    Charset utf8 = Charset.forName("UTF-8");
                    this.onParam(new String(this.nameBytes, utf8), new String(this.valueBytes, utf8));
                    this.partialReset();
                    if (this.length != 0) continue block12;
                    this.reset();
                    return ContentParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return ContentParser.Result.PENDING;
    }

    @Override
    public void noContent() {
        this.onParams();
    }

    protected void onParam(String name, String value) {
        block2: {
            try {
                this.listener.onHeader(this.getRequest(), new HttpField(name, value));
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception while invoking listener " + this.listener, x);
            }
        }
    }

    protected void onParams() {
        block2: {
            try {
                this.listener.onHeaders(this.getRequest());
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception while invoking listener " + this.listener, x);
            }
        }
    }

    private boolean isLargeLength(ByteBuffer buffer) {
        return (buffer.get(buffer.position()) & 0x80) == 128;
    }

    private void partialReset() {
        this.state = State.NAME_LENGTH;
        this.cursor = 0;
        this.nameLength = 0;
        this.valueLength = 0;
        this.nameBytes = null;
        this.valueBytes = null;
    }

    private void reset() {
        this.partialReset();
        this.state = State.LENGTH;
        this.length = 0;
    }

    private static enum State {
        LENGTH,
        NAME_LENGTH,
        NAME_LENGTH_BYTES,
        VALUE_LENGTH,
        VALUE_LENGTH_BYTES,
        NAME,
        NAME_BYTES,
        VALUE,
        VALUE_BYTES,
        PARAM;

    }
}

