/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.gui.SimpleDialogs;

public final class GameInfoDialog
extends JOptionPane {
    private static final long serialVersionUID = 0L;
    private final JPanel m_panelLeft;
    private final JPanel m_panelRight;
    private JTextField m_byoyomi;
    private JTextField m_byoyomiMoves;
    private JTextField m_date;
    private JTextField m_komi;
    private JTextField m_playerBlack;
    private JTextField m_playerWhite;
    private JTextField m_preByoyomi;
    private final JTextField m_rankBlack;
    private final JTextField m_rankWhite;
    private JTextField m_result;
    private JTextField m_rules;

    public static boolean show(Component component, GameInformation gameInformation) {
        double d;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        GameInfoDialog gameInfoDialog = new GameInfoDialog(gameInformation);
        JDialog jDialog = gameInfoDialog.createDialog(component, "Game Info");
        boolean bl = false;
        while (!bl) {
            jDialog.setVisible(true);
            Object object = gameInfoDialog.getValue();
            if (!(object instanceof Integer) || (Integer)object != 0) {
                return false;
            }
            bl = gameInfoDialog.validate(component);
        }
        jDialog.dispose();
        boolean bl2 = false;
        String string7 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_playerBlack);
        if (!string7.equals(gameInformation.m_playerBlack)) {
            gameInformation.m_playerBlack = string7;
            bl2 = true;
        }
        if (!(string6 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_playerWhite)).equals(gameInformation.m_playerWhite)) {
            gameInformation.m_playerWhite = string6;
            bl2 = true;
        }
        if (!(string5 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_rankBlack)).equals(gameInformation.m_blackRank)) {
            gameInformation.m_blackRank = string5;
            bl2 = true;
        }
        if (!(string4 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_rankWhite)).equals(gameInformation.m_whiteRank)) {
            gameInformation.m_whiteRank = string4;
            bl2 = true;
        }
        if (!(string3 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_rules)).equals(gameInformation.m_rules)) {
            gameInformation.m_rules = string3;
            bl2 = true;
        }
        if (!(string2 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_result)).equals(gameInformation.m_result)) {
            gameInformation.m_result = string2;
            bl2 = true;
        }
        if (!(string = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_date)).equals(gameInformation.m_date)) {
            gameInformation.m_date = string;
            bl2 = true;
        }
        if ((d = Double.parseDouble(GameInfoDialog.getTextFieldContent(gameInfoDialog.m_komi))) != gameInformation.m_komi) {
            gameInformation.m_komi = d;
            bl2 = true;
        }
        String string8 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_preByoyomi);
        String string9 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_byoyomi);
        String string10 = GameInfoDialog.getTextFieldContent(gameInfoDialog.m_byoyomiMoves);
        if (string8.equals("")) {
            if (gameInformation.m_timeSettings != null) {
                gameInformation.m_timeSettings = null;
                bl2 = true;
            }
        } else {
            long l = (long)Integer.parseInt(string8) * 60000L;
            long l2 = -1L;
            int n = -1;
            if (!string9.equals("")) {
                l2 = (long)Integer.parseInt(string9) * 60000L;
            }
            if (!string10.equals("")) {
                n = Integer.parseInt(string10);
            }
            TimeSettings timeSettings = gameInformation.m_timeSettings;
            if (l2 > 0L && n > 0) {
                if (timeSettings == null || l != timeSettings.getPreByoyomi() || l2 != timeSettings.getByoyomi() || n != timeSettings.getByoyomiMoves()) {
                    gameInformation.m_timeSettings = new TimeSettings(l, l2, n);
                    bl2 = true;
                }
            } else if (timeSettings == null || l != timeSettings.getPreByoyomi()) {
                gameInformation.m_timeSettings = new TimeSettings(l);
                bl2 = true;
            }
        }
        return bl2;
    }

    private GameInfoDialog(GameInformation gameInformation) {
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        this.m_panelLeft = new JPanel(new GridLayout(0, 1, 0, 2));
        jPanel.add((Component)this.m_panelLeft, "West");
        this.m_panelRight = new JPanel(new GridLayout(0, 1, 0, 2));
        jPanel.add((Component)this.m_panelRight, "Center");
        this.m_playerBlack = this.createEntry("Black player:", gameInformation.m_playerBlack);
        this.m_rankBlack = this.createEntry("Black rank:", gameInformation.m_blackRank);
        this.m_playerWhite = this.createEntry("White player:", gameInformation.m_playerWhite);
        this.m_rankWhite = this.createEntry("White rank:", gameInformation.m_whiteRank);
        this.m_date = this.createEntry("Date:", gameInformation.m_date);
        this.m_rules = this.createEntry("Rules:", gameInformation.m_rules);
        this.m_komi = this.createEntry("Komi:", gameInformation.roundKomi());
        this.m_result = this.createEntry("Result:", gameInformation.m_result);
        this.createTimeEntry(gameInformation.m_timeSettings);
        this.setMessage(jPanel);
        this.setOptionType(2);
    }

    private JTextField createEntry(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        this.m_panelLeft.add(jLabel);
        JTextField jTextField = new JTextField(string2);
        this.m_panelRight.add(jTextField);
        return jTextField;
    }

    private void createTimeEntry(TimeSettings timeSettings) {
        int n;
        JLabel jLabel = new JLabel("Time:");
        jLabel.setHorizontalAlignment(2);
        this.m_panelLeft.add(jLabel);
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        JPanel jPanel = new JPanel(flowLayout);
        this.m_preByoyomi = new JTextField(2);
        this.m_preByoyomi.setHorizontalAlignment(4);
        if (timeSettings != null) {
            n = (int)(timeSettings.getPreByoyomi() / 60000L);
            this.m_preByoyomi.setText(Integer.toString(n));
        }
        jPanel.add(this.m_preByoyomi);
        jPanel.add(new JLabel(" min + "));
        this.m_byoyomi = new JTextField(2);
        this.m_byoyomi.setHorizontalAlignment(4);
        if (timeSettings != null && timeSettings.getUseByoyomi()) {
            n = (int)(timeSettings.getByoyomi() / 60000L);
            this.m_byoyomi.setText(Integer.toString(n));
        }
        jPanel.add(this.m_byoyomi);
        jPanel.add(new JLabel(" min / "));
        this.m_byoyomiMoves = new JTextField(2);
        this.m_byoyomiMoves.setHorizontalAlignment(4);
        if (timeSettings != null && timeSettings.getUseByoyomi()) {
            n = timeSettings.getByoyomiMoves();
            this.m_byoyomiMoves.setText(Integer.toString(n));
        }
        jPanel.add(this.m_byoyomiMoves);
        jPanel.add(new JLabel(" moves"));
        this.m_panelRight.add(jPanel);
    }

    private static String getTextFieldContent(JTextField jTextField) {
        return jTextField.getText().trim();
    }

    private boolean validate(Component component) {
        if (!this.validateDouble(component, this.m_komi, "Invalid komi")) {
            return false;
        }
        if (!this.validatePosIntOrEmpty(component, this.m_preByoyomi, "Invalid time settings")) {
            return false;
        }
        if (!this.validatePosIntOrEmpty(component, this.m_byoyomi, "Invalid time settings")) {
            return false;
        }
        return this.validatePosIntOrEmpty(component, this.m_byoyomiMoves, "Invalid time settings");
    }

    private boolean validateDouble(Component component, JTextField jTextField, String string) {
        try {
            Double.parseDouble(GameInfoDialog.getTextFieldContent(jTextField));
        }
        catch (NumberFormatException numberFormatException) {
            SimpleDialogs.showError(component, string);
            return false;
        }
        return true;
    }

    private boolean validatePosIntOrEmpty(Component component, JTextField jTextField, String string) {
        try {
            String string2 = GameInfoDialog.getTextFieldContent(jTextField);
            if (string2.equals("")) {
                return true;
            }
            int n = Integer.parseInt(string2);
            if (n <= 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            SimpleDialogs.showError(component, string);
            return false;
        }
        return true;
    }
}

