/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.sax.ForkContentHandler;
import com.thaiopensource.xml.sax.ForkDTDHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;

public class CombineValidator
implements Validator {
    private final Validator v1;
    private final Validator v2;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;

    public CombineValidator(Validator v1, Validator v2) {
        this.v1 = v1;
        this.v2 = v2;
        this.createHandlers();
    }

    public void reset() {
        this.v1.reset();
        this.v2.reset();
        this.createHandlers();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    private void createHandlers() {
        this.contentHandler = new ForkContentHandler(this.v1.getContentHandler(), this.v2.getContentHandler());
        DTDHandler d1 = this.v1.getDTDHandler();
        DTDHandler d2 = this.v2.getDTDHandler();
        this.dtdHandler = d1 != null && d2 != null ? new ForkDTDHandler(d1, d2) : (d1 != null ? d1 : (d2 != null ? d2 : null));
    }
}

