/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivFunction;
import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SingleDataDerivType;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import org.relaxng.datatype.ValidationContext;

class BlankDataDerivType
extends DataDerivType {
    private PatternMemo blankMemo;
    private PatternMemo nonBlankMemo;

    BlankDataDerivType() {
    }

    PatternMemo dataDeriv(ValidatorPatternBuilder builder, Pattern p, String str, ValidationContext vc) {
        if (DataDerivFunction.isBlank(str)) {
            if (this.blankMemo == null) {
                this.blankMemo = super.dataDeriv(builder, p, str, vc);
            }
            return this.blankMemo;
        }
        if (this.nonBlankMemo == null) {
            this.nonBlankMemo = super.dataDeriv(builder, p, str, vc);
        }
        return this.nonBlankMemo;
    }

    DataDerivType copy() {
        return new BlankDataDerivType();
    }

    DataDerivType combine(DataDerivType ddt) {
        if (ddt instanceof BlankDataDerivType || ddt instanceof SingleDataDerivType) {
            return this;
        }
        return InconsistentDataDerivType.getInstance();
    }
}

