/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import java.util.Date;
import java.util.GregorianCalendar;
import org.relaxng.datatype.ValidationContext;

class DateTimeDatatype
extends RegexDatatype
implements OrderRelation {
    private static final String YEAR_PATTERN = "-?([1-9][0-9]*)?[0-9]{4}";
    private static final String MONTH_PATTERN = "[0-9]{2}";
    private static final String DAY_OF_MONTH_PATTERN = "[0-9]{2}";
    private static final String TIME_PATTERN = "[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]*)?";
    private static final String TZ_PATTERN = "(Z|[+\\-][0-9][0-9]:[0-5][0-9])?";
    private final String template;
    private static final int TIME_ZONE_MAX = 50400000;

    DateTimeDatatype(String template) {
        super(DateTimeDatatype.makePattern(template));
        this.template = template;
    }

    private static String makePattern(String template) {
        StringBuffer pattern = new StringBuffer();
        int len = template.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = template.charAt(i);
            switch (c) {
                case 'Y': {
                    pattern.append(YEAR_PATTERN);
                    continue block6;
                }
                case 'M': {
                    pattern.append("[0-9]{2}");
                    continue block6;
                }
                case 'D': {
                    pattern.append("[0-9]{2}");
                    continue block6;
                }
                case 't': {
                    pattern.append(TIME_PATTERN);
                    continue block6;
                }
                default: {
                    pattern.append(c);
                }
            }
        }
        pattern.append(TZ_PATTERN);
        return pattern.toString();
    }

    boolean allowsValue(String str, ValidationContext vc) {
        return this.getValue(str, vc) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getValue(String str, ValidationContext vc) {
        int leapMilliseconds;
        boolean negative = false;
        int year = 2000;
        int month = 1;
        int day = 1;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        int pos = 0;
        int len = str.length();
        int templateLength = this.template.length();
        block13: for (int templateIndex = 0; templateIndex < templateLength; ++templateIndex) {
            char templateChar = this.template.charAt(templateIndex);
            switch (templateChar) {
                case 'Y': {
                    negative = str.charAt(pos) == '-';
                    int yearStartIndex = negative ? pos + 1 : pos;
                    pos = DateTimeDatatype.skipDigits(str, yearStartIndex);
                    try {
                        year = Integer.parseInt(str.substring(yearStartIndex, pos));
                        continue block13;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                case 'M': {
                    month = DateTimeDatatype.parse2Digits(str, pos);
                    pos += 2;
                    continue block13;
                }
                case 'D': {
                    day = DateTimeDatatype.parse2Digits(str, pos);
                    pos += 2;
                    continue block13;
                }
                case 't': {
                    hours = DateTimeDatatype.parse2Digits(str, pos);
                    minutes = DateTimeDatatype.parse2Digits(str, pos += 3);
                    seconds = DateTimeDatatype.parse2Digits(str, pos += 3);
                    if ((pos += 2) >= len || str.charAt(pos) != '.') continue block13;
                    int end = DateTimeDatatype.skipDigits(str, ++pos);
                    for (int j = 0; j < 3; ++j) {
                        milliseconds *= 10;
                        if (pos >= end) continue;
                        milliseconds += str.charAt(pos++) - 48;
                    }
                    pos = end;
                    continue block13;
                }
                default: {
                    ++pos;
                }
            }
        }
        boolean hasTimeZone = pos < len;
        int tzOffset = hasTimeZone && str.charAt(pos) != 'Z' ? DateTimeDatatype.parseTimeZone(str, pos) : 0;
        if (seconds == 60) {
            leapMilliseconds = milliseconds + 1;
            milliseconds = 999;
            seconds = 59;
        } else {
            leapMilliseconds = 0;
        }
        try {
            Date date;
            GregorianCalendar cal = CalendarFactory.getCalendar();
            if (cal == CalendarFactory.cal) {
                GregorianCalendar gregorianCalendar = cal;
                synchronized (gregorianCalendar) {
                    date = DateTimeDatatype.createDate(cal, tzOffset, negative, year, month, day, hours, minutes, seconds, milliseconds);
                }
            } else {
                date = DateTimeDatatype.createDate(cal, tzOffset, negative, year, month, day, hours, minutes, seconds, milliseconds);
            }
            return new DateTime(date, leapMilliseconds, hasTimeZone);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Date createDate(GregorianCalendar cal, int tzOffset, boolean negative, int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) {
        cal.setLenient(false);
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.clear();
        cal.set(15, tzOffset);
        cal.set(16, 0);
        cal.set(0, negative ? 0 : 1);
        cal.set(year, --month, day, hours, minutes, seconds);
        cal.set(14, milliseconds);
        DateTimeDatatype.checkDate(cal.isLeapYear(year), month, day);
        return cal.getTime();
    }

    private static void checkDate(boolean isLeapYear, int month, int day) {
        int dayMax;
        if (month < 0 || month > 11 || day < 1) {
            throw new IllegalArgumentException();
        }
        switch (month) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                dayMax = 30;
                break;
            }
            case 1: {
                dayMax = isLeapYear ? 29 : 28;
                break;
            }
            default: {
                dayMax = 31;
            }
        }
        if (day > dayMax) {
            throw new IllegalArgumentException();
        }
    }

    private static int parseTimeZone(String str, int i) {
        int sign = str.charAt(i) == '-' ? -1 : 1;
        return (Integer.parseInt(str.substring(i + 1, i + 3)) * 60 + Integer.parseInt(str.substring(i + 4))) * 60 * 1000 * sign;
    }

    private static int parse2Digits(String str, int i) {
        return (str.charAt(i) - 48) * 10 + (str.charAt(i + 1) - 48);
    }

    private static int skipDigits(String str, int i) {
        int len = str.length();
        while (i < len && "0123456789".indexOf(str.charAt(i)) >= 0) {
            ++i;
        }
        return i;
    }

    OrderRelation getOrderRelation() {
        return this;
    }

    public boolean isLessThan(Object obj1, Object obj2) {
        DateTime dt1 = (DateTime)obj1;
        DateTime dt2 = (DateTime)obj2;
        long t1 = dt1.getDate().getTime();
        long t2 = dt2.getDate().getTime();
        if (dt1.getHasTimeZone() == dt2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(t1, dt1.getLeapMilliseconds(), t2, dt2.getLeapMilliseconds());
        }
        if (!dt2.getHasTimeZone()) {
            return DateTimeDatatype.isLessThan(t1, dt1.getLeapMilliseconds(), t2 - 50400000L, dt2.getLeapMilliseconds());
        }
        return DateTimeDatatype.isLessThan(t1 + 50400000L, dt1.getLeapMilliseconds(), t2, dt2.getLeapMilliseconds());
    }

    private static boolean isLessThan(long t1, int leapMillis1, long t2, int leapMillis2) {
        if (t1 < t2) {
            return true;
        }
        if (t1 > t2) {
            return false;
        }
        return leapMillis1 < leapMillis2;
    }

    static class CalendarFactory {
        private static final int UNKNOWN = -1;
        private static final int SLOW = 0;
        private static final int FAST = 1;
        private static final int LIMIT = 10;
        private static int speed = -1;
        static GregorianCalendar cal = new GregorianCalendar();

        CalendarFactory() {
        }

        static GregorianCalendar getCalendar() {
            switch (speed) {
                case 0: {
                    return cal;
                }
                case 1: {
                    return new GregorianCalendar();
                }
            }
            long start = System.currentTimeMillis();
            GregorianCalendar tem = new GregorianCalendar();
            long time = System.currentTimeMillis() - start;
            speed = time > 10L ? 0 : 1;
            return tem;
        }
    }

    private static class DateTime {
        private final Date date;
        private final int leapMilliseconds;
        private final boolean hasTimeZone;

        DateTime(Date date, int leapMilliseconds, boolean hasTimeZone) {
            this.date = date;
            this.leapMilliseconds = leapMilliseconds;
            this.hasTimeZone = hasTimeZone;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DateTime)) {
                return false;
            }
            DateTime other = (DateTime)obj;
            return this.date.equals(other.date) && this.leapMilliseconds == other.leapMilliseconds && this.hasTimeZone == other.hasTimeZone;
        }

        public int hashCode() {
            return this.date.hashCode();
        }

        Date getDate() {
            return this.date;
        }

        int getLeapMilliseconds() {
            return this.leapMilliseconds;
        }

        boolean getHasTimeZone() {
            return this.hasTimeZone;
        }
    }
}

