/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class McWinTitlePane
extends BaseTitlePane {
    public McWinTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void paintBorder(Graphics g) {
        if (this.isActive()) {
            g.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
        } else {
            g.setColor(AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor());
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g, int x, int y, String title) {
        x += this.paintIcon(g, x, y);
        if (this.isActive()) {
            ColorUIResource fc = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(fc) > 128) {
                g.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowTitleColorDark(), 40.0));
            } else {
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            }
            JTattooUtilities.drawString(this.rootPane, g, title, x, y + 1);
            g.setColor(fc);
            JTattooUtilities.drawString(this.rootPane, g, title, x, y);
        } else {
            ColorUIResource fc = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
            if (ColorHelper.getGrayValue(fc) > 128) {
                g.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveTitleColorDark(), 40.0));
            } else {
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            }
            JTattooUtilities.drawString(this.rootPane, g, title, x, y + 1);
            g.setColor(fc);
            JTattooUtilities.drawString(this.rootPane, g, title, x, y);
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        protected int computeHeight() {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(McWinTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c);
            } else {
                this.layoutDefault(c);
            }
        }

        public void layoutDefault(Container c) {
            int buttonHeight;
            boolean leftToRight = McWinTitlePane.this.isLeftToRight();
            int w = McWinTitlePane.this.getWidth();
            int h = McWinTitlePane.this.getHeight();
            int spacing = McWinTitlePane.this.getHorSpacing();
            int buttonWidth = buttonHeight = h - McWinTitlePane.this.getVerSpacing() - 1;
            if (McWinTitlePane.this.menuBar != null) {
                int mw = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    McWinTitlePane.this.menuBar.setBounds(2, (h - mh) / 2, mw, mh);
                } else {
                    McWinTitlePane.this.menuBar.setBounds(McWinTitlePane.this.getWidth() - mw, (h - mh) / 2, mw, mh);
                }
            }
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h - buttonHeight) / 2 - 1);
            if (McWinTitlePane.this.closeButton != null) {
                McWinTitlePane.this.closeButton.setBounds(x += leftToRight ? -buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (McWinTitlePane.this.maxButton != null && McWinTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                McWinTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (McWinTitlePane.this.iconifyButton != null && McWinTitlePane.this.iconifyButton.getParent() != null) {
                McWinTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            McWinTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (McWinTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - McWinTitlePane.this.buttonsWidth - spacing - 20;
                if (McWinTitlePane.this.menuBar != null) {
                    maxWidth -= ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().width;
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((McWinTitlePane)McWinTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h;
                int cpx = leftToRight ? w - McWinTitlePane.this.buttonsWidth - cpw : McWinTitlePane.this.buttonsWidth;
                int cpy = 0;
                McWinTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinTitlePane.this.buttonsWidth += ((McWinTitlePane)McWinTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c) {
            int btnHeight;
            int spacing = McWinTitlePane.this.getHorSpacing();
            int h = McWinTitlePane.this.getHeight();
            int btnWidth = btnHeight = h - McWinTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (McWinTitlePane.this.closeButton != null) {
                McWinTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (McWinTitlePane.this.iconifyButton != null && McWinTitlePane.this.iconifyButton.getParent() != null) {
                McWinTitlePane.this.iconifyButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (McWinTitlePane.this.maxButton != null && McWinTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                McWinTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            McWinTitlePane.this.buttonsWidth = x;
            if (McWinTitlePane.this.customTitlePanel != null) {
                int cpx = McWinTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((McWinTitlePane)McWinTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h;
                McWinTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                McWinTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

