/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.AbstractIntelliHints;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.Sticky;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public abstract class AbstractListIntelliHints
extends AbstractIntelliHints {
    private JList _list;
    protected KeyStroke[] _keyStrokes;
    private JideScrollPane _scroll;

    public AbstractListIntelliHints(JTextComponent textComponent) {
        super(textComponent);
    }

    @Override
    public JComponent createHintsComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this._list = this.createList();
        new Sticky(this._list);
        this._scroll = new JideScrollPane(this.getList());
        this.getList().setFocusable(false);
        this._scroll.setHorizontalScrollBarPolicy(31);
        this._scroll.setBorder(BorderFactory.createEmptyBorder());
        this._scroll.getVerticalScrollBar().setFocusable(false);
        this._scroll.getHorizontalScrollBar().setFocusable(false);
        panel.add((Component)this._scroll, "Center");
        return panel;
    }

    protected JList createList() {
        return new JList(){

            @Override
            public int getVisibleRowCount() {
                int size = this.getModel().getSize();
                return size < super.getVisibleRowCount() ? size : super.getVisibleRowCount();
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                if (this.getModel().getSize() == 0) {
                    return new Dimension(0, 0);
                }
                return super.getPreferredScrollableViewportSize();
            }
        };
    }

    protected JList getList() {
        return this._list;
    }

    protected void setListData(Object[] objects) {
        this.resetSelection();
        this.getList().setListData(objects);
        if (this._scroll != null) {
            this._scroll.setViewportView(this.getList());
        }
    }

    protected void setListData(Vector<?> objects) {
        this.resetSelection();
        this.getList().setListData(objects);
        if (this._scroll != null) {
            this._scroll.setViewportView(this.getList());
        }
    }

    private void resetSelection() {
        this.getList().getSelectionModel().setAnchorSelectionIndex(-1);
        this.getList().getSelectionModel().setLeadSelectionIndex(-1);
        this.getList().getSelectionModel().clearSelection();
    }

    @Override
    public Object getSelectedHint() {
        return this.getList().getSelectedValue();
    }

    @Override
    public JComponent getDelegateComponent() {
        return this.getList();
    }

    @Override
    public KeyStroke[] getDelegateKeyStrokes() {
        if (this._keyStrokes == null) {
            this._keyStrokes = new KeyStroke[6];
            this._keyStrokes[0] = KeyStroke.getKeyStroke(40, 0);
            this._keyStrokes[1] = KeyStroke.getKeyStroke(38, 0);
            this._keyStrokes[2] = KeyStroke.getKeyStroke(34, 0);
            this._keyStrokes[3] = KeyStroke.getKeyStroke(33, 0);
            this._keyStrokes[4] = KeyStroke.getKeyStroke(36, 0);
            this._keyStrokes[5] = KeyStroke.getKeyStroke(35, 0);
        }
        return this._keyStrokes;
    }
}

