/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class HttpResponseHeader
extends HttpHeader {
    public static final String HTTP_CLIENT_BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String _CONTENT_TYPE_IMAGE = "image";
    private static final String _CONTENT_TYPE_TEXT = "text";
    private static final String _CONTENT_TYPE_HTML = "html";
    static final Pattern patternStatusLine = Pattern.compile("(HTTP/\\d+\\.\\d+) +(\\d{3}) *([^\\x00-\\x1f\\r\\n]*)", 2);
    private static final Pattern patternPartialStatusLine = Pattern.compile("\\A *(HTTP/\\d+\\.\\d+)", 2);
    private String mStatusCodeString = "";
    private int mStatusCode = 0;
    private String mReasonPhrase = "";

    public HttpResponseHeader() {
        this.clear();
    }

    public HttpResponseHeader(String string) throws HttpMalformedHeaderException {
        this();
        this.setMessage(string);
    }

    public void clear() {
        super.clear();
        this.mStatusCodeString = "";
        this.mStatusCode = 0;
        this.mReasonPhrase = "";
    }

    public void setMessage(String string) throws HttpMalformedHeaderException {
        super.setMessage(string);
        try {
            if (!this.parse()) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception exception) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public void setVersion(String string) {
        this.mVersion = string.toUpperCase();
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    public boolean parse() throws Exception {
        Matcher matcher = patternStatusLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            return false;
        }
        this.mVersion = matcher.group(1);
        this.mStatusCodeString = matcher.group(2);
        String string = matcher.group(3);
        if (string != null) {
            this.mReasonPhrase = string;
        }
        if (!this.mVersion.equalsIgnoreCase("HTTP/1.0") && !this.mVersion.equalsIgnoreCase("HTTP/1.1")) {
            this.mMalformedHeader = true;
            return false;
        }
        try {
            this.mStatusCode = Integer.parseInt(this.mStatusCodeString);
        }
        catch (NumberFormatException numberFormatException) {
            this.mMalformedHeader = true;
            return false;
        }
        return true;
    }

    public int getContentLength() {
        int n = super.getContentLength();
        if (this.mStatusCode >= 100 && this.mStatusCode < 200 || this.mStatusCode == 204 || this.mStatusCode == 304) {
            return 0;
        }
        if (this.mStatusCode >= 200 && this.mStatusCode < 300) {
            return n;
        }
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public static HttpResponseHeader getError(String string) {
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpResponseHeader = new HttpResponseHeader(string);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return httpResponseHeader;
    }

    public boolean isImage() {
        String string = this.getHeader("Content-Type".toUpperCase());
        return string != null && string.toLowerCase().indexOf(_CONTENT_TYPE_IMAGE) > -1;
    }

    public boolean isText() {
        String string = this.getHeader("Content-Type".toUpperCase());
        if (string != null) {
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_TEXT) > -1) {
                return true;
            }
            if (string.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatusLine(String string) {
        return patternPartialStatusLine.matcher(string).find();
    }

    public String getPrimeHeader() {
        String string = this.getVersion() + " " + this.getStatusCode();
        if (this.getReasonPhrase() != null && !this.getReasonPhrase().equals("")) {
            string = string + " " + this.getReasonPhrase();
        }
        return string;
    }
}

