/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.FileXML;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.xml.sax.SAXException;

public class Session
extends FileXML {
    private static final String ROOT = "session";
    private static final String SESSION_DESC = "sessionDesc";
    private static final String SESSION_ID = "sessionId";
    private static final String SESSION_NAME = "sessionName";
    private static final String[] PATH_SESSION_DESC = new String[]{"session", "sessionDesc"};
    private static final String[] PATH_SESSION_ID = new String[]{"session", "sessionId"};
    private static final String[] PATH_SESSION_NAME = new String[]{"session", "sessionName"};
    private Model model = null;
    private String fileName = "";
    private String sessionDesc = "";
    private long sessionId = 0L;
    private String sessionName = "";
    private SiteMap siteTree = null;

    public Session(Model model) {
        super(ROOT);
        this.setSessionId(System.currentTimeMillis());
        this.setSessionName("Untitled Session");
        this.setSessionDesc("");
        this.siteTree = SiteMap.createTree(model);
        this.model = model;
    }

    public void discard() {
        try {
            this.model.getDb().getTableHistory().deleteHistorySession(this.getSessionId());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public String getSessionDesc() {
        return this.sessionDesc;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SiteMap getSiteTree() {
        return this.siteTree;
    }

    public boolean isNewState() {
        return this.fileName.equals("");
    }

    public void open(final File file, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Exception exception = null;
                try {
                    Session.this.open(file.getAbsolutePath());
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionOpened(file, exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    public void open(String string) throws SQLException, SAXException, IOException, Exception {
        int n;
        int n2;
        this.readAndParseFile(string);
        this.model.getDb().close(false);
        this.model.getDb().open(string);
        this.fileName = string;
        SiteNode siteNode = new SiteNode("Sites");
        this.siteTree.setRoot(siteNode);
        Vector vector = this.model.getDb().getTableHistory().getHistoryList(this.getSessionId(), 1);
        HistoryReference historyReference = null;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = (Integer)vector.get(n2);
            try {
                historyReference = new HistoryReference(n);
                this.getSiteTree().addPath(historyReference);
                if (n2 % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        vector = this.model.getDb().getTableHistory().getHistoryList(this.getSessionId(), 2);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = (Integer)vector.get(n2);
            try {
                historyReference = new HistoryReference(n);
                this.getSiteTree().addPath(historyReference);
                if (n2 % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.gc();
    }

    protected void parse() throws Exception {
        long l = 0L;
        String string = "";
        String string2 = "";
        l = Long.parseLong(this.getValue(SESSION_ID));
        string = this.getValue(SESSION_NAME);
        string = this.getValue(SESSION_NAME);
        this.sessionId = l;
        this.sessionName = string;
        this.sessionDesc = string2;
    }

    public void save(final String string, final SessionListener sessionListener) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Exception exception = null;
                try {
                    Session.this.save(string);
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                if (sessionListener != null) {
                    sessionListener.sessionSaved(exception);
                }
            }
        });
        thread.setPriority(3);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws Exception {
        this.saveFile(string);
        if (this.isNewState()) {
            this.model.moveSessionDb(string);
        } else if (!this.fileName.equals(string)) {
            this.model.copySessionDb(this.fileName, string);
        }
        this.fileName = string;
        SiteMap siteMap = this.siteTree;
        synchronized (siteMap) {
            this.saveSiteTree((SiteNode)this.siteTree.getRoot());
        }
        this.model.getDb().getTableSession().update(this.getSessionId(), this.getSessionName());
    }

    public void setSessionDesc(String string) {
        this.sessionDesc = string;
        this.setValue(PATH_SESSION_DESC, string);
    }

    public void setSessionId(long l) {
        this.sessionId = l;
        this.setValue(PATH_SESSION_ID, Long.toString(l));
    }

    public void setSessionName(String string) {
        this.sessionName = string;
        this.setValue(PATH_SESSION_NAME, string);
    }

    public String getFileName() {
        return this.fileName;
    }

    private void saveSiteTree(SiteNode siteNode) {
        HttpMessage httpMessage = null;
        if (!siteNode.isRoot() && siteNode.getHistoryReference().getHistoryType() < 0) {
            this.saveNodeMsg(httpMessage);
        }
        for (int i = 0; i < siteNode.getChildCount(); ++i) {
            try {
                this.saveSiteTree((SiteNode)siteNode.getChildAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveNodeMsg(HttpMessage httpMessage) {
    }

    public String getSessionFolder() {
        String string = "";
        if (this.fileName.equals("")) {
            string = Constant.getInstance().FOLDER_SESSION;
        } else {
            File file = new File(this.fileName);
            string = file.getParent();
        }
        return string;
    }
}

