/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.AccuRevHistoryParser;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;

public class AccuRevRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.AccuRev";
    public static final String CMD_FALLBACK = "accurev";
    private static final Pattern annotationPattern = Pattern.compile("^\\s+(\\d+/\\d+)\\s+(\\w+)");
    private static final Pattern depotPattern = Pattern.compile("^Depot:\\s+(\\w+)");
    private static final RuntimeEnvironment env = RuntimeEnvironment.getInstance();

    public AccuRevRepository() {
        this.type = "AccuRev";
        this.datePattern = "yyyy/MM/dd hh:mm:ss";
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
    }

    @Override
    public Annotation annotate(File file, String rev) throws IOException {
        Annotation a = new Annotation(file.getName());
        ArrayList<String> cmd = new ArrayList<String>();
        String path = this.getDepotRelativePath(file);
        cmd.add(this.cmd);
        cmd.add("annotate");
        cmd.add("-fvu");
        if (rev != null) {
            cmd.add("-v");
            cmd.add(rev.trim());
        }
        cmd.add(path);
        Executor executor = new Executor(cmd, file.getParentFile());
        executor.exec();
        try (BufferedReader reader = new BufferedReader(executor.getOutputReader());){
            int lineno = 0;
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    ++lineno;
                    Matcher matcher = annotationPattern.matcher(line);
                    if (matcher.find()) {
                        String version = matcher.group(1);
                        String author = matcher.group(2);
                        a.addLine(version, author, true);
                        continue;
                    }
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "Did not find annotation in line " + lineno + ": [" + line + "]");
                }
            }
            catch (IOException e) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Could not read annotations for " + file, e);
            }
        }
        return a;
    }

    Executor getHistoryLogExecutor(File file) throws IOException {
        String path = this.getDepotRelativePath(file);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.cmd);
        cmd.add("hist");
        if (!file.isDirectory()) {
            cmd.add("-k");
            cmd.add("keep");
        }
        cmd.add(path);
        return new Executor(cmd, file.getParentFile());
    }

    @Override
    InputStream getHistoryGet(String parent, String basename, String rev) {
        ArrayList<String> cmd = new ArrayList<String>();
        ByteArrayInputStream inputStream = null;
        File directory = new File(parent);
        cmd.add(this.cmd);
        cmd.add("stat");
        cmd.add("-fe");
        cmd.add(basename);
        Executor executor = new Executor(cmd, directory);
        executor.exec();
        String elementID = null;
        try (BufferedReader info = new BufferedReader(executor.getOutputReader());){
            String line = info.readLine();
            String[] statInfo = line.split("\\s+");
            elementID = statInfo[1].substring(2);
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Could not obtain status for " + basename);
        }
        if (elementID != null) {
            cmd.clear();
            cmd.add(this.cmd);
            cmd.add("cat");
            cmd.add("-v");
            cmd.add(rev.trim());
            cmd.add("-e");
            cmd.add(elementID);
            executor = new Executor(cmd, directory);
            executor.exec();
            inputStream = new ByteArrayInputStream(executor.getOutputString().getBytes());
        }
        return inputStream;
    }

    @Override
    public void update() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    private boolean isInAccuRevDepot(File wsPath) {
        boolean status = false;
        if (this.isWorking()) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.cmd);
            cmd.add("info");
            Executor executor = new Executor(cmd, wsPath);
            executor.exec(true);
            try (BufferedReader info = new BufferedReader(executor.getOutputReader());){
                String line;
                while ((line = info.readLine()) != null) {
                    Matcher depotMatch = depotPattern.matcher(line);
                    if (line.indexOf("not logged in") != -1) {
                        OpenGrokLogger.getLogger().log(Level.SEVERE, "Not logged into AccuRev server");
                    } else {
                        if (!depotMatch.find()) continue;
                        status = true;
                    }
                    break;
                }
            }
            catch (IOException e) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Could not find AccuRev repository for " + wsPath);
            }
        }
        return status;
    }

    public String getDepotRelativePath(File file) {
        String path = "/./";
        try {
            path = env.getPathRelativeToSourceRoot(file, 0);
            path = path.startsWith("/") ? "/." + path : "/./" + path;
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Unable to determine depot relative path for " + file.getPath());
        }
        return path;
    }

    @Override
    boolean isRepositoryFor(File sourceHome) {
        return this.isInAccuRevDepot(sourceHome);
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.working = AccuRevRepository.checkCmd(this.cmd, "info");
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new AccuRevHistoryParser().parse(file, this);
    }
}

