/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#\u0001\u0002uaV\t\u0001\u0004\u0005\u0002\u001aC5\t!D\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004%\u0001\u0001\u0006I\u0001G\u0001\u0004iB\u0004\u0003\"\u0003\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001(\u0003)\u0019\u0007.Z2la>Lg\u000e^\u000b\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\u00111\u0006B\u0001\fG\",7m\u001b9pS:$8/\u0003\u0002.U\t)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\b\"C\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00011\u00039\u0019\u0007.Z2la>Lg\u000e^0%KF$\"!\r\u001b\u0011\u0005-\u0011\u0014BA\u001a\r\u0005\u0011)f.\u001b;\t\u000fUr\u0013\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\u0013]\u0002\u0001\u0019!A!B\u0013A\u0013aC2iK\u000e\\\u0007o\\5oi\u0002BQ!\u000f\u0001\u0005\u0002i\nQe\u001d5pk2$\u0017\t\u001a3Fa>\u001c\u0007.\u00118e\u001b\u0016\u001c8/Y4f\u001f\u001a47/\u001a;U_\u000e\u000b7\r[3\u0015\u0003EB#\u0001\u000f\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}z\u0012!\u00026v]&$\u0018BA!?\u0005\u0011!Vm\u001d;\t\u000b\r\u0003A\u0011\u0001\u001e\u0002]MDw.\u001e7e%\u0016$XO\u001d8M_\u001e,e\u000eZ(gMN,G/\u00134MCR,7\u000f^#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003\u0005rBQA\u0012\u0001\u0005\u0002i\nAg\u001d5pk2$'+\u001a;ve:,f\u000eZ3gS:,Gm\u00144gg\u0016$\u0018JZ+oI\u00164\u0017N\\3e\u000bB|7\r\u001b*fcV,7\u000f^3eQ\t)E\bC\u0003J\u0001\u0011\u0005!(\u0001\"tQ>,H\u000e\u001a(pi>3XM]<sSR,Gj\\4F]\u0012|eMZ:fi\u001a{'/\u0011'fC\u0012,'/\u00129pG\"|enY3Ji\"\u000b7OQ3f]\u0006\u001b8/[4oK\u0012D#\u0001\u0013\u001f\t\u000b1\u0003A\u0011\u0001\u001e\u0002cMDw.\u001e7e\u00032dwn\u001e'fC\u0012,'/\u00129pG\"$vn\u00115b]\u001e,WI^3o\u0013\u001a|eMZ:fi\u0012{Wm\u001d(pi\"\u00121\n\u0010\u0005\u0006\u001f\u0002!\tAO\u0001=g\"|W\u000f\u001c3O_R|e/\u001a:xe&$Xm\u00144gg\u0016$hi\u001c:B\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148dK&#\b*Y:CK\u0016t\u0017i]:jO:,G\r\u000b\u0002Oy!)!\u000b\u0001C\u0001u\u0005A3\u000f[8vY\u0012\u0014V\r^;s]Vs7/\u001e9q_J$X\rZ%g\u001d>,\u0005o\\2i%\u0016\u001cwN\u001d3fI\"\u0012\u0011\u000b\u0010\u0005\u0006+\u0002!\tAO\u0001:g\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMU3rk\u0016\u001cH/\u001a3Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c$jeN$X\t]8dQ\"\u0012A\u000b\u0010\u0005\u00061\u0002!\tAO\u0001Ig\"|W\u000f\u001c3HKR4\u0015N]:u\u001f\u001a47/\u001a;PMN+(m]3rk\u0016tG/\u00129pG\"<\u0006.\u001a8PM\u001a\u001cX\r\u001e*fcV,7\u000f^3e\r>\u0014\bK]3wS>,8/\u00129pG\"D#a\u0016\u001f\t\u000bm\u0003A\u0011\u0001\u001e\u0002\u000bNDw.\u001e7e%\u0016$XO\u001d8OKb$\u0018I^1jY\u0006\u0014G.Z#q_\u000eD\u0017J\u001a+iKJ,\u0017j\u001d(p\u000bb\f7\r^#q_\u000eDgi\u001c:UQ\u0016|e.\u001a*fcV,7\u000f^3eQ\tQF\bC\u0003_\u0001\u0011\u0005!(\u0001\u001atQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u000bB|7\r[!oIN#\u0018M\u001d;PM\u001a\u001cX\r^%g\u0013R$\u0015\u000e\u001a(pi\u000eC\u0017M\\4fQ\tiF\bC\u0003b\u0001\u0011\u0005!(A#tQ>,H\u000e\u001a*fiV\u0014h.\u00138wC2LGm\u00144gg\u0016$\u0018JZ#q_\u000eD\u0017j\u001d*fcV,7\u000f^3e/\"L7\r[%t\u001d>$8)\u001e:sK:$H.\u001f+sC\u000e\\W\r\u001a\u0015\u0003ArBQ\u0001\u001a\u0001\u0005\u0002i\n\u0011f\u001d5pk2$7+\u001e9q_J$X\t]8dQN$\u0006.\u0019;E_:{Go\u0015;beR4%o\\7[KJ|\u0007FA2=\u0011\u00159\u0007\u0001\"\u0001;\u0003\r\u001a\bn\\;mIB+'o]5ti\u0016\u0003xn\u00195t\u0005\u0016$x/Z3o\u0013:\u001cH/\u00198dKND#A\u001a\u001f\t\u000b)\u0004A\u0011\u0001\u001e\u0002cMDw.\u001e7e\u001d>$H*\u001a;Fa>\u001c\u0007nR8CC\u000e\\w/\u0019:eg\u00163XM\\%g\u001b\u0016\u001c8/Y4f\u000bB|7\r[:E_\"\u0012\u0011\u000e\u0010\u0005\u0006[\u0002!\tAO\u00013g\"|W\u000f\u001c3O_RdU\r^(gMN,Go]$p\u0005\u0006\u001c7n^1sIN,e/\u001a8JM\u0016\u0003xn\u00195t!J|wM]3tg\"\u0012A\u000e\u0010\u0005\u0006a\u0002!\tAO\u00015g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003NdU-\u00193feN\u001c\u0005.\u00198hK6\u000bg.\u001f+j[\u0016\u001c\bFA8=\u0011\u0015\u0019\b\u0001\"\u0001;\u0003i\u001a\bn\\;mI&s7M]3bg\u0016\fe\u000e\u001a+sC\u000e\\W\t]8dQN\f5OR8mY><XM\u001d*fG\u0016Lg/Z:NC:LX*Z:tC\u001e,7\u000f\u000b\u0002sy!)a\u000f\u0001C\u0001u\u0005I4\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:P]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a'bi\u0016\u001cH/\u00128ue&,7\u000f\u000b\u0002vy!)\u0011\u0010\u0001C\u0001u\u0005\u00194\u000f[8vY\u0012\u0004&/Z:feZ,'+Z:fi>3gm]3u\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3ti&3wJ\\3Fq&\u001cHo\u001d\u0015\u0003qrBQ\u0001 \u0001\u0005\u0002i\n\u0011h\u001d5pk2$W\u000b\u001d3bi\u0016\u001c\u0016M^3e\u001f\u001a47/\u001a;XQ\u0016twJ\u001a4tKR$vn\u00117fCJ$v.S:CKR<X-\u001a8Fa>\u001c\u0007n\u001d\u0015\u0003wrBQa \u0001\u0005\u0002i\nQe\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u0016\u000b'\u000f\\=)\u0005yd\u0004BBA\u0003\u0001\u0011\u0005!(A\u0016tQ>,H\u000e\u001a(pi\u000ecW-\u0019:B]f$\b.\u001b8h\u0013\u001a|eMZ:fiR{g)\u001b:ti>3gm]3uQ\r\t\u0019\u0001\u0010\u0005\u0007\u0003\u0017\u0001A\u0011\u0001\u001e\u0002SMDw.\u001e7e%\u0016$\u0018-\u001b8MCR,7\u000f^#q_\u000eDwJ\\\"mK\u0006\u0014\u0018\t\u001c7FCJd\u0017.Z:uQ\r\tI\u0001\u0010\u0005\u0007\u0003#\u0001A\u0011\u0001\u001e\u0002oMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:uQ\r\ty\u0001\u0010\u0005\u0007\u0003/\u0001A\u0011\u0001\u001e\u0002qMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:ue!\u001a\u0011Q\u0003\u001f\t\r\u0005u\u0001\u0001\"\u0001;\u0003m\u001a\bn\\;mIJ+G/Y5o\u0019\u0006$Xm\u001d;Fa>\u001c\u0007n\u00148DY\u0016\f'/\u00117m\u000b\u0006\u0014H.[3ti\u0006sG-\u00169eCR,\u0017\n^:PM\u001a\u001cX\r\u001e\u0015\u0004\u00037a\u0004BBA\u0012\u0001\u0011\u0005!(A\u001ctQ>,H\u000e\u001a#s_B,e\u000e\u001e:jKN\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1ss^CWM\u001c*f[>4\u0018N\\4OK^,7\u000f\u001e\u0015\u0004\u0003Ca\u0004BBA\u0015\u0001\u0011\u0005!(A\u000btQ>,H\u000eZ\"mK\u0006\u0014\u0018\t\u001c7F]R\u0014\u0018.Z:)\u0007\u0005\u001dB\b\u0003\u0004\u00020\u0001!\tAO\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f%fC\u0012Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0004\u0003[a\u0004BBA\u001b\u0001\u0011\u0005!(A\u0018tQ>,H\u000e\u001a(piJ+7/\u001a;Fa>\u001c\u0007\u000eS5ti>\u0014\u0018\u0010V1jY&3WK\u001c3fM&tW\r\u001a)bgN,G\rK\u0002\u00024qBa!a\u000f\u0001\t\u0003Q\u0014AI:i_VdGMR3uG\"d\u0015\r^3ti\u0016\u0003xn\u00195PM\u0016k\u0007\u000f^=DC\u000eDW\rK\u0002\u0002:qBa!!\u0011\u0001\t\u0003Q\u0014\u0001I:i_VdGMR3uG\",e\u000eZ(gMN,Go\u00144F[B$\u0018pQ1dQ\u0016D3!a\u0010=\u0011\u0019\t9\u0005\u0001C\u0001u\u0005y2\u000f[8vY\u0012\u001cE.Z1s\u000b\u0006\u0014H.[3ti>sW)\u001c9us\u000e\u000b7\r[3)\u0007\u0005\u0015C\b\u0003\u0004\u0002N\u0001!\tAO\u0001\u001eg\"|W\u000f\u001c3DY\u0016\f'\u000fT1uKN$xJ\\#naRL8)Y2iK\"\u001a\u00111\n\u001f\t\r\u0005M\u0003\u0001\"\u0001;\u0003\u0015\u0019X\r^+qQ\u0011\t\t&a\u0016\u0011\u0007u\nI&C\u0002\u0002\\y\u0012aAQ3g_J,\u0007")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private LeaderEpochCheckpoint checkpoint;

    public TopicPartition tp() {
        return this.tp;
    }

    public LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    public void checkpoint_$eq(LeaderEpochCheckpoint x$1) {
        this.checkpoint = x$1;
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$1(leo), this.checkpoint());
        cache.assign(2, 10L);
        leo.elem = 11;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((long)11L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$2(leo), this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(2, 12L);
        leo.elem = 14;
        Assert.assertEquals((long)14L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$3(), this.checkpoint());
        cache.assign(2, 11L);
        cache.assign(3, 12L);
        long offsetFor = cache.endOffsetFor(-1);
        Assert.assertEquals((long)-1L, (long)offsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        IntRef leo = IntRef.create((int)0);
        leo.elem = 9;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$4(leo), this.checkpoint());
        cache.assign(2, (long)leo.elem);
        cache.assign(2, 10L);
        Assert.assertEquals((long)leo.elem, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldAllowLeaderEpochToChangeEvenIfOffsetDoesNot() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$5(), this.checkpoint());
        cache.assign(2, 9L);
        cache.assign(3, 9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L), new EpochEntry(3, 9L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)cache.epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$6(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfRequestedEpochLessThanFirstEpoch() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$7(), this.checkpoint());
        cache.assign(5, 11L);
        cache.assign(6, 12L);
        cache.assign(7, 13L);
        long offset = cache.endOffsetFor(4);
        Assert.assertEquals((long)-1L, (long)offset);
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$8(leo), this.checkpoint());
        cache.assign(1, 11L);
        cache.assign(1, 12L);
        cache.assign(2, 13L);
        cache.assign(2, 14L);
        cache.assign(3, 15L);
        cache.assign(3, 16L);
        leo.elem = 17;
        Assert.assertEquals((long)15L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$9(), this.checkpoint());
        cache.assign(0, 10L);
        cache.assign(2, 13L);
        cache.assign(4, 17L);
        Assert.assertEquals((long)13L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)17L, (long)cache.endOffsetFor(2));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$10(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(2, 7L);
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int leo = 100;
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$11(leo), this.checkpoint());
        cache.assign(2, 100L);
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$12(leo), this.checkpoint());
        cache.assign(2, 6L);
        leo.elem = 7;
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)1L, (long)cache.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2()));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$13(), this.checkpoint());
        cache.assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$13(), (LeaderEpochCheckpoint)checkpoint2);
        Assert.assertEquals((long)1L, (long)cache2.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldNotLetEpochGoBackwardsEvenIfMessageEpochsDo() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$14(leo), this.checkpoint());
        cache.assign(1, 5L);
        leo.elem = 6;
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(1, 7L);
        leo.elem = 8;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)8L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 5L), (Object)cache.epochEntries().apply(0));
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().apply(1));
    }

    @Test
    public void shouldNotLetOffsetsGoBackwardsEvenIfEpochsProgress() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$15(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 5L);
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$16(leo), this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 0L);
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        leo.elem = 5;
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
        cache.assign(2, 5L);
        leo.elem = 10;
        Assert.assertEquals((long)10L, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)5L, (long)cache.endOffsetFor(1));
        Assert.assertEquals((long)0L, (long)cache.endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        IntRef leo = IntRef.create((int)0);
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$17(leo), this.checkpoint());
        cache.assign(0, 0L);
        leo.elem = 1;
        cache.assign(0, 1L);
        leo.elem = 2;
        cache.assign(0, 2L);
        leo.elem = 3;
        Assert.assertEquals((long)0L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(0));
        cache.assign(1, 3L);
        leo.elem = 4;
        cache.assign(1, 4L);
        leo.elem = 5;
        cache.assign(1, 5L);
        leo.elem = 6;
        Assert.assertEquals((long)1L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(1));
        cache.assign(2, 6L);
        leo.elem = 7;
        cache.assign(2, 7L);
        leo.elem = 8;
        cache.assign(2, 8L);
        leo.elem = 9;
        Assert.assertEquals((long)2L, (long)cache.latestEpoch());
        Assert.assertEquals((long)leo.elem, (long)cache.endOffsetFor(2));
        Assert.assertEquals((long)3L, (long)cache.endOffsetFor(0));
        Assert.assertEquals((long)6L, (long)cache.endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$18(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$19(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$20(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$21(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(1L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$22(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(6L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$23(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(11L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$24(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$25(), this.checkpoint());
        cache.assign(0, 0L);
        cache.assign(1, 7L);
        cache.assign(2, 10L);
        cache.clearAndFlushEarliest(5L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$26(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(15L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$27(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(9L);
        Assert.assertEquals((long)3L, (long)cache.latestEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)cache.epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$28(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlush();
        Assert.assertEquals((long)0L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$29(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushLatest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$30(), this.checkpoint());
        cache.assign(2, 6L);
        cache.assign(3, 8L);
        cache.assign(4, 11L);
        cache.clearAndFlushEarliest(-1L);
        Assert.assertEquals((long)3L, (long)cache.epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$31(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$32(), this.checkpoint());
        Assert.assertEquals((long)-1L, (long)cache.endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$33(), this.checkpoint());
        cache.clearAndFlushEarliest(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0 & java.io.Serializable & Serializable)() -> LeaderEpochFileCacheTest.leoFinder$34(), this.checkpoint());
        cache.clearAndFlushLatest(7L);
    }

    @Before
    public void setUp() {
        this.checkpoint_$eq((LeaderEpochCheckpoint)new LeaderEpochCheckpointFile(TestUtils$.MODULE$.tempFile(), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final LogOffsetMetadata leoFinder$1(IntRef leo$1) {
        return new LogOffsetMetadata((long)leo$1.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$2(IntRef leo$2) {
        return new LogOffsetMetadata((long)leo$2.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$3() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$4(IntRef leo$3) {
        return new LogOffsetMetadata((long)leo$3.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$5() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$6() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$7() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$8(IntRef leo$4) {
        return new LogOffsetMetadata((long)leo$4.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$9() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$10() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$11(int leo$5) {
        return new LogOffsetMetadata((long)leo$5, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$12(IntRef leo$6) {
        return new LogOffsetMetadata((long)leo$6.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$13() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$14(IntRef leo$7) {
        return new LogOffsetMetadata((long)leo$7.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$15() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$16(IntRef leo$8) {
        return new LogOffsetMetadata((long)leo$8.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$17(IntRef leo$9) {
        return new LogOffsetMetadata((long)leo$9.elem, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$18() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$19() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$20() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$21() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$22() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$23() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$24() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$25() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$26() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$27() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$28() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$29() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$30() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$31() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$32() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$33() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    private static final LogOffsetMetadata leoFinder$34() {
        return new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
    }
}

