/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board.icc;

import free.jin.Game;
import free.jin.board.Arrow;
import free.jin.board.BoardManager;
import free.jin.board.BoardPanel;
import free.jin.board.Circle;
import free.jin.board.JinBoard;
import free.jin.board.event.ArrowCircleListener;
import free.jin.board.icc.ChessclubJBoard;
import free.jin.chessclub.event.ArrowEvent;
import free.jin.chessclub.event.ChessclubGameListener;
import free.jin.chessclub.event.CircleEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.MoveMadeEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.TakebackEvent;
import java.awt.Color;

public class ChessclubBoardPanel
extends BoardPanel
implements ChessclubGameListener,
ArrowCircleListener {
    private boolean handlingArrowCircleEvent = false;

    public ChessclubBoardPanel(BoardManager boardManager, Game game) {
        super(boardManager, game);
    }

    protected JinBoard createBoard(Game game) {
        return new ChessclubJBoard(game.getInitialPosition());
    }

    protected void configureBoardFromGame(Game game, JinBoard jinBoard) {
        super.configureBoardFromGame(game, jinBoard);
        if (game.getGameType() == 1 && !game.isPlayed()) {
            jinBoard.addArrowCircleListener((ArrowCircleListener)this);
            jinBoard.setArrowCircleEnabled(true);
        } else {
            jinBoard.setArrowCircleEnabled(false);
        }
    }

    public void moveMade(MoveMadeEvent moveMadeEvent) {
        super.moveMade(moveMadeEvent);
        if (moveMadeEvent.getGame() != this.game) {
            return;
        }
        this.board.removeAllArrows();
        this.board.removeAllCircles();
    }

    public void positionChanged(PositionChangedEvent positionChangedEvent) {
        super.positionChanged(positionChangedEvent);
        if (positionChangedEvent.getGame() != this.game) {
            return;
        }
        this.board.removeAllArrows();
        this.board.removeAllCircles();
    }

    public void takebackOccurred(TakebackEvent takebackEvent) {
        super.takebackOccurred(takebackEvent);
        if (takebackEvent.getGame() != this.game) {
            return;
        }
        this.board.removeAllArrows();
        this.board.removeAllCircles();
    }

    public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
        super.illegalMoveAttempted(illegalMoveEvent);
        if (illegalMoveEvent.getGame() != this.game) {
            return;
        }
        this.board.removeAllArrows();
        this.board.removeAllCircles();
    }

    protected String createWhiteLabelText(Game game) {
        int n = game.getWhiteRating();
        String string = n > 0 ? " " + n : "";
        return game.getWhiteName() + game.getWhiteTitles() + string;
    }

    protected String createBlackLabelText(Game game) {
        int n = game.getBlackRating();
        String string = n > 0 ? " " + n : "";
        return game.getBlackName() + game.getBlackTitles() + string;
    }

    public void arrowAdded(ArrowEvent arrowEvent) {
        if (arrowEvent.getGame() != this.game) {
            return;
        }
        Arrow arrow = new Arrow(arrowEvent.getFromSquare(), arrowEvent.getToSquare(), Color.blue);
        this.handlingArrowCircleEvent = true;
        this.board.removeArrowsAt(arrowEvent.getFromSquare(), arrowEvent.getToSquare());
        this.board.addArrow(arrow);
        this.handlingArrowCircleEvent = false;
    }

    public void arrowRemoved(ArrowEvent arrowEvent) {
        if (arrowEvent.getGame() != this.game) {
            return;
        }
        this.handlingArrowCircleEvent = true;
        this.board.removeArrowsAt(arrowEvent.getFromSquare(), arrowEvent.getToSquare());
        this.handlingArrowCircleEvent = false;
    }

    public void circleAdded(CircleEvent circleEvent) {
        if (circleEvent.getGame() != this.game) {
            return;
        }
        Circle circle = new Circle(circleEvent.getCircleSquare(), Color.blue);
        this.handlingArrowCircleEvent = true;
        this.board.removeCirclesAt(circleEvent.getCircleSquare());
        this.board.addCircle(circle);
        this.handlingArrowCircleEvent = false;
    }

    public void circleRemoved(CircleEvent circleEvent) {
        if (circleEvent.getGame() != this.game) {
            return;
        }
        this.handlingArrowCircleEvent = true;
        this.board.removeCirclesAt(circleEvent.getCircleSquare());
        this.handlingArrowCircleEvent = false;
    }

    public void arrowAdded(JinBoard jinBoard, Arrow arrow) {
        if (this.handlingArrowCircleEvent) {
            return;
        }
        this.boardManager.getConn().sendCommand("arrow " + arrow.getFrom() + " " + arrow.getTo());
    }

    public void arrowRemoved(JinBoard jinBoard, Arrow arrow) {
        if (this.handlingArrowCircleEvent) {
            return;
        }
        this.boardManager.getConn().sendCommand("unarrow " + arrow.getFrom() + " " + arrow.getTo());
    }

    public void circleAdded(JinBoard jinBoard, Circle circle) {
        if (this.handlingArrowCircleEvent) {
            return;
        }
        this.boardManager.getConn().sendCommand("circle " + circle.getSquare());
    }

    public void circleRemoved(JinBoard jinBoard, Circle circle) {
        if (this.handlingArrowCircleEvent) {
            return;
        }
        this.boardManager.getConn().sendCommand("uncircle " + circle.getSquare());
    }
}

