/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JMenu;
import net.sf.gogui.gui.RecentMenuItem;

public final class RecentMenu {
    private static final int MAX_ITEMS = 20;
    private final ActionListener m_listener;
    private final Callback m_callback;
    private final File m_file;
    private final JMenu m_menu;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RecentMenu(String string, File file, Callback callback) {
        if (!$assertionsDisabled && callback == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        this.m_file = file;
        this.m_callback = callback;
        this.m_menu = new JMenu(string);
        this.m_listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecentMenuItem recentMenuItem = (RecentMenuItem)actionEvent.getSource();
                String string = recentMenuItem.getRecentMenuLabel();
                String string2 = recentMenuItem.getRecentMenuValue();
                RecentMenu.this.m_callback.itemSelected(string, string2);
            }
        };
        this.load();
    }

    public void add(String string, String string2, boolean bl) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (!this.getValue(i).equals(string2)) continue;
            this.m_menu.remove(i);
        }
        RecentMenuItem recentMenuItem = new RecentMenuItem(string, string2, this.m_listener);
        this.m_menu.add((Component)recentMenuItem, 0);
        while (this.getCount() > 20) {
            this.m_menu.remove(this.getCount() - 1);
        }
        if (bl) {
            this.save();
        }
    }

    public int getCount() {
        return this.m_menu.getItemCount();
    }

    public JMenu getMenu() {
        return this.m_menu;
    }

    public String getValue(int n) {
        return this.getItem(n).getRecentMenuValue();
    }

    public void remove(int n) {
        this.m_menu.remove(this.getItem(n));
    }

    public void save() {
        Properties properties = new Properties();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            properties.setProperty("label_" + (n - i - 1), this.getLabel(i));
            properties.setProperty("value_" + (n - i - 1), this.getValue(i));
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_file);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLabel(int n, String string) {
        this.getItem(n).setRecentMenuLabel(string);
    }

    private RecentMenuItem getItem(int n) {
        return (RecentMenuItem)this.m_menu.getItem(n);
    }

    private String getLabel(int n) {
        return this.getItem(n).getRecentMenuLabel();
    }

    private void load() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(this.m_file));
        }
        catch (IOException iOException) {
            return;
        }
        this.m_menu.removeAll();
        for (int i = 0; i < 20; ++i) {
            String string = properties.getProperty("label_" + i);
            String string2 = properties.getProperty("value_" + i);
            if (string == null || string2 == null) continue;
            this.add(string, string2, false);
        }
    }

    static {
        $assertionsDisabled = !RecentMenu.class.desiredAssertionStatus();
    }

    public static interface Callback {
        public void itemSelected(String var1, String var2);
    }
}

