/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetInfluencersAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetInfluencersAction INSTANCE = new GetInfluencersAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/influencers/get";

    private GetInfluencersAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<Influencer> influencers;

        public Response() {
        }

        public Response(QueryPage<Influencer> influencers) {
            this.influencers = influencers;
        }

        public QueryPage<Influencer> getInfluencers() {
            return this.influencers;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.influencers = new QueryPage(in, Influencer::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.influencers.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.influencers.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.influencers);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.influencers, other.influencers);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField INFLUENCER_SCORE = new ParseField("influencer_score", new String[0]);
        public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
        public static final ParseField DESCENDING_SORT = new ParseField("desc", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/influencers/get", Request::new);
        private String jobId;
        private String start;
        private String end;
        private boolean excludeInterim = false;
        private PageParams pageParams = new PageParams();
        private double influencerScore = 0.0;
        private String sort = Influencer.INFLUENCER_SCORE.getPreferredName();
        private boolean descending = true;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public double getInfluencerScore() {
            return this.influencerScore;
        }

        public void setInfluencerScore(double anomalyScoreFilter) {
            this.influencerScore = anomalyScoreFilter;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = ExceptionsHelper.requireNonNull(sort, SORT_FIELD.getPreferredName());
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.excludeInterim = in.readBoolean();
            this.pageParams = new PageParams(in);
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.sort = in.readOptionalString();
            this.descending = in.readBoolean();
            this.influencerScore = in.readDouble();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeBoolean(this.excludeInterim);
            this.pageParams.writeTo(out);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.sort);
            out.writeBoolean(this.descending);
            out.writeDouble(this.influencerScore);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            builder.field(START.getPreferredName(), this.start);
            builder.field(END.getPreferredName(), this.end);
            builder.field(SORT_FIELD.getPreferredName(), this.sort);
            builder.field(DESCENDING_SORT.getPreferredName(), this.descending);
            builder.field(INFLUENCER_SCORE.getPreferredName(), this.influencerScore);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.excludeInterim, this.pageParams, this.start, this.end, this.sort, this.descending, this.influencerScore);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.influencerScore, other.influencerScore) && Objects.equals(this.descending, other.descending) && Objects.equals(this.sort, other.sort);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareStringOrNull(Request::setStart, START);
            PARSER.declareStringOrNull(Request::setEnd, END);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareDouble(Request::setInfluencerScore, INFLUENCER_SCORE);
            PARSER.declareString(Request::setSort, SORT_FIELD);
            PARSER.declareBoolean(Request::setDescending, DESCENDING_SORT);
        }
    }
}

