/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.ExpandedIdsMatcher;

public class DatafeedConfigReader {
    private final DatafeedConfigProvider datafeedConfigProvider;

    public DatafeedConfigReader(Client client, NamedXContentRegistry xContentRegistry) {
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
    }

    public DatafeedConfigReader(DatafeedConfigProvider datafeedConfigProvider) {
        this.datafeedConfigProvider = datafeedConfigProvider;
    }

    public void datafeedConfig(String datafeedId, ClusterState state, ActionListener<DatafeedConfig> listener) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        DatafeedConfig config = mlMetadata.getDatafeed(datafeedId);
        if (config != null) {
            listener.onResponse((Object)config);
        } else {
            this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(builder -> listener.onResponse((Object)builder.build()), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public void expandDatafeedIds(String expression, boolean allowNoDatafeeds, ClusterState clusterState, ActionListener<SortedSet<String>> listener) {
        Set clusterStateDatafeedIds = MlMetadata.getMlMetadata((ClusterState)clusterState).expandDatafeedIds(expression);
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(expression, allowNoDatafeeds);
        requiredMatches.filterMatchedIds(clusterStateDatafeedIds);
        this.datafeedConfigProvider.expandDatafeedIdsWithoutMissingCheck(expression, (ActionListener<SortedSet<String>>)ActionListener.wrap(expandedDatafeedIds -> {
            requiredMatches.filterMatchedIds((Collection<String>)expandedDatafeedIds);
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)requiredMatches.unmatchedIdsString()));
            } else {
                expandedDatafeedIds.addAll(clusterStateDatafeedIds);
                listener.onResponse(expandedDatafeedIds);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void expandDatafeedConfigs(String expression, boolean allowNoDatafeeds, ClusterState clusterState, ActionListener<List<DatafeedConfig>> listener) {
        Map<String, DatafeedConfig> clusterStateConfigs = this.expandClusterStateDatafeeds(expression, clusterState);
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(expression, allowNoDatafeeds);
        this.datafeedConfigProvider.expandDatafeedConfigsWithoutMissingCheck(expression, (ActionListener<List<DatafeedConfig.Builder>>)ActionListener.wrap(indexDatafeeds -> {
            ArrayList datafeedConfigs = new ArrayList(clusterStateConfigs.values());
            for (DatafeedConfig.Builder builder : indexDatafeeds) {
                if (clusterStateConfigs.containsKey(builder.getId())) continue;
                datafeedConfigs.add(builder.build());
            }
            requiredMatches.filterMatchedIds(datafeedConfigs.stream().map(DatafeedConfig::getId).collect(Collectors.toList()));
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)requiredMatches.unmatchedIdsString()));
            } else {
                Collections.sort(datafeedConfigs, Comparator.comparing(DatafeedConfig::getId));
                listener.onResponse(datafeedConfigs);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private Map<String, DatafeedConfig> expandClusterStateDatafeeds(String datafeedExpression, ClusterState clusterState) {
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        Set expandedDatafeedIds = mlMetadata.expandDatafeedIds(datafeedExpression);
        return expandedDatafeedIds.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((MlMetadata)mlMetadata).getDatafeed(arg_0)));
    }
}

