/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust.message.token;

import java.security.Key;
import java.security.cert.X509Certificate;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class STSSignedToken {
    private Element element;

    public STSSignedToken(Document docTobeSigned, Crypto crypto, String alias, String password) throws WSSecurityException {
        X509Certificate[] certs = crypto.getCertificates(alias);
        String pubKeyAlgo = certs[0].getPublicKey().getAlgorithm();
        String sigAlgo = "";
        String canonAlgo = "http://www.w3.org/2001/10/xml-exc-c14n#";
        if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
            sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Signature - unkown public key Algo"});
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(docTobeSigned, null, sigAlgo, canonAlgo);
            sig.addKeyInfo(certs[0]);
            sig.sign((Key)crypto.getPrivateKey(alias, password));
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(9, "UserNAmeTokenIssuer:signature over token failed");
        }
        catch (Exception e1) {
            throw new WSSecurityException(9, "UserNAmeTokenIssuer:signature over token failed. General exception-kau");
        }
        this.element = sig.getElement();
    }

    public Element getElement() {
        return this.element;
    }
}

