/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.Client;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.ImageViewer;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.SingletonWindow;
import org.igoweb.util.swing.TBlock;

public class UploadPicWindow
extends AFrame {
    private final AFrame clientWin;
    private final Client client;

    private UploadPicWindow(AFrame parent, Client client) {
        super(Defs.getString(-382651082), parent);
        this.clientWin = parent;
        this.client = client;
        this.setContentPane(new JPanel(new BorderLayout()));
        this.getContentPane().add("North", new TBlock(Defs.getString(-382651083), 30));
        this.getContentPane().add(new FileChooser());
        this.pack(parent);
        this.setVisible(true);
    }

    public void fileChosen(File file) {
        System.setProperty("user.dir", file.getParentFile().toString());
        byte[] data = new byte[(int)file.length()];
        try {
            FileInputStream in = new FileInputStream(file);
            int fileLen = in.read(data);
            in.close();
            UploadPicWindow.bytesReady(data, file.toString(), this.clientWin, this.client);
            this.dispose();
        }
        catch (IOException excep) {
            new Errout(Defs.getString(-382651061, new Object[]{excep, file}), this.clientWin);
            this.dispose();
        }
        catch (Exception excep) {
            new Errout(Defs.getString(-382651063, new Object[]{file, new Integer(141), new Integer(200)}), this.clientWin);
            this.dispose();
        }
        this.dispose();
    }

    private static void bytesReady(byte[] data, String file, AFrame parent, Client client) throws IOException {
        Image img = parent.getToolkit().createImage(data, 0, data.length);
        MediaTracker mt = new MediaTracker(parent);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException excep) {
            throw new RuntimeException(excep);
        }
        if (img.getWidth(null) != 141 || img.getHeight(null) != 200 || data.length > 7168) {
            try {
                byte[] newImgData = UploadPicWindow.resizeJpg(img, 141, 200, 7168);
                new VerifyPicWindow(parent, client, newImgData);
                return;
            }
            catch (Exception excep) {
                new Errout(Defs.getString(-382651079, new Object[]{file, excep, Config.get("adminEmail")}));
                return;
            }
        }
        client.uploadAvatar(data, data.length);
        new MsgOut(Defs.getString(-903340709), Defs.getString(-382651081), 1, (Component)parent);
    }

    private static byte[] resizeJpg(Image src, int w, int h, int maxLength) {
        int srcW = src.getWidth(null);
        int srcH = src.getHeight(null);
        BufferedImage dest = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)dest.getGraphics();
        if (srcW == w && srcH == h) {
            g.drawImage(src, 0, 0, null);
        } else {
            AffineTransform xf = new AffineTransform();
            double xScale = (double)w / (double)srcW;
            double yScale = (double)h / (double)srcH;
            if (xScale > yScale) {
                xf.translate(0.0, -(xScale * (double)srcH - (double)h) * 0.5);
                xf.scale(xScale, xScale);
            } else {
                xf.translate(-(yScale * (double)srcW - (double)w) * 0.5, 0.0);
                xf.scale(yScale, yScale);
            }
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(src, xf, null);
        }
        IIOImage in = new IIOImage(dest, null, null);
        try {
            ImageWriter writer = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
            JPEGImageWriteParam params = (JPEGImageWriteParam)writer.getDefaultWriteParam();
            params.setCompressionMode(2);
            for (float quality = 0.9f; quality > 0.05f; quality *= 0.9f) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                writer.setOutput(new MemoryCacheImageOutputStream(bos));
                params.setCompressionQuality(quality);
                writer.write(null, in, params);
                if (bos.size() > maxLength) continue;
                return bos.toByteArray();
            }
        }
        catch (Exception excep) {
            excep.printStackTrace();
        }
        return null;
    }

    public static class VerifyPicWindow
    extends DFrame {
        public VerifyPicWindow(AFrame parent, final Client client, final byte[] imgData) {
            super(Defs.getString(-382651082), parent);
            this.getMainPanel().setLayout(new BorderLayout());
            this.getMainPanel().add("North", new TBlock(Defs.getString(-382651080, new Object[]{new Integer(141), new Integer(200), new Integer(7)}), 50));
            this.getMainPanel().add(new ImageViewer(this.getToolkit().createImage(imgData), 141, 200));
            this.addButton(Defs.getString(1436228518), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.dispose();
                    client.uploadAvatar(imgData, imgData.length);
                }
            });
            this.addButton(Defs.getString(1436228510), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    this.dispose();
                }
            });
            this.pack();
            this.setVisible(true);
        }
    }

    public static class MenuItem
    extends JMenuItem {
        private final AFrame clientWin;
        private final Client client;
        SingletonWindow upWin = new SingletonWindow();

        public MenuItem(AFrame clientWin, Client client) {
            super(Defs.getString(-903340662));
            this.clientWin = clientWin;
            this.client = client;
            this.setEnabled(false);
        }

        @Override
        public void paint(Graphics g) {
            if (this.isEnabled() == this.client.getMe().isGuest()) {
                this.setEnabled(!this.client.getMe().isGuest());
            }
            super.paint(g);
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            JnlpIo.FileAccessResult far = null;
            if (JnlpIo.isAvailable()) {
                try {
                    far = JnlpIo.openFile(null, new String[]{"jpg", "jpeg", "gif", "png"});
                    if (far != null && far.isFileSelected()) {
                        InputStream in = far.getInputStream();
                        ByteArrayOutputStream byteReader = new ByteArrayOutputStream();
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        do {
                            if ((len = in.read(buffer)) <= 0) continue;
                            byteReader.write(buffer, 0, len);
                        } while (len == buffer.length);
                        UploadPicWindow.bytesReady(byteReader.toByteArray(), far == null || far.getFileName() == null ? "<unknown>" : far.getFileName(), this.clientWin, this.client);
                    }
                }
                catch (IOException excep) {
                    new Errout(Defs.getString(-382651079, new Object[]{far == null || far.getFileName() == null ? "<unknown>" : far.getFileName(), excep, Config.get("adminEmail")}));
                }
            }
            if (far == null) {
                this.upWin.setWindow(new UploadPicWindow(this.clientWin, this.client));
            }
            super.fireActionPerformed(event);
        }
    }

    public class FileChooser
    extends JFileChooser {
        public FileChooser() {
            this.setDialogType(0);
            this.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String fName = file.toString();
                    if (fName == null) {
                        return false;
                    }
                    return fName.endsWith(".jpg") || fName.endsWith(".jpeg") || fName.endsWith(".gif") || fName.endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return Defs.getString(-382651062);
                }
            });
            this.setCurrentDirectory(new File(System.getProperty("user.home")));
        }

        @Override
        public void approveSelection() {
            UploadPicWindow.this.fileChosen(this.getSelectedFile());
        }

        @Override
        public void cancelSelection() {
            UploadPicWindow.this.dispose();
        }
    }
}

