/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.List;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;

public class RangeNamesQueryPager
extends AbstractQueryPager {
    private final RangeSliceCommand command;
    private volatile DecoratedKey lastReturnedKey;

    RangeNamesQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery) {
        super(consistencyLevel, command.maxResults, localQuery, command.keyspace, command.columnFamily, command.predicate, command.timestamp);
        this.command = command;
        assert (this.columnFilter instanceof NamesQueryFilter && ((NamesQueryFilter)this.columnFilter).countCQL3Rows());
    }

    RangeNamesQueryPager(RangeSliceCommand command, ConsistencyLevel consistencyLevel, boolean localQuery, PagingState state) {
        this(command, consistencyLevel, localQuery);
        if (state != null) {
            this.lastReturnedKey = StorageService.getPartitioner().decorateKey(state.partitionKey);
            this.restoreState(state.remaining, true);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.getKey(), null, this.maxRemaining());
    }

    @Override
    protected List<Row> queryNextPage(int pageSize, ConsistencyLevel consistencyLevel, boolean localQuery) throws RequestExecutionException {
        AbstractRangeCommand pageCmd = this.command.withUpdatedLimit(pageSize);
        if (this.lastReturnedKey != null) {
            pageCmd = pageCmd.forSubRange(this.makeExcludingKeyBounds(this.lastReturnedKey));
        }
        return localQuery ? pageCmd.executeLocally() : StorageProxy.getRangeSlice(pageCmd, consistencyLevel);
    }

    @Override
    protected boolean containsPreviousLast(Row first) {
        return this.lastReturnedKey != null && this.lastReturnedKey.equals(first.key);
    }

    @Override
    protected boolean recordLast(Row last) {
        this.lastReturnedKey = last.key;
        return false;
    }

    @Override
    protected boolean isReversed() {
        return false;
    }

    private AbstractBounds<RowPosition> makeExcludingKeyBounds(RowPosition lastReturnedKey) {
        AbstractBounds bounds = this.command.keyRange;
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return new Range<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
        }
        return new ExcludingBounds<RowPosition>(lastReturnedKey, (RowPosition)bounds.right);
    }
}

