/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class SessionWindowsHolder {
    HashMap<IIdentifier, List<ISessionWidget>> _framesBySessionIdentifier = new HashMap();
    HashMap<ISessionWidget, IIdentifier> _sessionIdentifierByFrame = new HashMap();
    Vector<ISessionWidget> _framesInOpeningSequence = new Vector();

    public int addFrame(IIdentifier sessionIdentifier, ISessionWidget sessionWidget) {
        List<ISessionWidget> windowList = this._framesBySessionIdentifier.get(sessionIdentifier);
        if (windowList == null) {
            windowList = new ArrayList<ISessionWidget>();
            this._framesBySessionIdentifier.put(sessionIdentifier, windowList);
        }
        windowList.add(sessionWidget);
        this._framesInOpeningSequence.add(sessionWidget);
        this._sessionIdentifierByFrame.put(sessionWidget, sessionIdentifier);
        return windowList.size();
    }

    public ISessionWidget[] getFramesOfSession(IIdentifier sessionIdentifier) {
        List<ISessionWidget> list = this._framesBySessionIdentifier.get(sessionIdentifier);
        if (null == list) {
            return new ISessionWidget[0];
        }
        return list.toArray(new ISessionWidget[list.size()]);
    }

    public void removeWindow(ISessionWidget sessionWidget) {
        IIdentifier sessionIdentifier = this._sessionIdentifierByFrame.get(sessionWidget);
        if (null == sessionIdentifier) {
            throw new IllegalArgumentException("Unknown Frame " + sessionWidget.getTitle());
        }
        List<ISessionWidget> framesOfSession = this._framesBySessionIdentifier.get(sessionIdentifier);
        framesOfSession.remove(sessionWidget);
        this._framesInOpeningSequence.remove(sessionWidget);
        this._sessionIdentifierByFrame.remove(sessionWidget);
    }

    public void removeAllWindows(IIdentifier sessionId) {
        ISessionWidget[] framesOfSession = this.getFramesOfSession(sessionId);
        for (int i = 0; i < framesOfSession.length; ++i) {
            this._framesInOpeningSequence.remove(framesOfSession[i]);
            this._sessionIdentifierByFrame.remove(framesOfSession[i]);
        }
        this._framesBySessionIdentifier.remove(sessionId);
    }

    public ISessionWidget getNextSessionWindow(ISessionWidget sessionWindow) {
        int nextIx = this._framesInOpeningSequence.indexOf(sessionWindow) + 1;
        if (nextIx < this._framesInOpeningSequence.size()) {
            return this._framesInOpeningSequence.get(nextIx);
        }
        if (1 < this._framesInOpeningSequence.size()) {
            return this._framesInOpeningSequence.get(0);
        }
        return sessionWindow;
    }

    public ISessionWidget getPreviousSessionWindow(ISessionWidget sessionWindow) {
        int prevIx = this._framesInOpeningSequence.indexOf(sessionWindow) - 1;
        if (0 <= prevIx) {
            return this._framesInOpeningSequence.get(prevIx);
        }
        if (1 < this._framesInOpeningSequence.size()) {
            return this._framesInOpeningSequence.get(this._framesInOpeningSequence.size() - 1);
        }
        return sessionWindow;
    }
}

