/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import org.fife.rtext.NumberDocumentFilter;
import org.fife.rtext.RText;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SpellingSupport;
import org.fife.ui.FSATextField;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.SelectableLabel;
import org.fife.ui.SpecialValueComboBox;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

public class SpellingOptionPanel
extends OptionsDialogPanel {
    private JCheckBox enabledCB;
    private JLabel dictLabel;
    private SpecialValueComboBox dictCombo;
    private JLabel userDictLabel;
    private FSATextField userDictField;
    private SelectableLabel userDictDescField;
    private JButton userDictBrowse;
    private RTextFileChooser chooser;
    private JLabel colorLabel;
    private RColorSwatchesButton spellingColorButton;
    private JLabel errorsPerFileLabel;
    private JTextField maxErrorsField;
    private JCheckBox viewSpellingWindowCB;
    private Listener listener;
    private ResourceBundle msg;
    private static final String[][] DICTIONARIES = new String[][]{{"English (United Kingdom)", SpellingSupport.DICTIONARIES[0]}, {"English (United States)", SpellingSupport.DICTIONARIES[1]}};
    private static final String MISC_PROPERTY = "Miscellaneous";

    public SpellingOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.listener = new Listener();
        this.msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.SpellingOptionPanel");
        this.setName(this.msg.getString("Title"));
        this.setLayout(new BorderLayout());
        this.setBorder(UIUtil.getEmpty5Border());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(this.msg.getString("Spelling")));
        this.add(contentPane);
        Box temp = Box.createVerticalBox();
        contentPane.add((Component)temp, "North");
        this.enabledCB = new JCheckBox(this.msg.getString("Enabled"));
        this.enabledCB.setActionCommand("Enabled");
        this.enabledCB.addActionListener(this.listener);
        this.addLeftAligned(temp, this.enabledCB);
        temp.add(Box.createVerticalStrut(5));
        this.dictLabel = new JLabel(this.msg.getString("Dictionary"));
        this.dictCombo = new SpecialValueComboBox();
        for (int i = 0; i < DICTIONARIES.length; ++i) {
            this.dictCombo.addSpecialItem((Object)DICTIONARIES[i][0], DICTIONARIES[i][1]);
        }
        this.dictCombo.setEditable(false);
        this.dictCombo.setActionCommand("Dictionary");
        this.dictCombo.addActionListener((ActionListener)this.listener);
        JPanel dictComboPanel = new JPanel(new BorderLayout());
        dictComboPanel.add((Component)this.dictCombo, "Before");
        this.dictLabel.setLabelFor((Component)this.dictCombo);
        this.userDictLabel = new JLabel(this.msg.getString("UserDictionary"));
        this.userDictField = new FSATextField(35);
        this.userDictField.getDocument().addDocumentListener(this.listener);
        this.userDictBrowse = new JButton(this.msg.getString("Browse"));
        this.userDictBrowse.setActionCommand("BrowseUserDictionary");
        this.userDictBrowse.addActionListener(this.listener);
        JPanel userDictFieldPanel = new JPanel(new BorderLayout());
        userDictFieldPanel.add((Component)this.userDictField);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        buttonPanel.add(this.userDictBrowse);
        userDictFieldPanel.add((Component)buttonPanel, "After");
        this.userDictDescField = new SelectableLabel(this.msg.getString("UserDictionaryDesc"));
        this.colorLabel = new JLabel(this.msg.getString("Color"));
        this.spellingColorButton = new RColorSwatchesButton();
        this.spellingColorButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this.listener);
        JPanel colorButtonPanel = new JPanel(new BorderLayout());
        colorButtonPanel.add((Component)this.spellingColorButton, "Before");
        this.errorsPerFileLabel = new JLabel(this.msg.getString("MaxErrorsPerFile"));
        this.maxErrorsField = new JTextField(8);
        ((AbstractDocument)this.maxErrorsField.getDocument()).setDocumentFilter((DocumentFilter)((Object)new NumberDocumentFilter()));
        this.maxErrorsField.getDocument().addDocumentListener(this.listener);
        JPanel maxErrorsPanel = new JPanel(new BorderLayout());
        maxErrorsPanel.add((Component)this.maxErrorsField, "Before");
        JPanel temp2 = new JPanel(new SpringLayout());
        temp2.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        if (orientation.isLeftToRight()) {
            temp2.add(this.dictLabel);
            temp2.add(dictComboPanel);
            temp2.add(this.userDictLabel);
            temp2.add(userDictFieldPanel);
            temp2.add(Box.createRigidArea(new Dimension(1, 1)));
            temp2.add((Component)this.userDictDescField);
            temp2.add(this.colorLabel);
            temp2.add(colorButtonPanel);
            temp2.add(this.errorsPerFileLabel);
            temp2.add(maxErrorsPanel);
        } else {
            temp2.add(dictComboPanel);
            temp2.add(this.dictLabel);
            temp2.add(userDictFieldPanel);
            temp2.add(this.userDictLabel);
            temp2.add((Component)this.userDictDescField);
            temp2.add(Box.createRigidArea(new Dimension(1, 1)));
            temp2.add(colorButtonPanel);
            temp2.add(this.colorLabel);
            temp2.add(maxErrorsPanel);
            temp2.add(this.errorsPerFileLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)temp2, (int)5, (int)2, (int)5, (int)5, (int)5, (int)5);
        this.addLeftAligned(temp, temp2);
        temp.add(Box.createVerticalStrut(5));
        this.viewSpellingWindowCB = new JCheckBox(this.msg.getString("ViewSpellingErrorWindow"));
        this.viewSpellingWindowCB.setActionCommand("ViewSpellingWindow");
        this.viewSpellingWindowCB.addActionListener(this.listener);
        this.addLeftAligned(temp, this.viewSpellingWindowCB);
        temp.add(Box.createVerticalStrut(5));
        JButton rdButton = new JButton(this.msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this.listener);
        this.addLeftAligned(temp, rdButton);
        temp.add(Box.createVerticalStrut(5));
        temp.add(Box.createVerticalGlue());
        this.applyComponentOrientation(orientation);
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        SpellingSupport support = rtext.getMainView().getSpellingSupport();
        support.setSpellCheckingEnabled(this.enabledCB.isSelected());
        support.setSpellingDictionary(this.dictCombo.getSelectedSpecialItem());
        support.setUserDictionary(this.getUserDictionary());
        support.setSpellCheckingColor(this.spellingColorButton.getColor());
        support.setMaxSpellingErrors(this.getMaxSpellingErrors());
        rtext.setSpellingWindowVisible(this.viewSpellingWindowCB.isSelected());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        File userDict;
        String desc;
        OptionsDialogPanel.OptionsPanelCheckResult res = null;
        String maxErrors = this.maxErrorsField.getText();
        try {
            int max = Integer.parseInt(maxErrors);
            if (max < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            desc = this.msg.getString("Error.InvalidMaxErrors.txt");
            res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.maxErrorsField, desc);
        }
        if (res == null && (userDict = this.getUserDictionary()) != null) {
            if (userDict.isDirectory()) {
                desc = this.msg.getString("Error.UserDictionaryIsDirectory.txt");
                res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.userDictField, desc);
            } else {
                File parent = userDict.getParentFile();
                if (parent == null || !parent.exists()) {
                    String desc2 = this.msg.getString("Error.CannotCreateUserDictionary.txt");
                    res = new OptionsDialogPanel.OptionsPanelCheckResult((OptionsDialogPanel)this, (JComponent)this.userDictField, desc2);
                }
            }
        }
        return res;
    }

    private int getMaxSpellingErrors() {
        try {
            return Integer.parseInt(this.maxErrorsField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            return 30;
        }
    }

    public JComponent getTopJComponent() {
        return this.enabledCB;
    }

    private File getUserDictionary() {
        String temp = this.userDictField.getText();
        if (temp.trim().length() == 0) {
            return null;
        }
        return new File(temp).getAbsoluteFile();
    }

    private void setSpellCheckingEnabled(boolean enabled) {
        this.enabledCB.setSelected(enabled);
        this.dictLabel.setEnabled(enabled);
        this.dictCombo.setEnabled(enabled);
        this.userDictLabel.setEnabled(enabled);
        this.userDictField.setEnabled(enabled);
        this.userDictBrowse.setEnabled(enabled);
        this.userDictDescField.setEnabled(enabled);
        this.colorLabel.setEnabled(enabled);
        this.spellingColorButton.setEnabled(enabled);
        this.errorsPerFileLabel.setEnabled(enabled);
        this.maxErrorsField.setEnabled(enabled);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        SpellingSupport support = rtext.getMainView().getSpellingSupport();
        boolean enabled = support.isSpellCheckingEnabled();
        this.setSpellCheckingEnabled(enabled);
        this.dictCombo.setSelectedSpecialItem(support.getSpellingDictionary());
        this.userDictField.setFileSystemAware(false);
        File temp = support.getUserDictionary();
        this.userDictField.setText(temp == null ? "" : temp.getAbsolutePath());
        this.userDictField.setFileSystemAware(true);
        this.spellingColorButton.setColor(support.getSpellCheckingColor());
        this.maxErrorsField.setText(Integer.toString(support.getMaxSpellingErrors()));
        this.viewSpellingWindowCB.setSelected(rtext.isSpellingWindowVisible());
    }

    private class Listener
    implements DocumentListener,
    ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if ("Enabled".equals(command)) {
                boolean enabled = SpellingOptionPanel.this.enabledCB.isSelected();
                SpellingOptionPanel.this.setSpellCheckingEnabled(enabled);
                SpellingOptionPanel.this.hasUnsavedChanges = true;
                SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
            } else if ("Dictionary".equals(command)) {
                SpellingOptionPanel.this.hasUnsavedChanges = true;
                SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
            } else if ("BrowseUserDictionary".equals(command)) {
                int rc;
                if (SpellingOptionPanel.this.chooser == null) {
                    SpellingOptionPanel.this.chooser = new RTextFileChooser();
                }
                if ((rc = SpellingOptionPanel.this.chooser.showOpenDialog(null)) == 0) {
                    File file = SpellingOptionPanel.this.chooser.getSelectedFile();
                    SpellingOptionPanel.this.userDictField.setFileSystemAware(false);
                    SpellingOptionPanel.this.userDictField.setText(file.getAbsolutePath());
                    SpellingOptionPanel.this.userDictField.setFileSystemAware(true);
                    SpellingOptionPanel.this.hasUnsavedChanges = true;
                    SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
                }
            } else if ("ViewSpellingWindow".equals(command)) {
                SpellingOptionPanel.this.hasUnsavedChanges = true;
                SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
            } else if ("RestoreDefaults".equals(command)) {
                File userDictFile = new File(RTextUtilities.getPreferencesDirectory(), "userDictionary.txt");
                String userDictFileName = userDictFile.getAbsolutePath();
                Color defaultColor = RTextPrefs.DEFAULT_SPELLING_ERROR_COLOR;
                String defaultMaxErrors = Integer.toString(30);
                if (SpellingOptionPanel.this.enabledCB.isSelected() || SpellingOptionPanel.this.dictCombo.getSelectedIndex() != 1 || !SpellingOptionPanel.this.userDictField.getText().equals(userDictFileName) || !SpellingOptionPanel.this.spellingColorButton.getColor().equals(defaultColor) || !defaultMaxErrors.equals(SpellingOptionPanel.this.maxErrorsField.getText()) || SpellingOptionPanel.this.viewSpellingWindowCB.isSelected()) {
                    SpellingOptionPanel.this.setSpellCheckingEnabled(false);
                    SpellingOptionPanel.this.dictCombo.setSelectedIndex(1);
                    SpellingOptionPanel.this.userDictField.setFileSystemAware(false);
                    SpellingOptionPanel.this.userDictField.setText(userDictFileName);
                    SpellingOptionPanel.this.userDictField.setFileSystemAware(true);
                    SpellingOptionPanel.this.spellingColorButton.setColor(defaultColor);
                    SpellingOptionPanel.this.maxErrorsField.setText(defaultMaxErrors);
                    SpellingOptionPanel.this.viewSpellingWindowCB.setSelected(false);
                    SpellingOptionPanel.this.hasUnsavedChanges = true;
                    SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            SpellingOptionPanel.this.hasUnsavedChanges = true;
            SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("RColorButton.colorChanged".equals(prop)) {
                SpellingOptionPanel.this.hasUnsavedChanges = true;
                SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            SpellingOptionPanel.this.hasUnsavedChanges = true;
            SpellingOptionPanel.this.firePropertyChange(SpellingOptionPanel.MISC_PROPERTY, null, null);
        }
    }
}

