/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.ReflectionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;

public class VisibilityFocusTraversalPolicy
extends FocusTraversalPolicy {
    private FocusTraversalPolicy _defaultPolicy;
    private Set<Container> _containers;

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy defaultPolicy) {
        this(defaultPolicy, null);
    }

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy defaultPolicy, Container container) {
        if (defaultPolicy != null && ReflectionUtils.isSubClassOf(defaultPolicy, "LegacyGlueFocusTraversalPolicy")) {
            throw new IllegalArgumentException("VisibilityFocusTraversalPolicy can't work well with LegacyGlueFocusTraversalPolicy.");
        }
        this._defaultPolicy = defaultPolicy;
        if (container != null) {
            this._containers = new HashSet<Container>();
            this._containers.add(container);
        }
    }

    public void addContainer(Container container) {
        if (this._containers == null) {
            this._containers = new HashSet<Container>();
        }
        this._containers.add(container);
    }

    public void removeContainer(Container container) {
        if (this._containers != null) {
            this._containers.remove(container);
        }
    }

    public Container[] getContainers() {
        if (this._containers == null) {
            return new Container[0];
        }
        return this._containers.toArray(new Container[this._containers.size()]);
    }

    public FocusTraversalPolicy getDefaultPolicy() {
        return this._defaultPolicy;
    }

    public Component getComponentAfter(Container aContainer, Component aComponent) {
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component = this._defaultPolicy.getComponentAfter(aContainer, aComponent);
        boolean componentChanged = true;
        block0: while (component != null && aComponent != component && componentChanged) {
            componentChanged = false;
            for (Container container : this._containers) {
                if (!container.isAncestorOf(component)) continue;
                Rectangle collapsiblePaneBounds = container.getBounds();
                Container parent = container.getParent();
                Rectangle bounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), parent);
                if (bounds.x < collapsiblePaneBounds.x + collapsiblePaneBounds.width && bounds.x + bounds.width > collapsiblePaneBounds.x && bounds.y < collapsiblePaneBounds.y + collapsiblePaneBounds.height && bounds.y + bounds.height > collapsiblePaneBounds.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentAfter(aContainer, component);
                componentChanged = true;
                continue block0;
            }
        }
        return component;
    }

    public Component getComponentBefore(Container aContainer, Component aComponent) {
        if (this._defaultPolicy == null) {
            return null;
        }
        Component component = this._defaultPolicy.getComponentBefore(aContainer, aComponent);
        boolean componentChanged = true;
        block0: while (component != null && aComponent != component && componentChanged) {
            componentChanged = false;
            for (Container container : this._containers) {
                if (!container.isAncestorOf(component)) continue;
                Rectangle collapsiblePaneBounds = container.getBounds();
                Container parent = container.getParent();
                Rectangle bounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), parent);
                if (bounds.x < collapsiblePaneBounds.x + collapsiblePaneBounds.width && bounds.x + bounds.width > collapsiblePaneBounds.x && bounds.y < collapsiblePaneBounds.y + collapsiblePaneBounds.height && bounds.y + bounds.height > collapsiblePaneBounds.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentBefore(aContainer, component);
                componentChanged = true;
                continue block0;
            }
        }
        return component;
    }

    public Component getFirstComponent(Container aContainer) {
        boolean componentChanged;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component aComponent = component = this._defaultPolicy.getFirstComponent(aContainer);
        block0: do {
            componentChanged = false;
            for (Container container : this._containers) {
                if (!container.isAncestorOf(component)) continue;
                Rectangle collapsiblePaneBounds = container.getBounds();
                Container parent = container.getParent();
                Rectangle bounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), parent);
                if (bounds.x < collapsiblePaneBounds.x + collapsiblePaneBounds.width && bounds.x + bounds.width > collapsiblePaneBounds.x && bounds.y < collapsiblePaneBounds.y + collapsiblePaneBounds.height && bounds.y + bounds.height > collapsiblePaneBounds.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentAfter(aContainer, component);
                componentChanged = true;
                continue block0;
            }
        } while (component != null && aComponent != component && componentChanged);
        return component;
    }

    public Component getLastComponent(Container aContainer) {
        boolean componentChanged;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component aComponent = component = this._defaultPolicy.getLastComponent(aContainer);
        block0: do {
            componentChanged = false;
            for (Container container : this._containers) {
                if (!container.isAncestorOf(component)) continue;
                Rectangle collapsiblePaneBounds = container.getBounds();
                Container parent = container.getParent();
                Rectangle bounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), parent);
                if (bounds.x < collapsiblePaneBounds.x + collapsiblePaneBounds.width && bounds.x + bounds.width > collapsiblePaneBounds.x && bounds.y < collapsiblePaneBounds.y + collapsiblePaneBounds.height && bounds.y + bounds.height > collapsiblePaneBounds.y) {
                    return component;
                }
                component = this._defaultPolicy.getComponentBefore(aContainer, component);
                componentChanged = true;
                continue block0;
            }
        } while (component != null && aComponent != component && componentChanged);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDefaultComponent(Container aContainer) {
        boolean old;
        Component component;
        if (this._defaultPolicy == null) {
            return null;
        }
        Component aComponent = component = this._defaultPolicy.getDefaultComponent(aContainer);
        boolean bl = old = this._defaultPolicy instanceof SortingFocusTraversalPolicy && ((SortingFocusTraversalPolicy)this._defaultPolicy).getImplicitDownCycleTraversal();
        if (this._defaultPolicy instanceof SortingFocusTraversalPolicy) {
            ((SortingFocusTraversalPolicy)this._defaultPolicy).setImplicitDownCycleTraversal(false);
        }
        try {
            boolean componentChanged;
            block4: do {
                componentChanged = false;
                for (Container container : this._containers) {
                    if (!container.isAncestorOf(component)) continue;
                    Rectangle collapsiblePaneBounds = container.getBounds();
                    Container parent = container.getParent();
                    Rectangle bounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), parent);
                    if (bounds.x < collapsiblePaneBounds.x + collapsiblePaneBounds.width && bounds.x + bounds.width > collapsiblePaneBounds.x && bounds.y < collapsiblePaneBounds.y + collapsiblePaneBounds.height && bounds.y + bounds.height > collapsiblePaneBounds.y) {
                        Component component2 = component;
                        return component2;
                    }
                    component = this._defaultPolicy.getComponentAfter(aContainer, component);
                    componentChanged = true;
                    continue block4;
                }
            } while (component != null && aComponent != component && componentChanged);
            Component component3 = component;
            return component3;
        }
        finally {
            if (this._defaultPolicy instanceof SortingFocusTraversalPolicy) {
                ((SortingFocusTraversalPolicy)this._defaultPolicy).setImplicitDownCycleTraversal(old);
            }
        }
    }

    public Component getInitialComponent(Window window) {
        if (this._defaultPolicy == null) {
            return null;
        }
        return this._defaultPolicy.getInitialComponent(window);
    }
}

