/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.framework.FrameworkCommandHistoryList;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.composer.ComposerDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyDescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1DescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.second.Zend2DescriptionProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FrameworkUsageCollector
extends ProjectUsagesCollector {
    @NonNls
    private static final String ZEND1_FRAMEWORK_DESCRIPTOR_KEY = "zend1";
    @NonNls
    private static final String ZEND2_FRAMEWORK_DESCRIPTOR_KEY = "zend2";
    @NonNls
    private static final String SYMFONY_FRAMEWORK_DESCRIPTOR_KEY = "symfony";
    @NonNls
    private static final String COMPOSER_FRAMEWORK_DESCRIPTOR_KEY = "composer";
    @NonNls
    private static final String CUSTOM_FRAMEWORK_DESCRIPTOR_KEY = "custom";
    @NonNls
    private static final String POPUP_CONSOLE_DESCRIPTOR_KEY = "console.in.popup";
    @NonNls
    private static final String TOOLWINDOW_CONSOLE_DESCRIPTOR_KEY = "console.in.toolwindow";

    @NotNull
    public String getGroupId() {
        if ("statistics.php.command.line.tools" == null) {
            FrameworkUsageCollector.$$$reportNull$$$0(0);
        }
        return "statistics.php.command.line.tools";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            FrameworkUsageCollector.$$$reportNull$$$0(1);
        }
        Set<UsageDescriptor> set = FrameworkUsageCollector.collectUsages(project);
        if (set == null) {
            FrameworkUsageCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    static Set<UsageDescriptor> collectUsages(@NotNull Project project) {
        if (project == null) {
            FrameworkUsageCollector.$$$reportNull$$$0(3);
        }
        if (project.isDefault() || project.isDisposed()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                FrameworkUsageCollector.$$$reportNull$$$0(4);
            }
            return set;
        }
        HashSet<String> registeredNames = new HashSet<String>();
        for (FrameworkDescriptionProvider provider : (FrameworkDescriptionProvider[])FrameworkDescriptionProvider.EP.getExtensions()) {
            registeredNames.add(provider.getFrameworkName());
        }
        HashSet<UsageDescriptor> descriptors = new HashSet<UsageDescriptor>();
        int customCount = 0;
        for (String frameworkName : FrameworkCommandHistoryList.getInstance(project).getUsedFrameworkNames()) {
            if (Zend1DescriptionProvider.FRAMEWORK_NAME.equals(frameworkName)) {
                descriptors.add(new UsageDescriptor(ZEND1_FRAMEWORK_DESCRIPTOR_KEY, 1));
                continue;
            }
            if (Zend2DescriptionProvider.FRAMEWORK_NAME.equals(frameworkName)) {
                descriptors.add(new UsageDescriptor(ZEND2_FRAMEWORK_DESCRIPTOR_KEY, 1));
                continue;
            }
            if (SymfonyDescriptionProvider.FRAMEWORK_NAME.equals(frameworkName)) {
                descriptors.add(new UsageDescriptor(SYMFONY_FRAMEWORK_DESCRIPTOR_KEY, 1));
                continue;
            }
            if (ComposerDescriptionProvider.FRAMEWORK_NAME.equals(frameworkName)) {
                descriptors.add(new UsageDescriptor(COMPOSER_FRAMEWORK_DESCRIPTOR_KEY, 1));
                continue;
            }
            if (registeredNames.contains(frameworkName)) {
                descriptors.add(new UsageDescriptor(FrameworkUsageCollector.getProperFrameworkName(frameworkName), 1));
                continue;
            }
            ++customCount;
        }
        if (customCount > 0) {
            descriptors.add(new UsageDescriptor(CUSTOM_FRAMEWORK_DESCRIPTOR_KEY, customCount));
        }
        if (FrameworkCommandHistoryList.getInstance(project).getState().getCommands().size() > 0) {
            descriptors.add(new UsageDescriptor(FrameworkDataService.isConsoleInToolWindow() ? TOOLWINDOW_CONSOLE_DESCRIPTOR_KEY : POPUP_CONSOLE_DESCRIPTOR_KEY, 1));
        }
        HashSet<UsageDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            FrameworkUsageCollector.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static String getProperFrameworkName(String name) {
        char c;
        int i;
        for (i = 0; i < name.length() && Character.isLetterOrDigit(c = name.charAt(i)); ++i) {
        }
        if (i == 0) {
            return "Unknown";
        }
        return name.substring(0, i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/FrameworkUsageCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/FrameworkUsageCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

