/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsSimpleTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsFavoriteListProvider
extends AbstractFavoritesListProvider<Object>
implements BreakpointPanelProvider.BreakpointsListener {
    private final List<BreakpointPanelProvider> myBreakpointPanelProviders;
    private final BreakpointItemsTreeController myTreeController;
    private final List<XBreakpointGroupingRule> myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
    private final Set<XBreakpointGroupingRule> myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
    private final SingleAlarm myRebuildAlarm = new SingleAlarm(this::updateChildren, 100);
    private final FavoritesManager myFavoritesManager;

    public BreakpointsFavoriteListProvider(Project project, FavoritesManager favoritesManager) {
        super(project, "Breakpoints");
        this.myBreakpointPanelProviders = XBreakpointUtil.collectPanelProviders();
        this.myFavoritesManager = favoritesManager;
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesAvailable);
        this.myTreeController.setTreeView((JTree)((Object)new BreakpointsSimpleTree(this.myProject, this.myTreeController)));
        for (BreakpointPanelProvider provider : this.myBreakpointPanelProviders) {
            provider.addListener(this, this.myProject, (Disposable)this.myProject);
            provider.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.updateChildren();
    }

    @Override
    public void breakpointsChanged() {
        this.myRebuildAlarm.cancelAndRequest();
    }

    private void getEnabledGroupingRules(Collection<XBreakpointGroupingRule> rules) {
        rules.clear();
        XBreakpointsDialogState settings = ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager()).getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains((Object)rule.getId()))) continue;
            rules.add(rule);
        }
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (BreakpointPanelProvider provider : this.myBreakpointPanelProviders) {
            provider.provideBreakpointItems(this.myProject, items);
        }
        this.getEnabledGroupingRules(this.myRulesEnabled);
        this.myTreeController.setGroupingRules(this.myRulesEnabled);
        this.myTreeController.rebuildTree(items);
        CheckedTreeNode root = this.myTreeController.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode child2 = root.getChildAt(i);
            if (!(child2 instanceof DefaultMutableTreeNode)) continue;
            this.replicate((DefaultMutableTreeNode)child2, this.myNode, this.myChildren);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    private void replicate(DefaultMutableTreeNode source, AbstractTreeNode destination, List<AbstractTreeNode<Object>> destinationChildren) {
        final ArrayList<AbstractTreeNode<Object>> copyChildren = new ArrayList<AbstractTreeNode<Object>>();
        AbstractTreeNode<Object> copy = new AbstractTreeNode<Object>(this.myProject, source.getUserObject()){

            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                ArrayList arrayList = copyChildren;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            protected void update(@NotNull PresentationData presentation) {
                if (presentation == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        for (int i = 0; i < source.getChildCount(); ++i) {
            TreeNode treeNode = source.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)treeNode;
            this.replicate(sourceChild, (AbstractTreeNode)copy, copyChildren);
        }
        if (BreakpointsFavoriteListProvider.checkNavigatable(copy)) {
            destinationChildren.add(copy);
            copy.setParent(destination);
        }
    }

    private static boolean checkNavigatable(AbstractTreeNode<?> node) {
        if (node.getValue() instanceof Navigatable && ((Navigatable)node.getValue()).canNavigate()) {
            return true;
        }
        return node.getChildren().stream().anyMatch(BreakpointsFavoriteListProvider::checkNavigatable);
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(0);
        }
        switch (type) {
            case EDIT: {
                return "Edit breakpoint";
            }
            case REMOVE: {
                return "Remove breakpoint";
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(1);
        }
        if (selectedObjects == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(2);
        }
        if (selectedObjects.size() >= 1 && type == CommonActionsPanel.Buttons.REMOVE) {
            for (Object selectedObject : selectedObjects) {
                if (((AbstractTreeNode)selectedObject).getValue() instanceof BreakpointItem) continue;
                return false;
            }
            return true;
        }
        return selectedObjects.size() == 1 && type == CommonActionsPanel.Buttons.EDIT && ((AbstractTreeNode)selectedObjects.iterator().next()).getValue() instanceof BreakpointItem;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(3);
        }
        if (selectedObjects == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(4);
        }
        Rectangle bounds2 = component.getBounds();
        if (component instanceof JTree) {
            JTree tree = (JTree)component;
            bounds2 = tree.getRowBounds(tree.getLeadSelectionRow());
            bounds2.y += bounds2.height / 2;
            bounds2 = tree.getVisibleRect().intersection(bounds2);
        }
        Point whereToShow = new Point((int)bounds2.getCenterX(), (int)bounds2.getCenterY());
        switch (type) {
            case EDIT: {
                BreakpointItem breakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObjects.iterator().next()).getValue();
                DebuggerSupport debuggerSupport = XBreakpointUtil.getDebuggerSupport(this.myProject, breakpointItem);
                if (debuggerSupport == null || breakpointItem == null) {
                    return;
                }
                debuggerSupport.getEditBreakpointAction().editBreakpoint(this.myProject, component, whereToShow, breakpointItem);
                break;
            }
            case REMOVE: {
                for (Object selectedObject : selectedObjects) {
                    BreakpointItem removeBreakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObject).getValue();
                    removeBreakpointItem.removed(this.myProject);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 200;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        if (value == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(5);
        }
        renderer.clear();
        renderer.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        if (value instanceof BreakpointItem) {
            BreakpointItem breakpointItem = (BreakpointItem)value;
            breakpointItem.setupGenericRenderer((SimpleColoredComponent)renderer, true);
        } else if (value instanceof XBreakpointGroup) {
            renderer.append(((XBreakpointGroup)value).getName());
            renderer.setIcon(((XBreakpointGroup)value).getIcon(expanded));
        } else if (value instanceof XBreakpointGroupingRule) {
            renderer.append(((XBreakpointGroupingRule)value).getPresentableName());
        } else {
            renderer.append(String.valueOf(value));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedObjects";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "willHandle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

