/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.IOException;
import java.io.Reader;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.util.CStringBuilder;

public class ReaderLexerSource
extends LexerSource {
    private static final int INITIAL_PUSHBACK_SIZE = 100;
    private final Reader in;
    private char[] buf = new char[100];
    private int bufLength = -1;
    private int oneAgo = 10;
    private int twoAgo = 0;

    public ReaderLexerSource(String sourceName, Reader in, int line) {
        super(sourceName, line);
        this.in = in;
    }

    public int read() throws IOException {
        int c;
        if (this.bufLength >= 0) {
            c = this.buf[this.bufLength--];
        } else {
            c = this.wrappedRead();
            if (c == -1) {
                return -1;
            }
        }
        this.advance(c);
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    public void unread(int c) {
        if (c == -1) {
            return;
        }
        this.retreat();
        if (c == 10) {
            --this.line;
        }
        this.buf[++this.bufLength] = (char)c;
        this.growBuf();
    }

    public boolean peek(int to) throws IOException {
        int captureTwoAgo = this.twoAgo;
        int c = this.read();
        this.unread(c);
        this.twoAgo = captureTwoAgo;
        return c == to;
    }

    private void advance(int c) {
        this.twoAgo = this.oneAgo;
        this.oneAgo = c;
        ++this.offset;
    }

    private int carriageReturn(int c) throws IOException {
        c = this.in.read();
        if (c != 10) {
            this.unread((char)c);
            c = 10;
        } else {
            ++this.offset;
        }
        return c;
    }

    private void growBuf() {
        if (this.bufLength + 1 == this.buf.length) {
            char[] newBuf = new char[this.buf.length + 100];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    private void retreat() {
        --this.offset;
        this.oneAgo = this.twoAgo;
        this.twoAgo = 0;
    }

    private int wrappedRead() throws IOException {
        int c = this.in.read();
        if (c == 13) {
            c = this.carriageReturn(c);
        }
        return c;
    }

    public static LexerSource getSource(String name, Reader content, ParserConfiguration configuration) {
        return new ReaderLexerSource(name, content, configuration.getLineNumber());
    }

    public String readLineBytes() throws IOException {
        CStringBuilder list = new CStringBuilder(80);
        int c = this.read();
        while (c != 10 && c != -1) {
            list.append((char)c);
            c = this.read();
        }
        return list.toString();
    }

    public int skipUntil(int c) throws IOException {
        c = this.read();
        while (c != 10 && c != -1) {
            c = this.read();
        }
        return c;
    }

    public void unreadMany(CharSequence buffer) {
        int length = buffer.length();
        for (int i = length - 1; i >= 0; --i) {
            this.unread(buffer.charAt(i));
        }
    }

    public boolean matchMarker(String match, boolean indent, boolean checkNewline) throws IOException {
        int length = match.length();
        CStringBuilder buffer = new CStringBuilder(length + 1);
        if (indent) {
            this.indentLoop(buffer);
        }
        if (!this.matches(match, buffer, length)) {
            return false;
        }
        return this.finishMarker(checkNewline, buffer);
    }

    private void indentLoop(CStringBuilder buffer) throws IOException {
        int c;
        while ((c = this.read()) != -1) {
            if (!Character.isWhitespace(c) || c == 10) {
                this.unread(c);
                break;
            }
            buffer.append((char)c);
        }
    }

    private boolean matches(String match, CStringBuilder buffer, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            buffer.append((char)c);
            if (match.charAt(i) == c) continue;
            this.unreadMany(buffer);
            return false;
        }
        return true;
    }

    private boolean finishMarker(boolean checkNewline, CStringBuilder buffer) throws IOException {
        if (!checkNewline) {
            return true;
        }
        int c = this.read();
        if (c == -1 || c == 10) {
            return true;
        }
        buffer.append((char)c);
        this.unreadMany(buffer);
        return false;
    }

    public boolean wasBeginOfLine() {
        return this.twoAgo == 10;
    }

    public boolean lastWasBeginOfLine() {
        return this.oneAgo == 10;
    }

    public String toString() {
        try {
            int i;
            CStringBuilder buffer = new CStringBuilder(20);
            buffer.append(this.twoAgo);
            buffer.append(this.oneAgo);
            buffer.append(new byte[]{45, 62});
            for (i = 0; i < 20; ++i) {
                int c = this.read();
                if (c == 0) {
                    --i;
                    break;
                }
                buffer.append((char)c);
            }
            while (i >= 0) {
                this.unread(buffer.charAt(i));
                ++i;
            }
            buffer.append(new byte[]{32, 46, 46, 46});
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String readUntil(char marker) throws IOException {
        CStringBuilder list = new CStringBuilder(20);
        int c = this.read();
        while (c != marker && c != -1) {
            list.append((char)c);
            c = this.read();
        }
        if (c == -1) {
            return null;
        }
        this.unread(c);
        return list.toString();
    }

    public int chompReadAhead() {
        int result = this.bufLength + 1;
        this.bufLength = -1;
        return result;
    }

    public boolean isANewLine() {
        return this.oneAgo == 10;
    }

    public void setIsANewLine(boolean nextCharIsOnANewLine) {
        this.oneAgo = nextCharIsOnANewLine ? 10 : this.oneAgo;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

