/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.agent.cli.DockerBuildCliParserBase;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBuildCliBuilder {
    public static final String UNKNOWN_IMAGE_TAG = "<image_tag>";
    private String myDockerFile;
    private String myImageTag;
    private NormalizedCommandLine myCustomBuildOptions;
    private final List<String> myBuildArgValues = new LinkedList<String>();

    public void setDockerFile(@NotNull String path) {
        int lastSlash;
        String dockerFile;
        if (path == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(0);
        }
        String string = dockerFile = (lastSlash = (path = FileUtil.toSystemIndependentName((String)path)).lastIndexOf("/")) >= 0 ? path.substring(lastSlash + "/".length()) : path;
        if ("Dockerfile".equals(dockerFile)) {
            return;
        }
        this.myDockerFile = dockerFile;
    }

    public void setImageTag(@NotNull String imageTag) {
        if (imageTag == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(1);
        }
        this.myImageTag = StringUtil.isEmptyOrSpaces((String)imageTag) ? null : imageTag;
    }

    public void addBuildArg(@NotNull String name, @Nullable String value) {
        if (name == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        this.myBuildArgValues.add(name + (StringUtil.isEmptyOrSpaces((String)value) ? "" : "=" + value));
    }

    public void setCustomBuildOptions(@NotNull NormalizedCommandLine runOptions) {
        if (runOptions == null) {
            DockerBuildCliBuilder.$$$reportNull$$$0(3);
        }
        this.myCustomBuildOptions = runOptions;
    }

    public List<String> buildPreviewLines() {
        String START = "docker build";
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<String> lastLine = new LinkedList<String>();
        if (!this.myBuildArgValues.isEmpty()) {
            Option buildArgsOption = DockerBuildCliParserBase.buildArgsOption();
            if (this.myCustomBuildOptions == null) {
                this.myCustomBuildOptions = new NormalizedCommandLine();
            }
            for (String nextValue : this.myBuildArgValues) {
                this.myCustomBuildOptions.registerOneValue(buildArgsOption, nextValue);
            }
        }
        if (this.myCustomBuildOptions != null) {
            result.add("docker build");
            result.addAll(this.myCustomBuildOptions.groupByOptions());
        } else {
            lastLine.add("docker build");
        }
        if (this.myDockerFile != null) {
            lastLine.add("-f");
            lastLine.add(this.myDockerFile);
        }
        if (this.myImageTag != null) {
            lastLine.add("-t");
            lastLine.add(this.myImageTag);
        }
        lastLine.add(".");
        result.add(StringUtil.join(lastLine, (String)" "));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/cli/DockerBuildCliBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDockerFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setImageTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildArg";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomBuildOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

