/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sqlite.model.SqliteModCheck;
import com.intellij.database.dialects.sqlite.model.SqliteModIndex;
import com.intellij.database.dialects.sqlite.model.SqliteModKey;
import com.intellij.database.dialects.sqlite.model.SqliteModRoot;
import com.intellij.database.dialects.sqlite.model.SqliteModTable;
import com.intellij.database.dialects.sqlite.model.SqliteModTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteModTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteModVirtualTable;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bH\u0014J \u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J1\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H'0,H\u0002\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00020*\u0018\u0001002\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000102H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010B\u001a\u0004\u0018\u0001022\b\u00101\u001a\u0004\u0018\u000102H\u0002\u00a8\u0006C"}, d2={"Lcom/intellij/database/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteModCheck;", "Lcom/intellij/sql/psi/SqlConstraintDefinition;", "complete", "", "buildColumn", "Lcom/intellij/database/dialects/sqlite/model/SqliteModTableColumn;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexFromCreateIndex", "Lcom/intellij/database/dialects/sqlite/model/SqliteModIndex;", "Lcom/intellij/sql/psi/SqlCreateIndexStatement;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteModKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteModTable;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerFromCreateTrigger", "Lcom/intellij/sql/psi/SqlCreateTriggerStatement;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteModVirtualTable;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "name", "", "src", "Lcom/intellij/database/model/families/Family;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "fixName", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getConflictResolution", "Lcom/intellij/database/model/properties/SqliteOnConflictAlgorithm;", "def", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "isDesc", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "isIdentity", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "partialBuild", "skipUnsignificant", "intellij.database.dialects"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof SqliteModTable) {
            this.buildTable((SqliteModTable)obj, source, true);
        } else if (basicModElement instanceof SqliteModTableColumn) {
            this.buildColumn((SqliteModTableColumn)obj, source, true);
        } else if (basicModElement instanceof SqliteModVirtualTable) {
            this.buildVirtualTable((SqliteModVirtualTable)obj, source, true);
        } else if (basicModElement instanceof SqliteModTrigger) {
            this.buildTrigger((BasicModTrigger)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    @Override
    public void partialBuild(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        DasObject dasObject = obj;
        if (dasObject instanceof SqliteModTable) {
            this.buildTable((SqliteModTable)obj, source, false);
        } else if (dasObject instanceof SqliteModTableColumn) {
            this.buildColumn((SqliteModTableColumn)obj, source, false);
        } else if (dasObject instanceof SqliteModVirtualTable) {
            this.buildVirtualTable((SqliteModVirtualTable)obj, source, false);
        } else if (dasObject instanceof SqliteModTrigger) {
            if (source instanceof SqlCreateTriggerStatement) {
                this.buildTriggerFromCreateTrigger((BasicModTrigger)obj, (SqlCreateTriggerStatement)source, false);
            }
        } else if (dasObject instanceof SqliteModIndex) {
            if (source instanceof SqlCreateIndexStatement) {
                this.buildIndexFromCreateIndex((SqliteModIndex)obj, (SqlCreateIndexStatement)source, false);
            }
        } else if (dasObject instanceof SqliteModKey) {
            if (source instanceof SqlTableKeyDefinition) {
                this.buildKeyFromTableKeyDefinition((SqliteModKey)obj, (SqlTableKeyDefinition)source, false);
            }
        } else if (dasObject instanceof SqliteModCheck && source instanceof SqlConstraintDefinition) {
            this.buildCheckFromConstraintDefinition((SqliteModCheck)obj, (SqlConstraintDefinition)source, false);
        }
    }

    private final void buildTable(SqliteModTable obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildBasicElement(obj, source);
        }
        if (source instanceof SqlCreateTableStatement) {
            PsiElement psiElement = (PsiElement)source;
            IElementType iElementType = SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE");
            obj.setWithoutRowId(this.findChild(psiElement, iElementType) != null);
        }
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        ((BasicModModel)obj.getModel()).writeSources(new Runnable(this, obj, source){
            final /* synthetic */ SqliteObjectBuilder this$0;
            final /* synthetic */ BasicModView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlCreateViewStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = sqliteObjectBuilder;
                this.$obj = basicModView;
                this.$source = dasObject;
            }
        });
    }

    @Override
    protected void buildCheck(@NotNull BasicModCheck obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModCheck) || !(source instanceof SqlConstraintDefinition)) {
            super.buildCheck(obj, source);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteModCheck)obj, (SqlConstraintDefinition)source, true);
    }

    private final void buildCheckFromConstraintDefinition(SqliteModCheck obj, SqlConstraintDefinition source, boolean complete) {
        if (complete) {
            super.buildCheck(obj, (DasObject)source);
        }
        obj.setOnConflict(this.getConflictResolution((PsiElement)source));
    }

    private final void buildColumn(SqliteModTableColumn obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildTyped(obj, source);
        }
        if (source instanceof SqlColumnDefinition) {
            PsiElement first$iv$iv;
            SqliteObjectBuilder this_$iv;
            String collationName = null;
            SqliteObjectBuilder sqliteObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlConstraintDefinition)) continue;
                IElementType type = this.getElementType(it);
                if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION)) {
                    SqlExpression collationRef;
                    SqlExpression sqlExpression = collationRef = (SqlExpression)((SqlConstraintDefinition)it).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
                    collationName = sqlExpression != null ? sqlExpression.getText() : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION)) continue;
                obj.setOnNullConflict(this.getConflictResolution(it));
            }
            if (StringsKt.equals((String)"binary", (String)collationName, (boolean)true)) {
                collationName = null;
            }
            BasicModModel basicModModel = (BasicModModel)obj.getModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModModel, (String)"obj.model");
            BasicRoot basicRoot = basicModModel.getRoot();
            if (basicRoot == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.sqlite.model.SqliteModRoot");
            }
            NamingFamily namingFamily = ((SqliteModRoot)basicRoot).getCollations();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"(obj.model.root as SqliteModRoot).collations");
            obj.setCollation(this.fixName(collationName, namingFamily));
            obj.setSequenceIdentity(this.isIdentity((SqlColumnDefinition)source) ? SequenceIdentity.UNKNOWN : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIdentity(SqlColumnDefinition obj) {
        List refs;
        SqlReferenceList refList;
        PsiElement psiElement;
        block7: {
            PsiElement element$iv$iv;
            void el$iv;
            void this_$iv;
            PsiElement psiElement2;
            PsiElement this_$iv2;
            PsiElement el$iv2;
            block6: {
                PsiElement element$iv$iv2;
                PsiElement psiElement3 = (PsiElement)obj;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
                if (this.findChild(psiElement3, (IElementType)sqlCompositeElementType) != null) {
                    return true;
                }
                SqliteObjectBuilder sqliteObjectBuilder = this;
                SqliteObjectBuilder sqliteObjectBuilder2 = this;
                el$iv2 = obj.getParent();
                void var6_5 = this_$iv2;
                PsiElement psiElement4 = el$iv2;
                for (PsiElement tmp$iv$iv = element$iv$iv2 = (v939946) != null ? (v939946).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    if (!(it$iv instanceof SqlTableKeyDefinition)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            this_$iv2 = (PsiElement)((SqlTableKeyDefinition)psiElement2);
            el$iv2 = this_$iv;
            void v4 = el$iv;
            for (PsiElement tmp$iv$iv = element$iv$iv = (v939959) != null ? (v939959).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                if (!(it$iv instanceof SqlReferenceList)) continue;
                psiElement = tmp$iv$iv;
                break block7;
            }
            psiElement = null;
        }
        SqlReferenceList sqlReferenceList = refList = (SqlReferenceList)psiElement;
        List list = refs = sqlReferenceList != null ? sqlReferenceList.getReferenceList() : null;
        if (refs == null || refs.size() != 1) {
            return false;
        }
        PsiElement psiElement5 = (PsiElement)refs.get(0);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
        if (this.findSibling(psiElement5, (IElementType)sqlCompositeElementType) == null) {
            return false;
        }
        Object e = refs.get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"refs[0]");
        String string = this.extractName((PsiElement)e);
        if (string == null) {
            string = "";
        }
        return StringsKt.equals((String)string, (String)obj.getName(), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteModVirtualTable obj, DasObject source, boolean complete) {
        if (complete) {
            this.buildNamedElement(obj, source);
        }
        if (source instanceof SqlCreateStatement) {
            List list;
            SqlClause moduleClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlClause.class);
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)moduleClause), SqlReferenceExpression.class);
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteModVirtualTable sqliteModVirtualTable = obj;
            if (moduleArguments != null) {
                Collection<String> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                SqlClause[] sqlClauseArray = moduleArguments;
                SqliteModVirtualTable sqliteModVirtualTable2 = sqliteModVirtualTable;
                void var8_9 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                void var10_11 = $receiver$iv$iv;
                int n = ((void)var10_11).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var14_15 = item$iv$iv = var10_11[j];
                    collection = destination$iv$iv;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string = v1.getText();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                sqliteModVirtualTable = sqliteModVirtualTable2;
                list = collection;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteModVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj.setModule(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null);
        }
    }

    @Override
    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj instanceof SqliteModKey)) {
            super.buildKey(obj, source);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteModKey)obj, (SqlTableKeyDefinition)source, true);
    }

    private final void buildKeyFromTableKeyDefinition(SqliteModKey obj, SqlTableKeyDefinition source, boolean complete) {
        if (complete) {
            this.buildBasicElement(obj, (DasObject)source);
        }
        obj.setPrimary(source.isPrimary());
        obj.setOnConflict(this.getConflictResolution((PsiElement)source));
    }

    @Override
    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModTrigger)) {
            super.buildTrigger(obj, source);
            return;
        }
        if (source instanceof SqlCreateTriggerStatement) {
            this.buildTriggerFromCreateTrigger(obj, (SqlCreateTriggerStatement)source, true);
        }
        ((BasicModModel)((SqliteModTrigger)obj).getModel()).writeSources(new Runnable(this, obj, source){
            final /* synthetic */ SqliteObjectBuilder this$0;
            final /* synthetic */ BasicModTrigger $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                SqliteModTrigger sqliteModTrigger = (SqliteModTrigger)this.$obj;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateTriggerStatement)) {
                    dasObject = null;
                }
                sqliteModTrigger.setSourceText((object = (SqlCreateTriggerStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = sqliteObjectBuilder;
                this.$obj = basicModTrigger;
                this.$source = dasObject;
            }
        });
    }

    private final void buildTriggerFromCreateTrigger(BasicModTrigger obj, SqlCreateTriggerStatement source, boolean complete) {
        SqlExpression whenExpr;
        SqlWhenClause whenClause;
        PsiElement element2;
        SqlNameElement name;
        if (complete) {
            this.buildBasicElement(obj, (DasObject)source);
        }
        TrigTurn turn = null;
        TrigEvent event = null;
        List<String> cols = null;
        SqlNameElement sqlNameElement = name = source.getNameElement();
        PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
        if (afterName instanceof SqlClause && (element2 = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
            ASTNode aSTNode = element2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
            IElementType iElementType = aSTNode.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
            IElementType type = iElementType;
            event = this.getEvent(type);
            if (event == null) {
                turn = this.getTurn(type);
                PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                if (nextClause instanceof SqlClause && (element2 = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                    ASTNode aSTNode2 = element2.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"element.node");
                    IElementType iElementType2 = aSTNode2.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"element.node.elementType");
                    event = this.getEvent(iElementType2);
                    cols = this.getColumns(nextClause);
                }
            } else {
                cols = this.getColumns(afterName);
            }
        }
        turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
        SqlWhenClause sqlWhenClause = whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhenClause.class);
        SqlExpression sqlExpression = whenExpr = sqlWhenClause != null ? sqlWhenClause.getExpression() : null;
        obj.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
        obj.setTurn(turn);
        List<String> list = cols;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        obj.setColNames(list);
        obj.setEvents(event == null ? SetsKt.emptySet() : SetsKt.setOf((Object)event));
    }

    @Override
    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj instanceof SqliteModIndex)) {
            super.buildIndex(obj, source);
            return;
        }
        if (source instanceof SqlCreateIndexStatement) {
            this.buildIndexFromCreateIndex((SqliteModIndex)obj, (SqlCreateIndexStatement)source, false);
        }
    }

    private final void buildIndexFromCreateIndex(SqliteModIndex obj, SqlCreateIndexStatement source, boolean complete) {
        SqlTableColumnsList columnsList;
        SqlReferenceExpression tableRef;
        SqlExpression whereExpr;
        if (complete) {
            this.buildNamedElement(obj, (DasObject)source);
        }
        SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhereClause.class);
        SqlExpression sqlExpression = whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where), SqlExpression.class);
        obj.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
        SqlReferenceExpression sqlReferenceExpression = tableRef = source.getTargetReference();
        Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
        if (!(object instanceof SqlTableColumnsList)) {
            object = null;
        }
        SqlTableColumnsList sqlTableColumnsList = columnsList = (SqlTableColumnsList)object;
        Object columns = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
        SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns), SqlExpression.class);
        if (columnExprs != null) {
            ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)columnExprs.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"ContainerUtil.newArrayLi\u2026String>(columnExprs.size)");
            ArrayList newNames = arrayList;
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"ContainerUtil.newLinkedHashSet<String>()");
            LinkedHashSet newRev = linkedHashSet;
            for (SqlExpression expr : columnExprs) {
                boolean curRev = false;
                if (expr instanceof SqlReferenceExpression) {
                    String string = ((SqlReferenceExpression)expr).getName();
                    SqliteModTable sqliteModTable = obj.getTable();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqliteModTable, (String)"obj.table");
                    PositioningNamingFamily positioningNamingFamily = sqliteModTable.getColumns();
                    Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"obj.table.columns");
                    newNames.add(this.fixName(string, positioningNamingFamily));
                    curRev = this.isDesc((SqlReferenceExpression)expr);
                } else {
                    SqlExpression sqlExpression2 = expr;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression2, (String)"expr");
                    newNames.add(sqlExpression2.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            obj.setColNames(newNames);
            obj.setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type = this.getElementType(tmp);
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name, Family<?> src) {
        Object obj = this.findObject(name, src);
        if (obj == null || (obj = obj.getName()) == null) {
            obj = name;
        }
        return obj;
    }

    private final <T extends BasicElement> T findObject(String name, Family<T> src) {
        Object v1;
        block2: {
            if (name == null) {
                return null;
            }
            Iterable $receiver$iv = src;
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                if (!StringsKt.equals((String)name, (String)basicElement.getName(), (boolean)true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return (T)((BasicElement)v1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $receiver$iv$iv;
            SqlReferenceExpression[] $receiver$iv;
            SqlReferenceExpression[] sqlReferenceExpressionArray2 = $receiver$iv = sqlReferenceExpressionArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var5_5 = $receiver$iv$iv;
            int n = ((void)var5_5).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = var5_5[j];
                Collection collection = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                String string = v1.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        SqliteOnConflictAlgorithm algo;
        block3: {
            SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
            SqliteOnConflictAlgorithm[] $receiver$iv;
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.getDeepestLast(onConflict)");
            PsiElement how = psiElement2;
            String text2 = how.getText();
            for (SqliteOnConflictAlgorithm element$iv : $receiver$iv = SqliteOnConflictAlgorithm.values()) {
                SqliteOnConflictAlgorithm it = element$iv;
                if (!StringsKt.equals((String)it.toString(), (String)text2, (boolean)true)) continue;
                sqliteOnConflictAlgorithm = element$iv;
                break block3;
            }
            sqliteOnConflictAlgorithm = algo = null;
        }
        if (algo == SqliteOnConflictAlgorithm.ABORT) {
            return null;
        }
        return algo;
    }
}

