/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsContent;

import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.LocalPathIndifferentOperation;
import com.intellij.cvsSupport2.cvsoperations.common.RepositoryPathProvider;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContent;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentListener;
import com.intellij.cvsSupport2.cvsoperations.cvsContent.DirectoryContentProvider;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminReaderOnStoredRepositoryPath;
import com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls.AdminWriterStoringRepositoryPath;
import com.intellij.cvsSupport2.javacvsImpl.io.DeafLocalFileWriter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;

public class GetModuleContentOperation
extends CompositeOperation
implements DirectoryContentProvider {
    private final DirectoryContentListener myDirectoryContentListener = new DirectoryContentListener();
    private DirectoryContentListener myStreamingDirectoryContentListener = new DirectoryContentListener();
    private final AdminWriterStoringRepositoryPath myAdminWriterStoringRepositoryPath;
    private String myModuleLocation;
    @NonNls
    private static final Pattern UPDATING_PATTERN = Pattern.compile("cvs .*: Updating (.+)");
    private Consumer<DirectoryContent> myStreamingListener;
    private long timeStamp = System.currentTimeMillis();

    public GetModuleContentOperation(CvsEnvironment environment, String moduleName) {
        this.myAdminWriterStoringRepositoryPath = new AdminWriterStoringRepositoryPath(moduleName, environment.getCvsRootAsString());
        this.addOperation(this.createExpandingRepositoryPathOperation(this.myAdminWriterStoringRepositoryPath, environment, moduleName));
        this.addOperation(this.createGetModuleContentOperation(this.myAdminWriterStoringRepositoryPath, environment, moduleName));
    }

    private LocalPathIndifferentOperation createGetModuleContentOperation(RepositoryPathProvider adminWriter, CvsEnvironment environment, final String moduleName) {
        LocalPathIndifferentOperation operation = new LocalPathIndifferentOperation(new AdminReaderOnStoredRepositoryPath(adminWriter), environment){
            private boolean myIsInModule;
            {
                super(adminReader, environment);
                this.myIsInModule = false;
            }

            @Override
            protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
                CheckoutCommand result = new CheckoutCommand(null);
                result.addModule(moduleName);
                result.setRecursive(true);
                return result;
            }

            @Override
            protected String getOperationName() {
                return "checkout";
            }

            @Override
            protected ILocalFileWriter createLocalFileWriter(String cvsRoot, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnvironment) {
                return DeafLocalFileWriter.INSTANCE;
            }

            @Override
            public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
                super.messageSent(message, byteMessage, error, tagged);
                GetModuleContentOperation.this.myStreamingDirectoryContentListener.setModulePath(GetModuleContentOperation.this.myAdminWriterStoringRepositoryPath.getModulePath());
                Matcher matcher = UPDATING_PATTERN.matcher(message);
                if (matcher.matches()) {
                    if (GetModuleContentOperation.this.myModuleLocation != null && GetModuleContentOperation.this.myModuleLocation.equals(matcher.group(1))) {
                        this.myIsInModule = true;
                    } else {
                        GetModuleContentOperation.this.myStreamingDirectoryContentListener.messageSent(message);
                        this.myIsInModule = false;
                    }
                } else if (DirectoryContentListener.moduleMessage_ver1(message)) {
                    this.myIsInModule = true;
                }
                if (this.myIsInModule) {
                    GetModuleContentOperation.this.myStreamingDirectoryContentListener.messageSent(message);
                }
                DirectoryContent streamingDirectoryContent = GetModuleContentOperation.this.myStreamingDirectoryContentListener.getDirectoryContent();
                if (GetModuleContentOperation.this.myStreamingListener != null) {
                    long timePassed = System.currentTimeMillis() - GetModuleContentOperation.this.timeStamp;
                    if (streamingDirectoryContent.getTotalSize() > 0 && timePassed > 25L) {
                        GetModuleContentOperation.this.myStreamingListener.consume((Object)streamingDirectoryContent);
                        DirectoryContentListener newListener = new DirectoryContentListener();
                        newListener.setModuleName(GetModuleContentOperation.this.myStreamingDirectoryContentListener.getModuleName());
                        GetModuleContentOperation.this.myStreamingDirectoryContentListener = newListener;
                        GetModuleContentOperation.this.timeStamp = System.currentTimeMillis();
                    }
                } else {
                    GetModuleContentOperation.this.myDirectoryContentListener.getDirectoryContent().copyDataFrom(streamingDirectoryContent);
                }
            }

            @Override
            public void modifyOptions(GlobalOptions options) {
                super.modifyOptions(options);
                options.setDoNoChanges(true);
            }
        };
        operation.addFinishAction(() -> this.myStreamingListener.consume((Object)this.myStreamingDirectoryContentListener.getDirectoryContent()));
        return operation;
    }

    private LocalPathIndifferentOperation createExpandingRepositoryPathOperation(AdminWriterStoringRepositoryPath adminWriter, CvsEnvironment environment, final String moduleName) {
        return new LocalPathIndifferentOperation(adminWriter, environment){

            @Override
            protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
                CheckoutCommand result = new CheckoutCommand(null);
                result.addModule(moduleName);
                result.setRecursive(false);
                return result;
            }

            @Override
            protected ILocalFileWriter createLocalFileWriter(String cvsRoot, UpdatedFilesManager mergedFilesCollector, CvsExecutionEnvironment cvsExecutionEnvironment) {
                return DeafLocalFileWriter.INSTANCE;
            }

            @Override
            protected String getOperationName() {
                return "checkout";
            }

            @Override
            public void moduleExpanded(String module) {
                super.moduleExpanded(module);
                if (GetModuleContentOperation.this.myModuleLocation == null) {
                    GetModuleContentOperation.this.myModuleLocation = module;
                    GetModuleContentOperation.this.myStreamingDirectoryContentListener.setModuleName(GetModuleContentOperation.this.myModuleLocation);
                }
            }
        };
    }

    @Override
    public DirectoryContent getDirectoryContent() {
        return this.myDirectoryContentListener.getDirectoryContent();
    }

    @Override
    public void setStreamingListener(Consumer<DirectoryContent> streamingListener) {
        this.myStreamingListener = streamingListener;
    }
}

