/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.validation;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.refactoring.validation.PhpFunctionConflictDetectorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionConflictDetector
extends PhpFunctionConflictDetectorBase {
    private final Function myFunction;

    public PhpFunctionConflictDetector(Function function) {
        this.myFunction = function;
    }

    @Override
    @Nullable
    public String findConflicts(final @NotNull String newName) {
        PhpScopeHolder scopeHolder;
        if (newName == null) {
            PhpFunctionConflictDetector.$$$reportNull$$$0(0);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)this.myFunction)) == null) {
            return null;
        }
        Condition functionExistCondition = instruction -> {
            Function declaration;
            if (newName == null) {
                PhpFunctionConflictDetector.$$$reportNull$$$0(1);
            }
            if (PhpLangUtil.equalsFunctionNames((declaration = instruction.getFunctionDeclaration()).getName(), newName) || declaration == this.myFunction) {
                final Ref functionNameExists = new Ref((Object)false);
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
                        Function functionDeclaration = instruction.getFunctionDeclaration();
                        if (PhpLangUtil.equalsFunctionNames(functionDeclaration.getName(), newName) || functionDeclaration == PhpFunctionConflictDetector.this.myFunction) {
                            functionNameExists.set((Object)true);
                            return false;
                        }
                        return true;
                    }
                });
                return (Boolean)functionNameExists.get();
            }
            return false;
        };
        return PhpFunctionConflictDetector.validate(scopeHolder, newName, (Condition<? super PhpFunctionDeclarationInstruction>)functionExistCondition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "newName";
        objectArray2[1] = "com/jetbrains/php/refactoring/validation/PhpFunctionConflictDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findConflicts$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

