/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPullPushBaseConflicts {
    protected final PhpClass myClazz;
    protected final Collection<PhpMemberInfo> myMembers;
    protected final MultiMap<PsiElement, String> myConflicts = new MultiMap();

    public PhpPullPushBaseConflicts(PhpClass clazz, Collection<PhpMemberInfo> members) {
        this.myClazz = clazz;
        this.myMembers = members;
    }

    protected void checkInternalReferences(final @NotNull Method method) {
        if (method == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(0);
        }
        final MultiMap usedMembers = new MultiMap();
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processMemberReference((MemberReference)fieldReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.processMemberReference((MemberReference)reference);
            }

            private void processMemberReference(@NotNull MemberReference reference) {
                String name;
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElement member = reference.resolve();
                PhpExpression classRef = reference.getClassReference();
                if (classRef != null && PhpPullPushBaseConflicts.isSpecialReference(name = classRef.getName(), PhpPullPushBaseConflicts.this.myClazz) && member instanceof PhpClassMember) {
                    usedMembers.putValue((Object)name, (Object)((PhpClassMember)member));
                    PhpClass containingClass = ((PhpClassMember)member).getContainingClass();
                    String staticReferenceMessage = PhpPullPushBaseConflicts.this.checkStaticReference(reference, name, containingClass, (PhpClassMember)member);
                    if (staticReferenceMessage != null) {
                        PhpPullPushBaseConflicts.this.myConflicts.putValue((Object)method, (Object)staticReferenceMessage);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldReference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/PhpPullPushBaseConflicts$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPhpFieldReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processMemberReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Map.Entry referenceToMember : usedMembers.entrySet()) {
            for (PhpClassMember member : (Collection)referenceToMember.getValue()) {
                String message;
                if (this.shouldBeMoved(member) || (message = this.checkMemberAccess((String)referenceToMember.getKey(), member)) == null) continue;
                this.myConflicts.putValue((Object)method, (Object)message);
            }
        }
    }

    protected abstract String checkStaticReference(@NotNull MemberReference var1, String var2, PhpClass var3, PhpClassMember var4);

    private static boolean isSpecialReference(@Nullable String reference, @NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(1);
        }
        return PhpLangUtil.equalsClassNames("parent", reference) || PhpLangUtil.equalsClassNames("self", reference) || PhpLangUtil.equalsClassNames("static", reference) || PhpLangUtil.equalsClassNames("this", reference) || PhpLangUtil.equalsClassNames(reference, clazz.getNameCS());
    }

    private boolean shouldBeMoved(@NotNull PhpClassMember member) {
        if (member == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(2);
        }
        for (PhpMemberInfo info : this.myMembers) {
            if (!PhpLangUtil.equalsMethodNames(((PhpClassMember)info.getMember()).getName(), member.getNameCS())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract String checkMemberAccess(@NotNull String var1, @NotNull PhpClassMember var2);

    public void checkTargetClassConflicts(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(3);
        }
        this.checkAlreadyDefinedMembers(phpClass);
    }

    private boolean checkAlreadyDefinedMembers(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(4);
        }
        for (PhpMemberInfo memberInfo : this.myMembers) {
            PhpPsiElement member = (PhpPsiElement)memberInfo.getMember();
            String memberName = member.getName();
            boolean alreadyContainsMember = false;
            if (member instanceof Field) {
                boolean bl = alreadyContainsMember = targetClass.findOwnFieldByName((CharSequence)memberName, ((Field)member).isConstant()) != null;
            }
            if (member instanceof Method) {
                boolean bl = alreadyContainsMember = targetClass.findOwnMethodByName((CharSequence)memberName) != null;
            }
            if (!alreadyContainsMember) continue;
            String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            this.myConflicts.putValue((Object)member, (Object)message);
        }
        return false;
    }

    @NotNull
    public MultiMap<PsiElement, String> getConflicts() {
        MultiMap<PsiElement, String> multiMap = this.myConflicts;
        if (multiMap == null) {
            PhpPullPushBaseConflicts.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/pullPush/PhpPullPushBaseConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/PhpPullPushBaseConflicts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkInternalReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeMoved";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTargetClassConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAlreadyDefinedMembers";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

