/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PhpAbstractMemberConflicts {
    protected final MultiMap<PsiElement, String> myConflicts = new MultiMap();

    @Nullable
    public static String createMessage(List<String> messages) {
        String message = null;
        for (String it : messages) {
            if (it == null || message != null) continue;
            message = it;
        }
        return message;
    }

    public void processClassReference(ClassReference classRef) {
        PsiElement element = classRef.resolve();
        String classReferenceName = classRef.getName();
        if (element != null && element instanceof PhpClass && classReferenceName != null && classReferenceName.equalsIgnoreCase("static")) {
            PsiElement statement = classRef.getParent();
            String statementText = statement != null ? statement.getText() : "";
            PsiElement staticKeyWord = PhpPsiUtil.getChildOfType((PsiElement)classRef, PhpTokenTypes.kwSTATIC);
            if (this.getConflicts().get((Object)staticKeyWord).isEmpty()) {
                this.getConflicts().putValue((Object)staticKeyWord, (Object)PhpBundle.message("refactoring.move.members.late.static.binding.detected", statement != null ? statementText : "", RefactoringUIUtil.getDescription((PsiElement)classRef, (boolean)true)));
            }
        }
    }

    public MultiMap<PsiElement, String> getConflicts() {
        return this.myConflicts;
    }
}

